/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.util.Log;
import android.widget.MediaController;
import com.google.android.exoplayer.ExoPlayer;

public class PlayerControl
implements MediaController.MediaPlayerControl {
    private final ExoPlayer exoPlayer;
    private static final String TAG = "PlayerControl";

    public PlayerControl(ExoPlayer exoPlayer) {
        Log.i((String)TAG, (String)TAG);
        this.exoPlayer = exoPlayer;
    }

    public boolean canPause() {
        Log.i((String)TAG, (String)"canPause");
        return true;
    }

    public boolean canSeekBackward() {
        Log.i((String)TAG, (String)"canSeekBackward");
        return true;
    }

    public boolean canSeekForward() {
        Log.i((String)TAG, (String)"canSeekForward");
        return true;
    }

    public int getAudioSessionId() {
        throw new UnsupportedOperationException();
    }

    public int getBufferPercentage() {
        Log.i((String)TAG, (String)"getBufferPercentage");
        return this.exoPlayer.getBufferedPercentage();
    }

    public int getCurrentPosition() {
        Log.i((String)TAG, (String)"getCurrentPosition");
        return this.exoPlayer.getCurrentPosition();
    }

    public int getDuration() {
        Log.i((String)TAG, (String)"getDuration");
        return this.exoPlayer.getDuration();
    }

    public boolean isPlaying() {
        Log.i((String)TAG, (String)"isPlaying");
        return this.exoPlayer.getPlayWhenReady();
    }

    public void start() {
        Log.i((String)TAG, (String)"start");
        this.exoPlayer.setPlayWhenReady(true);
    }

    public void pause() {
        Log.i((String)TAG, (String)"pause");
        this.exoPlayer.setPlayWhenReady(false);
    }

    public void seekTo(int timeMillis) {
        Log.i((String)TAG, (String)"seekTo");
        this.exoPlayer.seekTo(Math.min(Math.max(0, timeMillis), this.getDuration()));
    }
}

