/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.util;

import android.net.Uri;
import android.os.AsyncTask;
import android.util.Log;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public abstract class ManifestFetcher<T>
extends AsyncTask<String, Void, T> {
    private static final String TAG = "ManifestFetcher";
    public static final int DEFAULT_HTTP_TIMEOUT_MILLIS = 8000;
    private final ManifestCallback<T> callback;
    private final int timeoutMillis;
    private volatile String contentId;
    private volatile Exception exception;

    public ManifestFetcher(ManifestCallback<T> callback) {
        this(callback, 8000);
        Log.d((String)TAG, (String)"ManifestFetcher 2");
    }

    public ManifestFetcher(ManifestCallback<T> callback, int timeoutMillis) {
        Log.d((String)TAG, (String)"ManifestFetcher 1");
        this.callback = callback;
        this.timeoutMillis = timeoutMillis;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final T doInBackground(String ... data) {
        Log.d((String)TAG, (String)"doInBackground");
        try {
            this.contentId = data.length > 1 ? data[1] : null;
            String urlString = data[0];
            String inputEncoding = null;
            InputStream inputStream = null;
            try {
                Uri baseUrl = Util.parseBaseUri(urlString);
                HttpURLConnection connection = this.configureHttpConnection(new URL(urlString));
                inputStream = connection.getInputStream();
                inputEncoding = connection.getContentEncoding();
                Log.d((String)TAG, (String)("call parse inputStream = " + inputStream + " inputEncoding = " + inputEncoding));
                T t = this.parse(inputStream, inputEncoding, this.contentId, baseUrl);
                return t;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            this.exception = e;
            return null;
        }
    }

    protected final void onPostExecute(T manifest) {
        Log.d((String)TAG, (String)"onPostExecute");
        if (this.exception != null) {
            this.callback.onManifestError(this.contentId, this.exception);
        } else {
            this.callback.onManifest(this.contentId, manifest);
        }
    }

    protected abstract T parse(InputStream var1, String var2, String var3, Uri var4) throws IOException, ParserException;

    private HttpURLConnection configureHttpConnection(URL url) throws IOException {
        Log.d((String)TAG, (String)"configureHttpConnection");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(this.timeoutMillis);
        connection.setReadTimeout(this.timeoutMillis);
        connection.setDoOutput(false);
        connection.connect();
        return connection;
    }

    public static interface ManifestCallback<T> {
        public void onManifest(String var1, T var2);

        public void onManifestError(String var1, Exception var2);
    }
}

