/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream.cache;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CacheSpan
implements Comparable<CacheSpan> {
    private static final String SUFFIX = ".v1.exo";
    private static final String SUFFIX_ESCAPED = "\\.v1\\.exo";
    private static final Pattern cacheFilePattern = Pattern.compile("^(.+)\\.(\\d+)\\.(\\d+)(\\.v1\\.exo)$");
    public final String key;
    public final long position;
    public final long length;
    public final boolean isCached;
    public final File file;
    public final long lastAccessTimestamp;

    public static File getCacheFileName(File cacheDir, String key, long offset, long lastAccessTimestamp) {
        return new File(cacheDir, String.valueOf(key) + "." + offset + "." + lastAccessTimestamp + SUFFIX);
    }

    public static CacheSpan createLookup(String key, long position) {
        return new CacheSpan(key, position, -1L, false, -1L, null);
    }

    public static CacheSpan createOpenHole(String key, long position) {
        return new CacheSpan(key, position, -1L, false, -1L, null);
    }

    public static CacheSpan createClosedHole(String key, long position, long length) {
        return new CacheSpan(key, position, length, false, -1L, null);
    }

    public static CacheSpan createCacheEntry(File file) {
        Matcher matcher = cacheFilePattern.matcher(file.getName());
        if (!matcher.matches()) {
            return null;
        }
        return CacheSpan.createCacheEntry(matcher.group(1), Long.parseLong(matcher.group(2)), Long.parseLong(matcher.group(3)), file);
    }

    private static CacheSpan createCacheEntry(String key, long position, long lastAccessTimestamp, File file) {
        return new CacheSpan(key, position, file.length(), true, lastAccessTimestamp, file);
    }

    private CacheSpan(String key, long position, long length, boolean isCached, long lastAccessTimestamp, File file) {
        this.key = key;
        this.position = position;
        this.length = length;
        this.isCached = isCached;
        this.file = file;
        this.lastAccessTimestamp = lastAccessTimestamp;
    }

    public boolean isOpenEnded() {
        return this.length == -1L;
    }

    public CacheSpan touch() {
        long now = System.currentTimeMillis();
        File newCacheFile = CacheSpan.getCacheFileName(this.file.getParentFile(), this.key, this.position, now);
        this.file.renameTo(newCacheFile);
        return CacheSpan.createCacheEntry(this.key, this.position, now, newCacheFile);
    }

    @Override
    public int compareTo(CacheSpan another) {
        if (!this.key.equals(another.key)) {
            return this.key.compareTo(another.key);
        }
        long startOffsetDiff = this.position - another.position;
        return startOffsetDiff == 0L ? 0 : (startOffsetDiff < 0L ? -1 : 1);
    }
}

