/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream.cache;

import android.net.Uri;
import com.google.android.exoplayer.upstream.DataSink;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.FileDataSource;
import com.google.android.exoplayer.upstream.TeeDataSource;
import com.google.android.exoplayer.upstream.cache.Cache;
import com.google.android.exoplayer.upstream.cache.CacheDataSink;
import com.google.android.exoplayer.upstream.cache.CacheSpan;
import com.google.android.exoplayer.util.Assertions;
import java.io.File;
import java.io.IOException;

public final class CacheDataSource
implements DataSource {
    private final Cache cache;
    private final DataSource cacheReadDataSource;
    private final DataSource cacheWriteDataSource;
    private final DataSource upstreamDataSource;
    private final boolean blockOnCache;
    private final boolean ignoreCacheOnError;
    private DataSource currentDataSource;
    private Uri uri;
    private String key;
    private long readPosition;
    private long bytesRemaining;
    private CacheSpan lockedSpan;
    private boolean ignoreCache;

    public CacheDataSource(Cache cache, DataSource upstream, boolean blockOnCache, boolean ignoreCacheOnError) {
        this(cache, upstream, blockOnCache, ignoreCacheOnError, Long.MAX_VALUE);
    }

    public CacheDataSource(Cache cache, DataSource upstream, boolean blockOnCache, boolean ignoreCacheOnError, long maxCacheFileSize) {
        this(cache, upstream, new FileDataSource(), new CacheDataSink(cache, maxCacheFileSize), blockOnCache, ignoreCacheOnError);
    }

    public CacheDataSource(Cache cache, DataSource upstream, DataSource cacheReadDataSource, DataSink cacheWriteDataSink, boolean blockOnCache, boolean ignoreCacheOnError) {
        this.cache = cache;
        this.cacheReadDataSource = cacheReadDataSource;
        this.blockOnCache = blockOnCache;
        this.ignoreCacheOnError = ignoreCacheOnError;
        this.upstreamDataSource = upstream;
        this.cacheWriteDataSource = cacheWriteDataSink != null ? new TeeDataSource(upstream, cacheWriteDataSink) : null;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        Assertions.checkState(dataSpec.uriIsFullStream);
        Assertions.checkState(dataSpec.length != -1L);
        try {
            this.uri = dataSpec.uri;
            this.key = dataSpec.key;
            this.readPosition = dataSpec.position;
            this.bytesRemaining = dataSpec.length;
            this.openNextSource();
            return dataSpec.length;
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int max) throws IOException {
        try {
            int num = this.currentDataSource.read(buffer, offset, max);
            if (num >= 0) {
                this.readPosition += (long)num;
                this.bytesRemaining -= (long)num;
            } else {
                this.closeCurrentSource();
                if (this.bytesRemaining > 0L) {
                    this.openNextSource();
                    return this.read(buffer, offset, max);
                }
            }
            return num;
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeCurrentSource();
        }
        catch (IOException e) {
            this.handleBeforeThrow(e);
            throw e;
        }
    }

    private void openNextSource() throws IOException {
        try {
            DataSpec dataSpec;
            CacheSpan span = this.ignoreCache ? null : (this.blockOnCache ? this.cache.startReadWrite(this.key, this.readPosition) : this.cache.startReadWriteNonBlocking(this.key, this.readPosition));
            if (span == null) {
                this.currentDataSource = this.upstreamDataSource;
                dataSpec = new DataSpec(this.uri, this.readPosition, this.bytesRemaining, this.key);
            } else if (span.isCached) {
                Uri fileUri = Uri.fromFile((File)span.file);
                long filePosition = this.readPosition - span.position;
                long length = Math.min(span.length - filePosition, this.bytesRemaining);
                dataSpec = new DataSpec(fileUri, this.readPosition, length, this.key, filePosition);
                this.currentDataSource = this.cacheReadDataSource;
            } else {
                this.lockedSpan = span;
                long length = span.isOpenEnded() ? this.bytesRemaining : Math.min(span.length, this.bytesRemaining);
                dataSpec = new DataSpec(this.uri, this.readPosition, length, this.key);
                this.currentDataSource = this.cacheWriteDataSource != null ? this.cacheWriteDataSource : this.upstreamDataSource;
            }
            this.currentDataSource.open(dataSpec);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void closeCurrentSource() throws IOException {
        if (this.currentDataSource == null) {
            return;
        }
        try {
            this.currentDataSource.close();
            this.currentDataSource = null;
        }
        finally {
            if (this.lockedSpan != null) {
                this.cache.releaseHoleSpan(this.lockedSpan);
                this.lockedSpan = null;
            }
        }
    }

    private void handleBeforeThrow(IOException exception) {
        if (this.ignoreCacheOnError && (this.currentDataSource == this.cacheReadDataSource || exception instanceof CacheDataSink.CacheDataSinkException)) {
            this.ignoreCache = true;
        }
    }
}

