/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import java.io.IOException;
import java.util.PriorityQueue;

public final class NetworkLock {
    public static final NetworkLock instance = new NetworkLock();
    public static final int STREAMING_PRIORITY = 0;
    public static final int DOWNLOAD_PRIORITY = 10;
    private final PriorityQueue<Integer> queue = new PriorityQueue();

    private NetworkLock() {
    }

    public synchronized void proceed(int priority) throws InterruptedException {
        while (this.queue.peek() < priority) {
            this.wait();
        }
    }

    public synchronized boolean proceedNonBlocking(int priority) {
        return this.queue.peek() >= priority;
    }

    public synchronized void proceedOrThrow(int priority) throws PriorityTooLowException {
        int highestPriority = this.queue.peek();
        if (highestPriority < priority) {
            throw new PriorityTooLowException(priority, highestPriority);
        }
    }

    public synchronized void add(int priority) {
        this.queue.add(priority);
    }

    public synchronized void remove(int priority) {
        this.queue.remove(priority);
        this.notifyAll();
    }

    public static class PriorityTooLowException
    extends IOException {
        public PriorityTooLowException(int priority, int highestPriority) {
            super("Priority too low [priority=" + priority + ", highest=" + highestPriority + "]");
        }
    }
}

