/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

public final class Loader {
    private static final int MSG_END_OF_SOURCE = 0;
    private static final int MSG_ERROR = 1;
    private final ExecutorService downloadExecutorService;
    private final Listener listener;
    private LoadTask currentTask;
    private boolean loading;

    public Loader(String threadName, Listener listener) {
        this.downloadExecutorService = Util.newSingleThreadExecutor(threadName);
        this.listener = listener;
    }

    public void startLoading(Loadable loadable) {
        Assertions.checkState(!this.loading);
        this.loading = true;
        this.currentTask = new LoadTask(loadable);
        this.downloadExecutorService.submit(this.currentTask);
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void cancelLoading() {
        Assertions.checkState(this.loading);
        this.currentTask.quit();
    }

    public void release() {
        if (this.loading) {
            this.cancelLoading();
        }
        this.downloadExecutorService.shutdown();
    }

    public static interface Listener {
        public void onCanceled();

        public void onLoaded();

        public void onError(IOException var1);
    }

    @SuppressLint(value={"HandlerLeak"})
    private final class LoadTask
    extends Handler
    implements Runnable {
        private static final String TAG = "LoadTask";
        private final Loadable loadable;
        private volatile Thread executorThread;

        public LoadTask(Loadable loadable) {
            this.loadable = loadable;
        }

        public void quit() {
            this.loadable.cancelLoad();
            if (this.executorThread != null) {
                this.executorThread.interrupt();
            }
        }

        @Override
        public void run() {
            try {
                this.executorThread = Thread.currentThread();
                if (!this.loadable.isLoadCanceled()) {
                    this.loadable.load();
                }
                this.sendEmptyMessage(0);
            }
            catch (IOException e) {
                this.obtainMessage(1, e).sendToTarget();
            }
            catch (InterruptedException e) {
                Assertions.checkState(this.loadable.isLoadCanceled());
                this.sendEmptyMessage(0);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Unexpected error loading stream", (Throwable)e);
                this.obtainMessage(1, new UnexpectedLoaderException(e)).sendToTarget();
            }
        }

        public void handleMessage(Message msg) {
            this.onFinished();
            if (this.loadable.isLoadCanceled()) {
                Loader.this.listener.onCanceled();
                return;
            }
            switch (msg.what) {
                case 0: {
                    Loader.this.listener.onLoaded();
                    break;
                }
                case 1: {
                    Loader.this.listener.onError((IOException)msg.obj);
                }
            }
        }

        private void onFinished() {
            Loader.this.loading = false;
            Loader.this.currentTask = null;
        }
    }

    public static interface Loadable {
        public void cancelLoad();

        public boolean isLoadCanceled();

        public void load() throws IOException, InterruptedException;
    }

    public static final class UnexpectedLoaderException
    extends IOException {
        public UnexpectedLoaderException(Exception cause) {
            super("Unexpected " + cause.getClass().getSimpleName() + ": " + cause.getMessage(), cause);
        }
    }
}

