/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.text.TextUtils;
import android.util.Log;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.upstream.UnexpectedLengthException;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Predicate;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpDataSource
implements DataSource {
    public static final Predicate<String> REJECT_PAYWALL_TYPES = new Predicate<String>(){

        @Override
        public boolean evaluate(String contentType) {
            return !TextUtils.isEmpty((CharSequence)(contentType = Util.toLowerInvariant(contentType))) && (!contentType.contains("text") || contentType.contains("text/vtt")) && !contentType.contains("html") && !contentType.contains("xml");
        }
    };
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 8000;
    public static final int DEFAULT_READ_TIMEOUT_MILLIS = 8000;
    private static final String TAG = "HttpDataSource";
    private static final Pattern CONTENT_RANGE_HEADER = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final String userAgent;
    private final Predicate<String> contentTypePredicate;
    private final HashMap<String, String> requestProperties;
    private final TransferListener listener;
    private DataSpec dataSpec;
    private HttpURLConnection connection;
    private InputStream inputStream;
    private boolean opened;
    private long dataLength;
    private long bytesRead;

    public HttpDataSource(String userAgent, Predicate<String> contentTypePredicate) {
        this(userAgent, contentTypePredicate, null);
    }

    public HttpDataSource(String userAgent, Predicate<String> contentTypePredicate, TransferListener listener) {
        this(userAgent, contentTypePredicate, listener, 8000, 8000);
    }

    public HttpDataSource(String userAgent, Predicate<String> contentTypePredicate, TransferListener listener, int connectTimeoutMillis, int readTimeoutMillis) {
        this.userAgent = Assertions.checkNotEmpty(userAgent);
        this.contentTypePredicate = contentTypePredicate;
        this.listener = listener;
        this.requestProperties = new HashMap();
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestProperty(String name, String value) {
        Assertions.checkNotNull(name);
        Assertions.checkNotNull(value);
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            this.requestProperties.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRequestProperty(String name) {
        Assertions.checkNotNull(name);
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            this.requestProperties.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllRequestProperties() {
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            this.requestProperties.clear();
        }
    }

    @Override
    public long open(DataSpec dataSpec) throws HttpDataSourceException {
        int responseCode;
        this.dataSpec = dataSpec;
        this.bytesRead = 0L;
        try {
            this.connection = this.makeConnection(dataSpec);
        }
        catch (IOException e) {
            throw new HttpDataSourceException("Unable to connect to " + dataSpec.uri.toString(), e, dataSpec);
        }
        try {
            responseCode = this.connection.getResponseCode();
        }
        catch (IOException e) {
            throw new HttpDataSourceException("Unable to connect to " + dataSpec.uri.toString(), e, dataSpec);
        }
        if (responseCode < 200 || responseCode > 299) {
            Map<String, List<String>> headers = this.connection.getHeaderFields();
            this.closeConnection();
            throw new InvalidResponseCodeException(responseCode, headers, dataSpec);
        }
        String contentType = this.connection.getContentType();
        if (this.contentTypePredicate != null && !this.contentTypePredicate.evaluate(contentType)) {
            this.closeConnection();
            throw new InvalidContentTypeException(contentType, dataSpec);
        }
        long contentLength = this.getContentLength(this.connection);
        long l = this.dataLength = dataSpec.length == -1L ? contentLength : dataSpec.length;
        if (this.dataLength == -1L) {
            throw new HttpDataSourceException(new UnexpectedLengthException(-1L, -1L), dataSpec);
        }
        if (dataSpec.length != -1L && contentLength != -1L && contentLength != dataSpec.length) {
            this.closeConnection();
            throw new HttpDataSourceException(new UnexpectedLengthException(dataSpec.length, contentLength), dataSpec);
        }
        try {
            this.inputStream = this.connection.getInputStream();
        }
        catch (IOException e) {
            this.closeConnection();
            throw new HttpDataSourceException(e, dataSpec);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart();
        }
        return this.dataLength;
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws HttpDataSourceException {
        int read = 0;
        try {
            read = this.inputStream.read(buffer, offset, readLength);
        }
        catch (IOException e) {
            throw new HttpDataSourceException(e, this.dataSpec);
        }
        if (read > 0) {
            this.bytesRead += (long)read;
            if (this.listener != null) {
                this.listener.onBytesTransferred(read);
            }
        } else if (this.dataLength != this.bytesRead) {
            throw new HttpDataSourceException(new UnexpectedLengthException(this.dataLength, this.bytesRead), this.dataSpec);
        }
        return read;
    }

    @Override
    public void close() throws HttpDataSourceException {
        block7: {
            try {
                if (this.inputStream == null) break block7;
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    throw new HttpDataSourceException(e, this.dataSpec);
                }
                this.inputStream = null;
            }
            finally {
                if (this.opened) {
                    this.opened = false;
                    if (this.listener != null) {
                        this.listener.onTransferEnd();
                    }
                    this.closeConnection();
                }
            }
        }
    }

    private void closeConnection() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
    }

    protected final HttpURLConnection getConnection() {
        return this.connection;
    }

    protected final long bytesRead() {
        return this.bytesRead;
    }

    protected final long bytesRemaining() {
        return this.dataLength - this.bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection makeConnection(DataSpec dataSpec) throws IOException {
        URL url = new URL(dataSpec.uri.toString());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(this.connectTimeoutMillis);
        connection.setReadTimeout(this.readTimeoutMillis);
        connection.setDoOutput(false);
        HashMap<String, String> hashMap = this.requestProperties;
        synchronized (hashMap) {
            for (Map.Entry<String, String> property : this.requestProperties.entrySet()) {
                connection.setRequestProperty(property.getKey(), property.getValue());
            }
        }
        connection.setRequestProperty("Accept-Encoding", "deflate");
        connection.setRequestProperty("User-Agent", this.userAgent);
        connection.setRequestProperty("Range", this.buildRangeHeader(dataSpec));
        connection.connect();
        return connection;
    }

    private String buildRangeHeader(DataSpec dataSpec) {
        String rangeRequest = "bytes=" + dataSpec.position + "-";
        if (dataSpec.length != -1L) {
            rangeRequest = String.valueOf(rangeRequest) + (dataSpec.position + dataSpec.length - 1L);
        }
        return rangeRequest;
    }

    private long getContentLength(HttpURLConnection connection) {
        Matcher matcher;
        String contentRangeHeader;
        long contentLength = -1L;
        String contentLengthHeader = connection.getHeaderField("Content-Length");
        if (!TextUtils.isEmpty((CharSequence)contentLengthHeader)) {
            try {
                contentLength = Long.parseLong(contentLengthHeader);
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)("Unexpected Content-Length [" + contentLengthHeader + "]"));
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(contentRangeHeader = connection.getHeaderField("Content-Range"))) && (matcher = CONTENT_RANGE_HEADER.matcher(contentRangeHeader)).find()) {
            try {
                long contentLengthFromRange = Long.parseLong(matcher.group(2)) - Long.parseLong(matcher.group(1)) + 1L;
                if (contentLength < 0L) {
                    contentLength = contentLengthFromRange;
                } else if (contentLength != contentLengthFromRange) {
                    Log.w((String)TAG, (String)("Inconsistent headers [" + contentLengthHeader + "] [" + contentRangeHeader + "]"));
                    contentLength = Math.max(contentLength, contentLengthFromRange);
                }
            }
            catch (NumberFormatException e) {
                Log.e((String)TAG, (String)("Unexpected Content-Range [" + contentRangeHeader + "]"));
            }
        }
        if (contentLength == -1L) {
            Log.w((String)TAG, (String)("Unable to parse content length [" + contentLengthHeader + "] [" + contentRangeHeader + "]"));
        }
        return contentLength;
    }

    public static class HttpDataSourceException
    extends IOException {
        public final DataSpec dataSpec;

        public HttpDataSourceException(DataSpec dataSpec) {
            this.dataSpec = dataSpec;
        }

        public HttpDataSourceException(String message, DataSpec dataSpec) {
            super(message);
            this.dataSpec = dataSpec;
        }

        public HttpDataSourceException(IOException cause, DataSpec dataSpec) {
            super(cause);
            this.dataSpec = dataSpec;
        }

        public HttpDataSourceException(String message, IOException cause, DataSpec dataSpec) {
            super(message, cause);
            this.dataSpec = dataSpec;
        }
    }

    public static final class InvalidContentTypeException
    extends HttpDataSourceException {
        public final String contentType;

        public InvalidContentTypeException(String contentType, DataSpec dataSpec) {
            super("Invalid content type: " + contentType, dataSpec);
            this.contentType = contentType;
        }
    }

    public static final class InvalidResponseCodeException
    extends HttpDataSourceException {
        public final int responseCode;
        public final Map<String, List<String>> headerFields;

        public InvalidResponseCodeException(int responseCode, Map<String, List<String>> headerFields, DataSpec dataSpec) {
            super("Response code: " + responseCode, dataSpec);
            this.responseCode = responseCode;
            this.headerFields = headerFields;
        }
    }
}

