/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class FileDataSource
implements DataSource {
    private RandomAccessFile file;
    private long bytesRemaining;

    @Override
    public long open(DataSpec dataSpec) throws FileDataSourceException {
        try {
            this.file = new RandomAccessFile(dataSpec.uri.getPath(), "r");
            this.file.seek(dataSpec.position);
            this.bytesRemaining = dataSpec.length == -1L ? this.file.length() - dataSpec.position : dataSpec.length;
            return this.bytesRemaining;
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int readLength) throws FileDataSourceException {
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int bytesRead = 0;
        try {
            bytesRead = this.file.read(buffer, offset, (int)Math.min(this.bytesRemaining, (long)readLength));
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        this.bytesRemaining -= (long)bytesRead;
        return bytesRead;
    }

    @Override
    public void close() throws FileDataSourceException {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                throw new FileDataSourceException(e);
            }
            this.file = null;
        }
    }

    public static class FileDataSourceException
    extends IOException {
        public FileDataSourceException(IOException cause) {
            super(cause);
        }
    }
}

