/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.os.Handler;
import android.util.Log;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import com.google.android.exoplayer.upstream.TransferListener;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Clock;
import com.google.android.exoplayer.util.SlidingPercentile;
import com.google.android.exoplayer.util.SystemClock;

public class DefaultBandwidthMeter
implements BandwidthMeter,
TransferListener {
    private static final String TAG = "DefaultBandwidthMeter";
    private static final int DEFAULT_MAX_WEIGHT = 2000;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final Clock clock;
    private final SlidingPercentile slidingPercentile;
    private long accumulator;
    private long startTimeMs;
    private long bandwidthEstimate;
    private int streamCount;

    public DefaultBandwidthMeter() {
        this(null, null);
    }

    public DefaultBandwidthMeter(Handler eventHandler, EventListener eventListener) {
        this(eventHandler, eventListener, new SystemClock());
    }

    public DefaultBandwidthMeter(Handler eventHandler, EventListener eventListener, Clock clock) {
        this(eventHandler, eventListener, clock, 2000);
    }

    public DefaultBandwidthMeter(Handler eventHandler, EventListener eventListener, int maxWeight) {
        this(eventHandler, eventListener, new SystemClock(), maxWeight);
    }

    public DefaultBandwidthMeter(Handler eventHandler, EventListener eventListener, Clock clock, int maxWeight) {
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.clock = clock;
        this.slidingPercentile = new SlidingPercentile(maxWeight);
        this.bandwidthEstimate = -1L;
    }

    @Override
    public synchronized long getEstimate() {
        Log.i((String)TAG, (String)("in getEstimate, bandwidthEstimate = " + this.bandwidthEstimate));
        return this.bandwidthEstimate;
    }

    @Override
    public synchronized void onTransferStart() {
        if (this.streamCount == 0) {
            this.startTimeMs = this.clock.elapsedRealtime();
        }
        ++this.streamCount;
    }

    @Override
    public synchronized void onBytesTransferred(int bytes) {
        this.accumulator += (long)bytes;
    }

    @Override
    public synchronized void onTransferEnd() {
        Assertions.checkState(this.streamCount > 0);
        long nowMs = this.clock.elapsedRealtime();
        int elapsedMs = (int)(nowMs - this.startTimeMs);
        if (elapsedMs > 0) {
            float bytesPerSecond = this.accumulator * 1000L / (long)elapsedMs;
            this.slidingPercentile.addSample(this.computeWeight(this.accumulator), bytesPerSecond);
            float bandwidthEstimateFloat = this.slidingPercentile.getPercentile(0.5f);
            Log.i((String)TAG, (String)("in onTransferEnd, bandwidthEstimate = " + this.bandwidthEstimate));
            this.bandwidthEstimate = Float.isNaN(bandwidthEstimateFloat) ? -1L : (long)bandwidthEstimateFloat;
            Log.i((String)TAG, (String)("in onTransferEnd, after calculate bandwidthEstimate = " + this.bandwidthEstimate));
            this.notifyBandwidthSample(elapsedMs, this.accumulator, this.bandwidthEstimate);
        }
        --this.streamCount;
        if (this.streamCount > 0) {
            this.startTimeMs = nowMs;
        }
        this.accumulator = 0L;
    }

    private int computeWeight(long mediaBytes) {
        return (int)Math.sqrt(mediaBytes);
    }

    private void notifyBandwidthSample(final int elapsedMs, final long bytes, final long bandwidthEstimate) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    DefaultBandwidthMeter.this.eventListener.onBandwidthSample(elapsedMs, bytes, bandwidthEstimate);
                }
            });
        }
    }

    public static interface EventListener {
        public void onBandwidthSample(int var1, long var2, long var4);
    }
}

