/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import android.net.Uri;
import com.google.android.exoplayer.util.Assertions;

public final class DataSpec {
    public static final int LENGTH_UNBOUNDED = -1;
    public final Uri uri;
    public final boolean uriIsFullStream;
    public final long absoluteStreamPosition;
    public final long position;
    public final long length;
    public final String key;

    public DataSpec(Uri uri, long absoluteStreamPosition, long length, String key) {
        this(uri, absoluteStreamPosition, length, key, absoluteStreamPosition, true);
    }

    public DataSpec(Uri uri, long absoluteStreamPosition, long length, String key, long position) {
        this(uri, absoluteStreamPosition, length, key, position, false);
    }

    public DataSpec(Uri uri, long absoluteStreamPosition, long length, String key, long position, boolean uriIsFullStream) {
        Assertions.checkArgument(absoluteStreamPosition >= 0L);
        Assertions.checkArgument(position >= 0L);
        Assertions.checkArgument(length > 0L || length == -1L);
        Assertions.checkArgument(absoluteStreamPosition == position || !uriIsFullStream);
        this.uri = uri;
        this.uriIsFullStream = uriIsFullStream;
        this.absoluteStreamPosition = absoluteStreamPosition;
        this.position = position;
        this.length = length;
        this.key = key;
    }

    public String toString() {
        return "DataSpec[" + this.uri + ", " + this.uriIsFullStream + ", " + this.absoluteStreamPosition + ", " + this.position + ", " + this.length + ", " + this.key + "]";
    }
}

