/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.Allocation;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import com.google.android.exoplayer.upstream.UnexpectedLengthException;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class DataSourceStream
implements Loader.Loadable,
NonBlockingInputStream {
    private final DataSource dataSource;
    private final DataSpec dataSpec;
    private final Allocator allocator;
    private final ReadHead readHead;
    private Allocation allocation;
    private volatile boolean loadCanceled;
    private volatile long loadPosition;
    private volatile long resolvedLength;
    private int writeFragmentIndex;
    private int writeFragmentOffset;
    private int writeFragmentRemainingLength;

    public DataSourceStream(DataSource dataSource, DataSpec dataSpec, Allocator allocator) {
        Assertions.checkState(dataSpec.length <= Integer.MAX_VALUE);
        this.dataSource = dataSource;
        this.dataSpec = dataSpec;
        this.allocator = allocator;
        this.resolvedLength = -1L;
        this.readHead = new ReadHead();
    }

    public void resetReadPosition() {
        this.readHead.reset();
    }

    public long getReadPosition() {
        return this.readHead.position;
    }

    public long getLoadPosition() {
        return this.loadPosition;
    }

    public long getLength() {
        return this.resolvedLength != -1L ? this.resolvedLength : this.dataSpec.length;
    }

    public boolean isLoadFinished() {
        return this.resolvedLength != -1L && this.loadPosition == this.resolvedLength;
    }

    public final byte[] getLoadedData() {
        if (this.loadPosition == 0L) {
            return null;
        }
        byte[] rawData = new byte[(int)this.loadPosition];
        this.read(null, rawData, 0, new ReadHead(), rawData.length);
        return rawData;
    }

    @Override
    public long getAvailableByteCount() {
        return this.loadPosition - (long)this.readHead.position;
    }

    @Override
    public boolean isEndOfStream() {
        return this.resolvedLength != -1L && (long)this.readHead.position == this.resolvedLength;
    }

    @Override
    public void close() {
        if (this.allocation != null) {
            this.allocation.release();
            this.allocation = null;
        }
    }

    @Override
    public int skip(int skipLength) {
        return this.read(null, null, 0, this.readHead, skipLength);
    }

    @Override
    public int read(ByteBuffer target1, int readLength) {
        return this.read(target1, null, 0, this.readHead, readLength);
    }

    @Override
    public int read(byte[] target, int offset, int readLength) {
        return this.read(null, target, offset, this.readHead, readLength);
    }

    private int read(ByteBuffer target, byte[] targetArray, int targetArrayOffset, ReadHead readHead, int readLength) {
        if (this.isEndOfStream()) {
            return -1;
        }
        int bytesToRead = (int)Math.min(this.loadPosition - (long)readHead.position, (long)readLength);
        if (bytesToRead == 0) {
            return 0;
        }
        if (readHead.position == 0) {
            readHead.fragmentIndex = 0;
            readHead.fragmentOffset = this.allocation.getFragmentOffset(0);
            readHead.fragmentRemaining = this.allocation.getFragmentLength(0);
        }
        int bytesRead = 0;
        byte[][] buffers = this.allocation.getBuffers();
        while (bytesRead < bytesToRead) {
            int bufferReadLength = Math.min(readHead.fragmentRemaining, bytesToRead - bytesRead);
            if (target != null) {
                target.put(buffers[readHead.fragmentIndex], readHead.fragmentOffset, bufferReadLength);
            } else if (targetArray != null) {
                System.arraycopy(buffers[readHead.fragmentIndex], readHead.fragmentOffset, targetArray, targetArrayOffset, bufferReadLength);
                targetArrayOffset += bufferReadLength;
            }
            ReadHead readHead2 = readHead;
            readHead2.position = readHead2.position + bufferReadLength;
            bytesRead += bufferReadLength;
            ReadHead readHead3 = readHead;
            readHead3.fragmentOffset = readHead3.fragmentOffset + bufferReadLength;
            ReadHead readHead4 = readHead;
            readHead4.fragmentRemaining = readHead4.fragmentRemaining - bufferReadLength;
            if (readHead.fragmentRemaining != 0 || (long)readHead.position >= this.resolvedLength) continue;
            ReadHead readHead5 = readHead;
            readHead5.fragmentIndex = readHead5.fragmentIndex + 1;
            readHead.fragmentOffset = this.allocation.getFragmentOffset(readHead.fragmentIndex);
            readHead.fragmentRemaining = this.allocation.getFragmentLength(readHead.fragmentIndex);
        }
        return bytesRead;
    }

    @Override
    public void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public boolean isLoadCanceled() {
        return this.loadCanceled;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load() throws IOException, InterruptedException {
        if (this.loadCanceled) return;
        if (this.isLoadFinished()) {
            return;
        }
        try {
            block18: {
                byte[][] buffers;
                int read;
                block17: {
                    DataSpec loadDataSpec;
                    if (this.resolvedLength == -1L) {
                        loadDataSpec = this.dataSpec;
                        this.resolvedLength = this.dataSource.open(loadDataSpec);
                        if (this.resolvedLength > Integer.MAX_VALUE) {
                            throw new DataSourceStreamLoadException(new UnexpectedLengthException(this.dataSpec.length, this.resolvedLength));
                        }
                    } else {
                        loadDataSpec = new DataSpec(this.dataSpec.uri, this.dataSpec.position + this.loadPosition, this.resolvedLength - this.loadPosition, this.dataSpec.key);
                        this.dataSource.open(loadDataSpec);
                    }
                    if (this.allocation == null) {
                        this.allocation = this.allocator.allocate((int)this.resolvedLength);
                    }
                    if (this.loadPosition == 0L) {
                        this.writeFragmentIndex = 0;
                        this.writeFragmentOffset = this.allocation.getFragmentOffset(0);
                        this.writeFragmentRemainingLength = this.allocation.getFragmentLength(0);
                    }
                    read = Integer.MAX_VALUE;
                    buffers = this.allocation.getBuffers();
                    if (!true) break block17;
                    if (this.loadCanceled) return;
                    if (this.loadPosition >= this.resolvedLength) return;
                    if (read <= 0) break block18;
                }
                do {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    int writeLength = (int)Math.min((long)this.writeFragmentRemainingLength, this.resolvedLength - this.loadPosition);
                    read = this.dataSource.read(buffers[this.writeFragmentIndex], this.writeFragmentOffset, writeLength);
                    if (read > 0) {
                        this.loadPosition += (long)read;
                        this.writeFragmentOffset += read;
                        this.writeFragmentRemainingLength -= read;
                        if (this.writeFragmentRemainingLength == 0 && this.loadPosition < this.resolvedLength) {
                            ++this.writeFragmentIndex;
                            this.writeFragmentOffset = this.allocation.getFragmentOffset(this.writeFragmentIndex);
                            this.writeFragmentRemainingLength = this.allocation.getFragmentLength(this.writeFragmentIndex);
                        }
                    } else if (this.resolvedLength != this.loadPosition) {
                        throw new DataSourceStreamLoadException(new UnexpectedLengthException(this.resolvedLength, this.loadPosition));
                    }
                    if (this.loadCanceled) return;
                    if (this.loadPosition >= this.resolvedLength) return;
                } while (read > 0);
            }
            return;
        }
        finally {
            Util.closeQuietly(this.dataSource);
        }
    }

    public static class DataSourceStreamLoadException
    extends IOException {
        public DataSourceStreamLoadException(IOException cause) {
            super(cause);
        }
    }

    private static class ReadHead {
        private int position;
        private int fragmentIndex;
        private int fragmentOffset;
        private int fragmentRemaining;

        private ReadHead() {
        }

        public void reset() {
            this.position = 0;
            this.fragmentIndex = 0;
            this.fragmentOffset = 0;
            this.fragmentRemaining = 0;
        }
    }
}

