/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.io.InputStream;

public class DataSourceInputStream
extends InputStream {
    private final DataSource dataSource;
    private final DataSpec dataSpec;
    private final byte[] singleByteArray;
    private boolean opened = false;
    private boolean closed = false;

    public DataSourceInputStream(DataSource dataSource, DataSpec dataSpec) {
        this.dataSource = dataSource;
        this.dataSpec = dataSpec;
        this.singleByteArray = new byte[1];
    }

    @Override
    public int read() throws IOException {
        this.read(this.singleByteArray);
        return this.singleByteArray[0];
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        Assertions.checkState(!this.closed);
        this.checkOpened();
        return this.dataSource.read(buffer, offset, length);
    }

    @Override
    public long skip(long byteCount) throws IOException {
        Assertions.checkState(!this.closed);
        this.checkOpened();
        return super.skip(byteCount);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.dataSource.close();
            this.closed = true;
        }
    }

    private void checkOpened() throws IOException {
        if (!this.opened) {
            this.dataSource.open(this.dataSpec);
            this.opened = true;
        }
    }
}

