/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.DataSink;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.util.Assertions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class ByteArrayDataSink
implements DataSink {
    private ByteArrayOutputStream stream;

    @Override
    public DataSink open(DataSpec dataSpec) throws IOException {
        if (dataSpec.length == -1L) {
            this.stream = new ByteArrayOutputStream();
        } else {
            Assertions.checkArgument(dataSpec.length <= Integer.MAX_VALUE);
            this.stream = new ByteArrayOutputStream((int)dataSpec.length);
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.stream.write(buffer, offset, length);
    }

    public byte[] getData() {
        return this.stream == null ? null : this.stream.toByteArray();
    }
}

