/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.upstream;

import com.google.android.exoplayer.upstream.Allocation;
import com.google.android.exoplayer.upstream.Allocator;
import com.google.android.exoplayer.util.Assertions;
import java.util.Arrays;

public final class BufferPool
implements Allocator {
    private static final int INITIAL_RECYCLED_BUFFERS_CAPACITY = 100;
    public final int bufferLength;
    private int allocatedBufferCount;
    private int recycledBufferCount;
    private byte[][] recycledBuffers;

    public BufferPool(int bufferLength) {
        Assertions.checkArgument(bufferLength > 0);
        this.bufferLength = bufferLength;
        this.recycledBuffers = new byte[100][];
    }

    @Override
    public synchronized int getAllocatedSize() {
        return this.allocatedBufferCount * this.bufferLength;
    }

    @Override
    public synchronized void trim(int targetSize) {
        int targetBufferCount = (targetSize + this.bufferLength - 1) / this.bufferLength;
        int targetRecycledBufferCount = Math.max(0, targetBufferCount - this.allocatedBufferCount);
        if (targetRecycledBufferCount < this.recycledBufferCount) {
            Arrays.fill((Object[])this.recycledBuffers, targetRecycledBufferCount, this.recycledBufferCount, null);
            this.recycledBufferCount = targetRecycledBufferCount;
        }
    }

    @Override
    public synchronized Allocation allocate(int size) {
        int requiredBufferCount = this.requiredBufferCount(size);
        this.allocatedBufferCount += requiredBufferCount;
        byte[][] buffers = new byte[requiredBufferCount][];
        int i = 0;
        while (i < requiredBufferCount) {
            buffers[i] = this.recycledBufferCount > 0 ? this.recycledBuffers[--this.recycledBufferCount] : new byte[this.bufferLength];
            ++i;
        }
        return new AllocationImpl(buffers);
    }

    synchronized void release(AllocationImpl allocation) {
        byte[][] buffers = allocation.getBuffers();
        this.allocatedBufferCount -= buffers.length;
        int newRecycledBufferCount = this.recycledBufferCount + buffers.length;
        if (this.recycledBuffers.length < newRecycledBufferCount) {
            byte[][] newRecycledBuffers = new byte[newRecycledBufferCount * 2][];
            if (this.recycledBufferCount > 0) {
                System.arraycopy(this.recycledBuffers, 0, newRecycledBuffers, 0, this.recycledBufferCount);
            }
            this.recycledBuffers = newRecycledBuffers;
        }
        System.arraycopy(buffers, 0, this.recycledBuffers, this.recycledBufferCount, buffers.length);
        this.recycledBufferCount = newRecycledBufferCount;
    }

    private int requiredBufferCount(long size) {
        return (int)((size + (long)this.bufferLength - 1L) / (long)this.bufferLength);
    }

    private class AllocationImpl
    implements Allocation {
        private byte[][] buffers;

        public AllocationImpl(byte[][] buffers) {
            this.buffers = buffers;
        }

        @Override
        public byte[][] getBuffers() {
            return this.buffers;
        }

        @Override
        public int getFragmentOffset(int index) {
            return 0;
        }

        @Override
        public int getFragmentLength(int index) {
            return BufferPool.this.bufferLength;
        }

        @Override
        public void release() {
            if (this.buffers != null) {
                BufferPool.this.release(this);
                this.buffers = null;
            }
        }
    }
}

