/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text.ttml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

final class TtmlNode {
    public static final long UNDEFINED_TIME = -1L;
    public static final String TAG_TT = "tt";
    public static final String TAG_HEAD = "head";
    public static final String TAG_BODY = "body";
    public static final String TAG_DIV = "div";
    public static final String TAG_P = "p";
    public static final String TAG_SPAN = "span";
    public static final String TAG_BR = "br";
    public static final String TAG_STYLE = "style";
    public static final String TAG_STYLING = "styling";
    public static final String TAG_LAYOUT = "layout";
    public static final String TAG_REGION = "region";
    public static final String TAG_METADATA = "metadata";
    public static final String TAG_SMPTE_IMAGE = "smpte:image";
    public static final String TAG_SMPTE_DATA = "smpte:data";
    public static final String TAG_SMPTE_INFORMATION = "smpte:information";
    public final String tag;
    public final boolean isTextNode;
    public final String text;
    public final long startTimeUs;
    public final long endTimeUs;
    private List<TtmlNode> children;

    public static TtmlNode buildTextNode(String text) {
        return new TtmlNode(null, TtmlNode.applySpacePolicy(text, true), -1L, -1L);
    }

    public static TtmlNode buildNode(String tag, long startTimeUs, long endTimeUs) {
        return new TtmlNode(tag, null, startTimeUs, endTimeUs);
    }

    private TtmlNode(String tag, String text, long startTimeUs, long endTimeUs) {
        this.tag = tag;
        this.text = text;
        this.isTextNode = text != null;
        this.startTimeUs = startTimeUs;
        this.endTimeUs = endTimeUs;
    }

    public boolean isActive(long timeUs) {
        return this.startTimeUs == -1L && this.endTimeUs == -1L || this.startTimeUs <= timeUs && this.endTimeUs == -1L || this.startTimeUs == -1L && timeUs < this.endTimeUs || this.startTimeUs <= timeUs && timeUs < this.endTimeUs;
    }

    public void addChild(TtmlNode child) {
        if (this.children == null) {
            this.children = new ArrayList<TtmlNode>();
        }
        this.children.add(child);
    }

    public TtmlNode getChild(int index) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.children.get(index);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public long[] getEventTimesUs() {
        TreeSet<Long> eventTimeSet = new TreeSet<Long>();
        this.getEventTimes(eventTimeSet, false);
        long[] eventTimes = new long[eventTimeSet.size()];
        Iterator<Long> eventTimeIterator = eventTimeSet.iterator();
        int i = 0;
        while (eventTimeIterator.hasNext()) {
            long eventTimeUs = eventTimeIterator.next();
            eventTimes[i++] = eventTimeUs;
        }
        return eventTimes;
    }

    private void getEventTimes(TreeSet<Long> out, boolean descendsPNode) {
        boolean isPNode = TAG_P.equals(this.tag);
        if (descendsPNode || isPNode) {
            if (this.startTimeUs != -1L) {
                out.add(this.startTimeUs);
            }
            if (this.endTimeUs != -1L) {
                out.add(this.endTimeUs);
            }
        }
        if (this.children == null) {
            return;
        }
        int i = 0;
        while (i < this.children.size()) {
            this.children.get(i).getEventTimes(out, descendsPNode || isPNode);
            ++i;
        }
    }

    public String getText(long timeUs) {
        StringBuilder builder = new StringBuilder();
        this.getText(timeUs, builder, false);
        return TtmlNode.applySpacePolicy(builder.toString().replaceAll("\n$", ""), false);
    }

    private void getText(long timeUs, StringBuilder builder, boolean descendsPNode) {
        if (this.isTextNode && descendsPNode) {
            builder.append(this.text);
        } else if (TAG_BR.equals(this.tag) && descendsPNode) {
            builder.append("\n");
        } else if (!TAG_METADATA.equals(this.tag) && this.isActive(timeUs)) {
            boolean isPNode = TAG_P.equals(this.tag);
            int length = builder.length();
            int i = 0;
            while (i < this.getChildCount()) {
                this.getChild(i).getText(timeUs, builder, descendsPNode || isPNode);
                ++i;
            }
            if (isPNode && length != builder.length()) {
                builder.append("\n");
            }
        }
    }

    private static String applySpacePolicy(String in, boolean treatLineFeedAsSpace) {
        String out = in.replaceAll("\r\n", "\n");
        out = out.replaceAll(" *\n *", "\n");
        out = treatLineFeedAsSpace ? out.replaceAll("\n", " ") : out;
        out = out.replaceAll("[ \t\\x0B\f\r]+", " ");
        return out;
    }
}

