/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.text;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.FormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.text.Subtitle;
import com.google.android.exoplayer.text.SubtitleParser;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.VerboseLogUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;

@TargetApi(value=16)
public class TextTrackRenderer
extends TrackRenderer
implements Handler.Callback {
    private static final String TAG = "TextTrackRenderer";
    private static final int MSG_UPDATE_OVERLAY = 0;
    private final Handler textRendererHandler;
    private final TextRenderer textRenderer;
    private final SampleSource source;
    private final SampleHolder sampleHolder;
    private final FormatHolder formatHolder;
    private final SubtitleParser subtitleParser;
    private int trackIndex;
    private long currentPositionUs;
    private boolean inputStreamEnded;
    private Subtitle subtitle;
    private int nextSubtitleEventIndex;
    private boolean textRendererNeedsUpdate;

    public TextTrackRenderer(SampleSource source, SubtitleParser subtitleParser, TextRenderer textRenderer, Looper textRendererLooper) {
        this.source = Assertions.checkNotNull(source);
        this.subtitleParser = Assertions.checkNotNull(subtitleParser);
        this.textRenderer = Assertions.checkNotNull(textRenderer);
        this.textRendererHandler = textRendererLooper == null ? null : new Handler(textRendererLooper, (Handler.Callback)this);
        this.formatHolder = new FormatHolder();
        this.sampleHolder = new SampleHolder(true);
    }

    @Override
    protected int doPrepare() throws ExoPlaybackException {
        try {
            boolean sourcePrepared = this.source.prepare();
            if (!sourcePrepared) {
                return 0;
            }
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
        int i = 0;
        while (i < this.source.getTrackCount()) {
            if (this.subtitleParser.canParse(this.source.getTrackInfo((int)i).mimeType)) {
                this.trackIndex = i;
                return 1;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected void onEnabled(long timeUs, boolean joining) {
        this.source.enable(this.trackIndex, timeUs);
        this.seekToInternal(timeUs);
    }

    @Override
    protected void seekTo(long timeUs) {
        this.source.seekToUs(timeUs);
        this.seekToInternal(timeUs);
    }

    private void seekToInternal(long timeUs) {
        this.inputStreamEnded = false;
        this.currentPositionUs = timeUs;
        this.source.seekToUs(timeUs);
        if (this.subtitle != null && (timeUs < this.subtitle.getStartTime() || this.subtitle.getLastEventTime() <= timeUs)) {
            this.subtitle = null;
        }
        this.resetSampleData();
        this.clearTextRenderer();
        this.syncNextEventIndex(timeUs);
        this.textRendererNeedsUpdate = this.subtitle != null;
    }

    @Override
    protected void doSomeWork(long timeUs) throws ExoPlaybackException {
        this.source.continueBuffering(timeUs);
        this.currentPositionUs = timeUs;
        if (this.subtitle != null) {
            long nextEventTimeUs = this.getNextEventTime();
            while (nextEventTimeUs <= timeUs) {
                ++this.nextSubtitleEventIndex;
                nextEventTimeUs = this.getNextEventTime();
                this.textRendererNeedsUpdate = true;
            }
            if (nextEventTimeUs == Long.MAX_VALUE) {
                this.subtitle = null;
            }
        }
        if (this.subtitle == null) {
            boolean resetSampleHolder = false;
            try {
                try {
                    int result = this.source.readData(this.trackIndex, timeUs, this.formatHolder, this.sampleHolder, false);
                    if (result == -3) {
                        resetSampleHolder = true;
                        ByteArrayInputStream subtitleInputStream = new ByteArrayInputStream(this.sampleHolder.data.array(), 0, this.sampleHolder.size);
                        this.subtitle = this.subtitleParser.parse(subtitleInputStream, "UTF-8", this.sampleHolder.timeUs);
                        this.syncNextEventIndex(timeUs);
                        this.textRendererNeedsUpdate = true;
                    } else if (result == -1) {
                        this.inputStreamEnded = true;
                    }
                }
                catch (IOException e) {
                    resetSampleHolder = true;
                    throw new ExoPlaybackException(e);
                }
            }
            finally {
                if (resetSampleHolder) {
                    this.resetSampleData();
                }
            }
        }
        if (this.textRendererNeedsUpdate && this.getState() == 3) {
            this.textRendererNeedsUpdate = false;
            if (this.subtitle == null) {
                this.clearTextRenderer();
            } else {
                this.updateTextRenderer(timeUs);
            }
        }
    }

    @Override
    protected void onDisabled() {
        this.source.disable(this.trackIndex);
        this.subtitle = null;
        this.resetSampleData();
        this.clearTextRenderer();
    }

    @Override
    protected void onReleased() {
        this.source.release();
    }

    @Override
    protected long getCurrentPositionUs() {
        return this.currentPositionUs;
    }

    @Override
    protected long getDurationUs() {
        return this.source.getTrackInfo((int)this.trackIndex).durationUs;
    }

    @Override
    protected long getBufferedPositionUs() {
        return -3L;
    }

    @Override
    protected boolean isEnded() {
        return this.inputStreamEnded && this.subtitle == null;
    }

    @Override
    protected boolean isReady() {
        return true;
    }

    private void syncNextEventIndex(long timeUs) {
        this.nextSubtitleEventIndex = this.subtitle == null ? -1 : this.subtitle.getNextEventTimeIndex(timeUs);
    }

    private long getNextEventTime() {
        return this.nextSubtitleEventIndex == -1 || this.nextSubtitleEventIndex >= this.subtitle.getEventTimeCount() ? Long.MAX_VALUE : this.subtitle.getEventTime(this.nextSubtitleEventIndex);
    }

    private void resetSampleData() {
        if (this.sampleHolder.data != null) {
            this.sampleHolder.data.position(0);
        }
    }

    private void updateTextRenderer(long timeUs) {
        String text = this.subtitle.getText(timeUs);
        this.log("updateTextRenderer; text=: " + text);
        if (this.textRendererHandler != null) {
            this.textRendererHandler.obtainMessage(0, (Object)text).sendToTarget();
        } else {
            this.invokeTextRenderer(text);
        }
    }

    private void clearTextRenderer() {
        this.log("clearTextRenderer");
        if (this.textRendererHandler != null) {
            this.textRendererHandler.obtainMessage(0, null).sendToTarget();
        } else {
            this.invokeTextRenderer(null);
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.invokeTextRenderer((String)msg.obj);
                return true;
            }
        }
        return false;
    }

    private void invokeTextRenderer(String text) {
        this.textRenderer.onText(text);
    }

    private void log(String logMessage) {
        if (VerboseLogUtil.isTagEnabled(TAG)) {
            Log.v((String)TAG, (String)("type=2, " + logMessage));
        }
    }

    public static interface TextRenderer {
        public void onText(String var1);
    }
}

