/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.smoothstreaming;

import android.util.Base64;
import android.util.Pair;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.parser.mp4.CodecSpecificDataUtil;
import com.google.android.exoplayer.smoothstreaming.SmoothStreamingManifest;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SmoothStreamingManifestParser {
    private final XmlPullParserFactory xmlParserFactory;

    public SmoothStreamingManifestParser() {
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    public SmoothStreamingManifest parse(InputStream inputStream, String inputEncoding) throws XmlPullParserException, IOException, ParserException {
        XmlPullParser xmlParser = this.xmlParserFactory.newPullParser();
        xmlParser.setInput(inputStream, inputEncoding);
        SmoothStreamMediaParser smoothStreamMediaParser = new SmoothStreamMediaParser(null);
        return (SmoothStreamingManifest)smoothStreamMediaParser.parse(xmlParser);
    }

    private static abstract class ElementParser {
        private final String tag;
        private final ElementParser parent;
        private final List<Pair<String, Object>> normalizedAttributes;

        public ElementParser(String tag, ElementParser parent) {
            this.tag = tag;
            this.parent = parent;
            this.normalizedAttributes = new LinkedList<Pair<String, Object>>();
        }

        public final Object parse(XmlPullParser xmlParser) throws XmlPullParserException, IOException, ParserException {
            boolean foundStartTag = false;
            while (true) {
                int eventType = xmlParser.getEventType();
                switch (eventType) {
                    case 2: {
                        String tagName = xmlParser.getName();
                        if (this.tag.equals(tagName)) {
                            foundStartTag = true;
                            this.parseStartTag(xmlParser);
                            break;
                        }
                        if (!foundStartTag) break;
                        if (this.handleChildInline(tagName)) {
                            this.parseStartTag(xmlParser);
                            break;
                        }
                        this.addChild(this.newChildParser(this, tagName).parse(xmlParser));
                        break;
                    }
                    case 4: {
                        if (!foundStartTag) break;
                        this.parseText(xmlParser);
                        break;
                    }
                    case 3: {
                        if (!foundStartTag) break;
                        String tagName = xmlParser.getName();
                        this.parseEndTag(xmlParser);
                        if (this.handleChildInline(tagName)) break;
                        return this.build();
                    }
                    case 1: {
                        return null;
                    }
                }
                xmlParser.next();
            }
        }

        private ElementParser newChildParser(ElementParser parent, String name) {
            if ("QualityLevel".equals(name)) {
                return new TrackElementParser(parent);
            }
            if ("Protection".equals(name)) {
                return new ProtectionElementParser(parent);
            }
            if ("StreamIndex".equals(name)) {
                return new StreamElementParser(parent);
            }
            return null;
        }

        protected final void putNormalizedAttribute(String key, Object value) {
            this.normalizedAttributes.add((Pair<String, Object>)Pair.create((Object)key, (Object)value));
        }

        protected final Object getNormalizedAttribute(String key) {
            int i = 0;
            while (i < this.normalizedAttributes.size()) {
                Pair<String, Object> pair = this.normalizedAttributes.get(i);
                if (((String)pair.first).equals(key)) {
                    return pair.second;
                }
                ++i;
            }
            return this.parent == null ? null : this.parent.getNormalizedAttribute(key);
        }

        protected boolean handleChildInline(String tagName) {
            return false;
        }

        protected void parseStartTag(XmlPullParser xmlParser) throws ParserException {
        }

        protected void parseText(XmlPullParser xmlParser) throws ParserException {
        }

        protected void parseEndTag(XmlPullParser xmlParser) throws ParserException {
        }

        protected void addChild(Object parsedChild) {
        }

        protected abstract Object build();

        protected final String parseRequiredString(XmlPullParser parser, String key) throws MissingFieldException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                return value;
            }
            throw new MissingFieldException(key);
        }

        protected final int parseInt(XmlPullParser parser, String key, int defaultValue) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException(e);
                }
            }
            return defaultValue;
        }

        protected final int parseRequiredInt(XmlPullParser parser, String key) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException(e);
                }
            }
            throw new MissingFieldException(key);
        }

        protected final long parseLong(XmlPullParser parser, String key, long defaultValue) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException(e);
                }
            }
            return defaultValue;
        }

        protected final long parseRequiredLong(XmlPullParser parser, String key) throws ParserException {
            String value = parser.getAttributeValue(null, key);
            if (value != null) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new ParserException(e);
                }
            }
            throw new MissingFieldException(key);
        }
    }

    public static class MissingFieldException
    extends ParserException {
        public MissingFieldException(String fieldName) {
            super("Missing required field: " + fieldName);
        }
    }

    private static class ProtectionElementParser
    extends ElementParser {
        public static final String TAG = "Protection";
        public static final String TAG_PROTECTION_HEADER = "ProtectionHeader";
        public static final String KEY_SYSTEM_ID = "SystemID";
        private UUID uuid;
        private byte[] initData;

        public ProtectionElementParser(ElementParser parent) {
            super(TAG, parent);
        }

        @Override
        public boolean handleChildInline(String tag) {
            return TAG_PROTECTION_HEADER.equals(tag);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) {
            if (!TAG_PROTECTION_HEADER.equals(parser.getName())) {
                return;
            }
            String uuidString = parser.getAttributeValue(null, KEY_SYSTEM_ID);
            this.uuid = UUID.fromString(uuidString);
        }

        @Override
        public void parseText(XmlPullParser parser) {
            this.initData = Base64.decode((String)parser.getText(), (int)0);
        }

        @Override
        public Object build() {
            return new SmoothStreamingManifest.ProtectionElement(this.uuid, this.initData);
        }
    }

    private static class SmoothStreamMediaParser
    extends ElementParser {
        public static final String TAG = "SmoothStreamingMedia";
        private static final String KEY_MAJOR_VERSION = "MajorVersion";
        private static final String KEY_MINOR_VERSION = "MinorVersion";
        private static final String KEY_TIME_SCALE = "TimeScale";
        private static final String KEY_DURATION = "Duration";
        private static final String KEY_LOOKAHEAD_COUNT = "LookaheadCount";
        private int majorVersion;
        private int minorVersion;
        private long timeScale;
        private long duration;
        private int lookAheadCount = -1;
        private SmoothStreamingManifest.ProtectionElement protectionElement = null;
        private List<SmoothStreamingManifest.StreamElement> streamElements = new LinkedList<SmoothStreamingManifest.StreamElement>();

        public SmoothStreamMediaParser(ElementParser parent) {
            super(TAG, parent);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) throws ParserException {
            this.majorVersion = this.parseRequiredInt(parser, KEY_MAJOR_VERSION);
            this.minorVersion = this.parseRequiredInt(parser, KEY_MINOR_VERSION);
            this.timeScale = this.parseLong(parser, KEY_TIME_SCALE, 10000000L);
            this.duration = this.parseRequiredLong(parser, KEY_DURATION);
            this.lookAheadCount = this.parseInt(parser, KEY_LOOKAHEAD_COUNT, -1);
            this.putNormalizedAttribute(KEY_TIME_SCALE, this.timeScale);
        }

        @Override
        public void addChild(Object child) {
            if (child instanceof SmoothStreamingManifest.StreamElement) {
                this.streamElements.add((SmoothStreamingManifest.StreamElement)child);
            } else if (child instanceof SmoothStreamingManifest.ProtectionElement) {
                Assertions.checkState(this.protectionElement == null);
                this.protectionElement = (SmoothStreamingManifest.ProtectionElement)child;
            }
        }

        @Override
        public Object build() {
            SmoothStreamingManifest.StreamElement[] streamElementArray = new SmoothStreamingManifest.StreamElement[this.streamElements.size()];
            this.streamElements.toArray(streamElementArray);
            return new SmoothStreamingManifest(this.majorVersion, this.minorVersion, this.timeScale, this.duration, this.lookAheadCount, this.protectionElement, streamElementArray);
        }
    }

    private static class StreamElementParser
    extends ElementParser {
        public static final String TAG = "StreamIndex";
        private static final String TAG_STREAM_FRAGMENT = "c";
        private static final String KEY_TYPE = "Type";
        private static final String KEY_TYPE_AUDIO = "audio";
        private static final String KEY_TYPE_VIDEO = "video";
        private static final String KEY_TYPE_TEXT = "text";
        private static final String KEY_SUB_TYPE = "Subtype";
        private static final String KEY_NAME = "Name";
        private static final String KEY_CHUNKS = "Chunks";
        private static final String KEY_QUALITY_LEVELS = "QualityLevels";
        private static final String KEY_URL = "Url";
        private static final String KEY_MAX_WIDTH = "MaxWidth";
        private static final String KEY_MAX_HEIGHT = "MaxHeight";
        private static final String KEY_DISPLAY_WIDTH = "DisplayWidth";
        private static final String KEY_DISPLAY_HEIGHT = "DisplayHeight";
        private static final String KEY_LANGUAGE = "Language";
        private static final String KEY_TIME_SCALE = "TimeScale";
        private static final String KEY_FRAGMENT_DURATION = "d";
        private static final String KEY_FRAGMENT_START_TIME = "t";
        private final List<SmoothStreamingManifest.TrackElement> tracks = new LinkedList<SmoothStreamingManifest.TrackElement>();
        private int type;
        private String subType;
        private long timeScale;
        private String name;
        private int qualityLevels;
        private String url;
        private int maxWidth;
        private int maxHeight;
        private int displayWidth;
        private int displayHeight;
        private String language;
        private long[] startTimes;
        private int chunkIndex;
        private long previousChunkDuration;

        public StreamElementParser(ElementParser parent) {
            super(TAG, parent);
        }

        @Override
        public boolean handleChildInline(String tag) {
            return TAG_STREAM_FRAGMENT.equals(tag);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) throws ParserException {
            if (TAG_STREAM_FRAGMENT.equals(parser.getName())) {
                this.parseStreamFragmentStartTag(parser);
            } else {
                this.parseStreamElementStartTag(parser);
            }
        }

        private void parseStreamFragmentStartTag(XmlPullParser parser) throws ParserException {
            this.startTimes[this.chunkIndex] = this.parseLong(parser, KEY_FRAGMENT_START_TIME, -1L);
            if (this.startTimes[this.chunkIndex] == -1L) {
                if (this.chunkIndex == 0) {
                    this.startTimes[this.chunkIndex] = 0L;
                } else if (this.previousChunkDuration != -1L) {
                    this.startTimes[this.chunkIndex] = this.startTimes[this.chunkIndex - 1] + this.previousChunkDuration;
                } else {
                    throw new ParserException("Unable to infer start time");
                }
            }
            this.previousChunkDuration = this.parseLong(parser, KEY_FRAGMENT_DURATION, -1L);
            ++this.chunkIndex;
        }

        private void parseStreamElementStartTag(XmlPullParser parser) throws ParserException {
            this.type = this.parseType(parser);
            this.putNormalizedAttribute(KEY_TYPE, this.type);
            this.subType = this.type == 2 ? this.parseRequiredString(parser, KEY_SUB_TYPE) : parser.getAttributeValue(null, KEY_SUB_TYPE);
            this.name = parser.getAttributeValue(null, KEY_NAME);
            this.qualityLevels = this.parseInt(parser, KEY_QUALITY_LEVELS, -1);
            this.url = this.parseRequiredString(parser, KEY_URL);
            this.maxWidth = this.parseInt(parser, KEY_MAX_WIDTH, -1);
            this.maxHeight = this.parseInt(parser, KEY_MAX_HEIGHT, -1);
            this.displayWidth = this.parseInt(parser, KEY_DISPLAY_WIDTH, -1);
            this.displayHeight = this.parseInt(parser, KEY_DISPLAY_HEIGHT, -1);
            this.language = parser.getAttributeValue(null, KEY_LANGUAGE);
            this.timeScale = this.parseInt(parser, KEY_TIME_SCALE, -1);
            if (this.timeScale == -1L) {
                this.timeScale = (Long)this.getNormalizedAttribute(KEY_TIME_SCALE);
            }
            this.startTimes = new long[this.parseRequiredInt(parser, KEY_CHUNKS)];
        }

        private int parseType(XmlPullParser parser) throws ParserException {
            String value = parser.getAttributeValue(null, KEY_TYPE);
            if (value != null) {
                if (KEY_TYPE_AUDIO.equalsIgnoreCase(value)) {
                    return 0;
                }
                if (KEY_TYPE_VIDEO.equalsIgnoreCase(value)) {
                    return 1;
                }
                if (KEY_TYPE_TEXT.equalsIgnoreCase(value)) {
                    return 2;
                }
                throw new ParserException("Invalid key value[" + value + "]");
            }
            throw new MissingFieldException(KEY_TYPE);
        }

        @Override
        public void addChild(Object child) {
            if (child instanceof SmoothStreamingManifest.TrackElement) {
                this.tracks.add((SmoothStreamingManifest.TrackElement)child);
            }
        }

        @Override
        public Object build() {
            SmoothStreamingManifest.TrackElement[] trackElements = new SmoothStreamingManifest.TrackElement[this.tracks.size()];
            this.tracks.toArray(trackElements);
            return new SmoothStreamingManifest.StreamElement(this.type, this.subType, this.timeScale, this.name, this.qualityLevels, this.url, this.maxWidth, this.maxHeight, this.displayWidth, this.displayHeight, this.language, trackElements, this.startTimes);
        }
    }

    private static class TrackElementParser
    extends ElementParser {
        public static final String TAG = "QualityLevel";
        private static final String KEY_INDEX = "Index";
        private static final String KEY_BITRATE = "Bitrate";
        private static final String KEY_CODEC_PRIVATE_DATA = "CodecPrivateData";
        private static final String KEY_SAMPLING_RATE = "SamplingRate";
        private static final String KEY_CHANNELS = "Channels";
        private static final String KEY_BITS_PER_SAMPLE = "BitsPerSample";
        private static final String KEY_PACKET_SIZE = "PacketSize";
        private static final String KEY_AUDIO_TAG = "AudioTag";
        private static final String KEY_FOUR_CC = "FourCC";
        private static final String KEY_NAL_UNIT_LENGTH_FIELD = "NALUnitLengthField";
        private static final String KEY_TYPE = "Type";
        private static final String KEY_MAX_WIDTH = "MaxWidth";
        private static final String KEY_MAX_HEIGHT = "MaxHeight";
        private final List<byte[]> csd = new LinkedList<byte[]>();
        private int index;
        private int bitrate;
        private String fourCC;
        private int profile;
        private int level;
        private int maxWidth;
        private int maxHeight;
        private int samplingRate;
        private int channels;
        private int packetSize;
        private int audioTag;
        private int bitPerSample;
        private int nalUnitLengthField;
        private String content;

        public TrackElementParser(ElementParser parent) {
            super(TAG, parent);
        }

        @Override
        public void parseStartTag(XmlPullParser parser) throws ParserException {
            int type = (Integer)this.getNormalizedAttribute(KEY_TYPE);
            this.content = null;
            this.index = this.parseInt(parser, KEY_INDEX, -1);
            this.bitrate = this.parseRequiredInt(parser, KEY_BITRATE);
            this.nalUnitLengthField = this.parseInt(parser, KEY_NAL_UNIT_LENGTH_FIELD, 4);
            if (type == 1) {
                this.maxHeight = this.parseRequiredInt(parser, KEY_MAX_HEIGHT);
                this.maxWidth = this.parseRequiredInt(parser, KEY_MAX_WIDTH);
            } else {
                this.maxHeight = -1;
                this.maxWidth = -1;
            }
            if (type == 0) {
                this.samplingRate = this.parseRequiredInt(parser, KEY_SAMPLING_RATE);
                this.channels = this.parseRequiredInt(parser, KEY_CHANNELS);
                this.bitPerSample = this.parseRequiredInt(parser, KEY_BITS_PER_SAMPLE);
                this.packetSize = this.parseRequiredInt(parser, KEY_PACKET_SIZE);
                this.audioTag = this.parseRequiredInt(parser, KEY_AUDIO_TAG);
                this.fourCC = this.parseRequiredString(parser, KEY_FOUR_CC);
            } else {
                this.samplingRate = -1;
                this.channels = -1;
                this.bitPerSample = -1;
                this.packetSize = -1;
                this.audioTag = -1;
                this.fourCC = parser.getAttributeValue(null, KEY_FOUR_CC);
            }
            String value = parser.getAttributeValue(null, KEY_CODEC_PRIVATE_DATA);
            if (value != null && value.length() > 0) {
                byte[] codecPrivateData = this.hexStringToByteArray(value);
                byte[][] split = CodecSpecificDataUtil.splitNalUnits(codecPrivateData);
                if (split == null) {
                    this.csd.add(codecPrivateData);
                } else {
                    int i = 0;
                    while (i < split.length) {
                        Pair<Integer, Integer> spsParameters = CodecSpecificDataUtil.parseSpsNalUnit(split[i]);
                        if (spsParameters != null) {
                            this.profile = (Integer)spsParameters.first;
                            this.level = (Integer)spsParameters.second;
                        }
                        this.csd.add(split[i]);
                        ++i;
                    }
                }
            }
        }

        private byte[] hexStringToByteArray(String hexString) {
            int length = hexString.length();
            byte[] data = new byte[length / 2];
            int i = 0;
            while (i < data.length) {
                int stringOffset = i * 2;
                data[i] = (byte)((Character.digit(hexString.charAt(stringOffset), 16) << 4) + Character.digit(hexString.charAt(stringOffset + 1), 16));
                ++i;
            }
            return data;
        }

        @Override
        public void parseText(XmlPullParser parser) {
            this.content = parser.getText();
        }

        @Override
        public Object build() {
            byte[][] csdArray = null;
            if (!this.csd.isEmpty()) {
                csdArray = new byte[this.csd.size()][];
                this.csd.toArray((T[])csdArray);
            }
            return new SmoothStreamingManifest.TrackElement(this.index, this.bitrate, this.fourCC, csdArray, this.profile, this.level, this.maxWidth, this.maxHeight, this.samplingRate, this.channels, this.packetSize, this.audioTag, this.bitPerSample, this.nalUnitLengthField, this.content);
        }
    }
}

