/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.smoothstreaming;

import com.google.android.exoplayer.util.Util;
import java.util.UUID;

public class SmoothStreamingManifest {
    public final int majorVersion;
    public final int minorVersion;
    public final long timeScale;
    public final int lookAheadCount;
    public final ProtectionElement protectionElement;
    public final StreamElement[] streamElements;
    private final long duration;

    public SmoothStreamingManifest(int majorVersion, int minorVersion, long timeScale, long duration, int lookAheadCount, ProtectionElement protectionElement, StreamElement[] streamElements) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.timeScale = timeScale;
        this.duration = duration;
        this.lookAheadCount = lookAheadCount;
        this.protectionElement = protectionElement;
        this.streamElements = streamElements;
    }

    public long getDurationUs() {
        return this.duration * 1000000L / this.timeScale;
    }

    public static class ProtectionElement {
        public final UUID uuid;
        public final byte[] data;

        public ProtectionElement(UUID uuid, byte[] data) {
            this.uuid = uuid;
            this.data = data;
        }
    }

    public static class StreamElement {
        public static final int TYPE_UNKNOWN = -1;
        public static final int TYPE_AUDIO = 0;
        public static final int TYPE_VIDEO = 1;
        public static final int TYPE_TEXT = 2;
        private static final String URL_PLACEHOLDER_START_TIME = "{start time}";
        private static final String URL_PLACEHOLDER_BITRATE = "{bitrate}";
        public final int type;
        public final String subType;
        public final long timeScale;
        public final String name;
        public final int qualityLevels;
        public final String url;
        public final int maxWidth;
        public final int maxHeight;
        public final int displayWidth;
        public final int displayHeight;
        public final String language;
        public final TrackElement[] tracks;
        public final int chunkCount;
        private final long[] chunkStartTimes;

        public StreamElement(int type, String subType, long timeScale, String name, int qualityLevels, String url, int maxWidth, int maxHeight, int displayWidth, int displayHeight, String language, TrackElement[] tracks, long[] chunkStartTimes) {
            this.type = type;
            this.subType = subType;
            this.timeScale = timeScale;
            this.name = name;
            this.qualityLevels = qualityLevels;
            this.url = url;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.displayWidth = displayWidth;
            this.displayHeight = displayHeight;
            this.language = language;
            this.tracks = tracks;
            this.chunkCount = chunkStartTimes.length;
            this.chunkStartTimes = chunkStartTimes;
        }

        public int getChunkIndex(long timeUs) {
            return Util.binarySearchFloor(this.chunkStartTimes, timeUs * this.timeScale / 1000000L, true, true);
        }

        public long getStartTimeUs(int chunkIndex) {
            return this.chunkStartTimes[chunkIndex] * 1000000L / this.timeScale;
        }

        public String buildRequestUrl(int track, int chunkIndex) {
            assert (this.tracks != null);
            assert (this.chunkStartTimes != null);
            assert (chunkIndex < this.chunkStartTimes.length);
            return this.url.replace(URL_PLACEHOLDER_BITRATE, Integer.toString(this.tracks[track].bitrate)).replace(URL_PLACEHOLDER_START_TIME, Long.toString(this.chunkStartTimes[chunkIndex]));
        }
    }

    public static class TrackElement {
        public final int index;
        public final int bitrate;
        public final String fourCC;
        public final byte[][] csd;
        public final int profile;
        public final int level;
        public final String mimeType;
        public final int maxWidth;
        public final int maxHeight;
        public final int sampleRate;
        public final int numChannels;
        public final int packetSize;
        public final int audioTag;
        public final int bitPerSample;
        public final int nalUnitLengthField;
        public final String content;

        public TrackElement(int index, int bitrate, String fourCC, byte[][] csd, int profile, int level, int maxWidth, int maxHeight, int sampleRate, int channels, int packetSize, int audioTag, int bitPerSample, int nalUnitLengthField, String content) {
            this.index = index;
            this.bitrate = bitrate;
            this.fourCC = fourCC;
            this.csd = csd;
            this.profile = profile;
            this.level = level;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.sampleRate = sampleRate;
            this.numChannels = channels;
            this.packetSize = packetSize;
            this.audioTag = audioTag;
            this.bitPerSample = bitPerSample;
            this.nalUnitLengthField = nalUnitLengthField;
            this.content = content;
            this.mimeType = TrackElement.fourCCToMimeType(fourCC);
        }

        private static String fourCCToMimeType(String fourCC) {
            if (fourCC.equalsIgnoreCase("H264") || fourCC.equalsIgnoreCase("AVC1") || fourCC.equalsIgnoreCase("DAVC")) {
                return "video/avc";
            }
            if (fourCC.equalsIgnoreCase("AACL") || fourCC.equalsIgnoreCase("AACH")) {
                return "audio/mp4a-latm";
            }
            if (fourCC.equalsIgnoreCase("TTML")) {
                return "application/ttml+xml";
            }
            return null;
        }
    }
}

