/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.parser.webm;

import android.annotation.TargetApi;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.parser.SegmentIndex;
import com.google.android.exoplayer.parser.webm.DefaultEbmlReader;
import com.google.android.exoplayer.parser.webm.EbmlEventHandler;
import com.google.android.exoplayer.parser.webm.EbmlReader;
import com.google.android.exoplayer.parser.webm.WebmExtractor;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import com.google.android.exoplayer.util.LongArray;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

@TargetApi(value=16)
public final class DefaultWebmExtractor
implements WebmExtractor {
    private static final String DOC_TYPE_WEBM = "webm";
    private static final String CODEC_ID_VP9 = "V_VP9";
    private static final int UNKNOWN = -1;
    private static final int ID_EBML = 440786851;
    private static final int ID_EBML_READ_VERSION = 17143;
    private static final int ID_DOC_TYPE = 17026;
    private static final int ID_DOC_TYPE_READ_VERSION = 17029;
    private static final int ID_SEGMENT = 408125543;
    private static final int ID_INFO = 357149030;
    private static final int ID_TIMECODE_SCALE = 2807729;
    private static final int ID_DURATION = 17545;
    private static final int ID_CLUSTER = 524531317;
    private static final int ID_TIME_CODE = 231;
    private static final int ID_SIMPLE_BLOCK = 163;
    private static final int ID_TRACKS = 374648427;
    private static final int ID_TRACK_ENTRY = 174;
    private static final int ID_CODEC_ID = 134;
    private static final int ID_VIDEO = 224;
    private static final int ID_PIXEL_WIDTH = 176;
    private static final int ID_PIXEL_HEIGHT = 186;
    private static final int ID_CUES = 475249515;
    private static final int ID_CUE_POINT = 187;
    private static final int ID_CUE_TIME = 179;
    private static final int ID_CUE_TRACK_POSITIONS = 183;
    private static final int ID_CUE_CLUSTER_POSITION = 241;
    private static final int LACING_NONE = 0;
    private static final int LACING_XIPH = 1;
    private static final int LACING_FIXED = 2;
    private static final int LACING_EBML = 3;
    private final EbmlReader reader;
    private final byte[] simpleBlockTimecodeAndFlags = new byte[3];
    private SampleHolder tempSampleHolder;
    private boolean sampleRead;
    private boolean prepared = false;
    private long segmentStartOffsetBytes = -1L;
    private long segmentEndOffsetBytes = -1L;
    private long timecodeScale = 1000000L;
    private long durationUs = -1L;
    private int pixelWidth = -1;
    private int pixelHeight = -1;
    private long cuesSizeBytes = -1L;
    private long clusterTimecodeUs = -1L;
    private long simpleBlockTimecodeUs = -1L;
    private MediaFormat format;
    private SegmentIndex cues;
    private LongArray cueTimesUs;
    private LongArray cueClusterPositions;

    public DefaultWebmExtractor() {
        this(new DefaultEbmlReader());
    }

    DefaultWebmExtractor(EbmlReader reader) {
        this.reader = reader;
        this.reader.setEventHandler(new InnerEbmlEventHandler());
        this.cueTimesUs = new LongArray();
        this.cueClusterPositions = new LongArray();
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public boolean read(NonBlockingInputStream inputStream, SampleHolder sampleHolder) {
        this.tempSampleHolder = sampleHolder;
        this.sampleRead = false;
        this.reader.read(inputStream);
        this.tempSampleHolder = null;
        return this.sampleRead;
    }

    @Override
    public boolean seekTo(long seekTimeUs, boolean allowNoop) {
        int clusterIndex;
        this.checkPrepared();
        if (allowNoop && this.simpleBlockTimecodeUs != -1L && seekTimeUs >= this.simpleBlockTimecodeUs && (clusterIndex = Arrays.binarySearch(this.cues.timesUs, this.clusterTimecodeUs)) >= 0 && seekTimeUs < this.clusterTimecodeUs + this.cues.durationsUs[clusterIndex]) {
            return false;
        }
        this.reader.reset();
        return true;
    }

    @Override
    public SegmentIndex getCues() {
        this.checkPrepared();
        return this.cues;
    }

    @Override
    public MediaFormat getFormat() {
        this.checkPrepared();
        return this.format;
    }

    int getElementType(int id) {
        switch (id) {
            case 174: 
            case 183: 
            case 187: 
            case 224: 
            case 357149030: 
            case 374648427: 
            case 408125543: 
            case 440786851: 
            case 475249515: 
            case 524531317: {
                return 1;
            }
            case 176: 
            case 179: 
            case 186: 
            case 231: 
            case 241: 
            case 17029: 
            case 17143: 
            case 2807729: {
                return 2;
            }
            case 134: 
            case 17026: {
                return 3;
            }
            case 163: {
                return 4;
            }
            case 17545: {
                return 5;
            }
        }
        return 0;
    }

    boolean onMasterElementStart(int id, long elementOffsetBytes, int headerSizeBytes, long contentsSizeBytes) {
        switch (id) {
            case 408125543: {
                if (this.segmentStartOffsetBytes != -1L || this.segmentEndOffsetBytes != -1L) {
                    throw new IllegalStateException("Multiple Segment elements not supported");
                }
                this.segmentStartOffsetBytes = elementOffsetBytes + (long)headerSizeBytes;
                this.segmentEndOffsetBytes = elementOffsetBytes + (long)headerSizeBytes + contentsSizeBytes;
                break;
            }
            case 475249515: {
                this.cuesSizeBytes = (long)headerSizeBytes + contentsSizeBytes;
            }
        }
        return true;
    }

    boolean onMasterElementEnd(int id) {
        if (id == 475249515) {
            this.finishPreparing();
            return false;
        }
        return true;
    }

    boolean onIntegerElement(int id, long value) {
        switch (id) {
            case 17143: {
                if (value == 1L) break;
                throw new IllegalArgumentException("EBMLReadVersion " + value + " not supported");
            }
            case 17029: {
                if (value >= 1L && value <= 2L) break;
                throw new IllegalArgumentException("DocTypeReadVersion " + value + " not supported");
            }
            case 2807729: {
                this.timecodeScale = value;
                break;
            }
            case 176: {
                this.pixelWidth = (int)value;
                break;
            }
            case 186: {
                this.pixelHeight = (int)value;
                break;
            }
            case 179: {
                this.cueTimesUs.add(this.scaleTimecodeToUs(value));
                break;
            }
            case 241: {
                this.cueClusterPositions.add(value);
                break;
            }
            case 231: {
                this.clusterTimecodeUs = this.scaleTimecodeToUs(value);
            }
        }
        return true;
    }

    boolean onFloatElement(int id, double value) {
        if (id == 17545) {
            this.durationUs = this.scaleTimecodeToUs((long)value);
        }
        return true;
    }

    boolean onStringElement(int id, String value) {
        switch (id) {
            case 17026: {
                if (DOC_TYPE_WEBM.equals(value)) break;
                throw new IllegalArgumentException("DocType " + value + " not supported");
            }
            case 134: {
                if (CODEC_ID_VP9.equals(value)) break;
                throw new IllegalArgumentException("CodecID " + value + " not supported");
            }
        }
        return true;
    }

    boolean onBinaryElement(int id, long elementOffsetBytes, int headerSizeBytes, int contentsSizeBytes, NonBlockingInputStream inputStream) {
        if (id == 163) {
            this.reader.readVarint(inputStream);
            this.reader.readBytes(inputStream, this.simpleBlockTimecodeAndFlags, 3);
            int timecode = this.simpleBlockTimecodeAndFlags[0] << 8 | this.simpleBlockTimecodeAndFlags[1] & 0xFF;
            long timecodeUs = this.scaleTimecodeToUs(timecode);
            boolean keyframe = (this.simpleBlockTimecodeAndFlags[2] & 0x80) == 128;
            boolean invisible = (this.simpleBlockTimecodeAndFlags[2] & 8) == 8;
            int lacing = (this.simpleBlockTimecodeAndFlags[2] & 6) >> 1;
            switch (lacing) {
                case 0: {
                    long elementEndOffsetBytes = elementOffsetBytes + (long)headerSizeBytes + (long)contentsSizeBytes;
                    this.simpleBlockTimecodeUs = this.clusterTimecodeUs + timecodeUs;
                    this.tempSampleHolder.flags = keyframe ? 1 : 0;
                    this.tempSampleHolder.decodeOnly = invisible;
                    this.tempSampleHolder.timeUs = this.clusterTimecodeUs + timecodeUs;
                    this.tempSampleHolder.size = (int)(elementEndOffsetBytes - this.reader.getBytesRead());
                    break;
                }
                default: {
                    throw new IllegalStateException("Lacing mode " + lacing + " not supported");
                }
            }
            this.reader.readBytes(inputStream, this.tempSampleHolder.data, this.tempSampleHolder.size);
            this.sampleRead = true;
            return false;
        }
        this.reader.skipBytes(inputStream, contentsSizeBytes);
        return true;
    }

    private long scaleTimecodeToUs(long unscaledTimecode) {
        return TimeUnit.NANOSECONDS.toMicros(unscaledTimecode * this.timecodeScale);
    }

    private void checkPrepared() {
        if (!this.prepared) {
            throw new IllegalStateException("Parser not yet prepared");
        }
    }

    private void finishPreparing() {
        if (this.prepared) {
            throw new IllegalStateException("Already prepared");
        }
        if (this.segmentStartOffsetBytes == -1L) {
            throw new IllegalStateException("Segment start/end offsets unknown");
        }
        if (this.durationUs == -1L) {
            throw new IllegalStateException("Duration unknown");
        }
        if (this.pixelWidth == -1 || this.pixelHeight == -1) {
            throw new IllegalStateException("Pixel width/height unknown");
        }
        if (this.cuesSizeBytes == -1L) {
            throw new IllegalStateException("Cues size unknown");
        }
        if (this.cueTimesUs.size() == 0 || this.cueTimesUs.size() != this.cueClusterPositions.size()) {
            throw new IllegalStateException("Invalid/missing cue points");
        }
        this.format = MediaFormat.createVideoFormat("video/x-vnd.on2.vp9", -1, this.pixelWidth, this.pixelHeight, null);
        int cuePointsSize = this.cueTimesUs.size();
        int[] sizes = new int[cuePointsSize];
        long[] offsets = new long[cuePointsSize];
        long[] durationsUs = new long[cuePointsSize];
        long[] timesUs = new long[cuePointsSize];
        int i = 0;
        while (i < cuePointsSize) {
            timesUs[i] = this.cueTimesUs.get(i);
            offsets[i] = this.segmentStartOffsetBytes + this.cueClusterPositions.get(i);
            ++i;
        }
        i = 0;
        while (i < cuePointsSize - 1) {
            sizes[i] = (int)(offsets[i + 1] - offsets[i]);
            durationsUs[i] = timesUs[i + 1] - timesUs[i];
            ++i;
        }
        sizes[cuePointsSize - 1] = (int)(this.segmentEndOffsetBytes - offsets[cuePointsSize - 1]);
        durationsUs[cuePointsSize - 1] = this.durationUs - timesUs[cuePointsSize - 1];
        this.cues = new SegmentIndex((int)this.cuesSizeBytes, sizes, offsets, durationsUs, timesUs);
        this.cueTimesUs = null;
        this.cueClusterPositions = null;
        this.prepared = true;
    }

    private final class InnerEbmlEventHandler
    implements EbmlEventHandler {
        private InnerEbmlEventHandler() {
        }

        @Override
        public int getElementType(int id) {
            return DefaultWebmExtractor.this.getElementType(id);
        }

        @Override
        public boolean onMasterElementStart(int id, long elementOffsetBytes, int headerSizeBytes, long contentsSizeBytes) {
            return DefaultWebmExtractor.this.onMasterElementStart(id, elementOffsetBytes, headerSizeBytes, contentsSizeBytes);
        }

        @Override
        public boolean onMasterElementEnd(int id) {
            return DefaultWebmExtractor.this.onMasterElementEnd(id);
        }

        @Override
        public boolean onIntegerElement(int id, long value) {
            return DefaultWebmExtractor.this.onIntegerElement(id, value);
        }

        @Override
        public boolean onFloatElement(int id, double value) {
            return DefaultWebmExtractor.this.onFloatElement(id, value);
        }

        @Override
        public boolean onStringElement(int id, String value) {
            return DefaultWebmExtractor.this.onStringElement(id, value);
        }

        @Override
        public boolean onBinaryElement(int id, long elementOffsetBytes, int headerSizeBytes, int contentsSizeBytes, NonBlockingInputStream inputStream) {
            return DefaultWebmExtractor.this.onBinaryElement(id, elementOffsetBytes, headerSizeBytes, contentsSizeBytes, inputStream);
        }
    }
}

