/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.parser.webm;

import com.google.android.exoplayer.parser.webm.EbmlEventHandler;
import com.google.android.exoplayer.parser.webm.EbmlReader;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import com.google.android.exoplayer.util.Assertions;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Stack;

final class DefaultEbmlReader
implements EbmlReader {
    private static final int STATE_BEGIN_READING = 0;
    private static final int STATE_READ_CONTENTS = 1;
    private static final int STATE_FINISHED_READING = 2;
    private static final int[] VARINT_LENGTH_MASKS = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private static final int MAX_INTEGER_ELEMENT_SIZE_BYTES = 8;
    private static final int VALID_FLOAT32_ELEMENT_SIZE_BYTES = 4;
    private static final int VALID_FLOAT64_ELEMENT_SIZE_BYTES = 8;
    private final byte[] tempByteArray = new byte[8];
    private final Stack<MasterElement> masterElementsStack = new Stack();
    private EbmlEventHandler eventHandler;
    private int state;
    private long bytesRead;
    private long elementOffset;
    private int elementId;
    private int elementIdState;
    private long elementContentSize;
    private int elementContentSizeState;
    private int varintBytesState;
    private int varintBytesLength;
    private int bytesState;
    private byte[] stringBytes;

    DefaultEbmlReader() {
    }

    @Override
    public void setEventHandler(EbmlEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public int read(NonBlockingInputStream inputStream) {
        Assertions.checkState(this.eventHandler != null);
        while (true) {
            if (!this.masterElementsStack.isEmpty() && this.bytesRead >= this.masterElementsStack.peek().elementEndOffsetBytes) {
                if (this.eventHandler.onMasterElementEnd(this.masterElementsStack.pop().elementId)) continue;
                return 0;
            }
            if (this.state == 0) {
                int idResult = this.readElementId(inputStream);
                if (idResult != 0) {
                    return idResult;
                }
                int sizeResult = this.readElementContentSize(inputStream);
                if (sizeResult != 0) {
                    return sizeResult;
                }
                this.state = 1;
                this.bytesState = 0;
            }
            int type = this.eventHandler.getElementType(this.elementId);
            switch (type) {
                case 1: {
                    int masterHeaderSize = (int)(this.bytesRead - this.elementOffset);
                    this.masterElementsStack.add(new MasterElement(this.elementId, this.bytesRead + this.elementContentSize));
                    if (this.eventHandler.onMasterElementStart(this.elementId, this.elementOffset, masterHeaderSize, this.elementContentSize)) break;
                    this.prepareForNextElement();
                    return 0;
                }
                case 2: {
                    if (this.elementContentSize > 8L) {
                        throw new IllegalStateException("Invalid integer size " + this.elementContentSize);
                    }
                    int intResult = this.readBytesInternal(inputStream, this.tempByteArray, (int)this.elementContentSize);
                    if (intResult != 0) {
                        return intResult;
                    }
                    long intValue = this.getTempByteArrayValue((int)this.elementContentSize, false);
                    if (this.eventHandler.onIntegerElement(this.elementId, intValue)) break;
                    this.prepareForNextElement();
                    return 0;
                }
                case 5: {
                    if (this.elementContentSize != 4L && this.elementContentSize != 8L) {
                        throw new IllegalStateException("Invalid float size " + this.elementContentSize);
                    }
                    int floatResult = this.readBytesInternal(inputStream, this.tempByteArray, (int)this.elementContentSize);
                    if (floatResult != 0) {
                        return floatResult;
                    }
                    long valueBits = this.getTempByteArrayValue((int)this.elementContentSize, false);
                    double floatValue = this.elementContentSize == 4L ? (double)Float.intBitsToFloat((int)valueBits) : Double.longBitsToDouble(valueBits);
                    if (this.eventHandler.onFloatElement(this.elementId, floatValue)) break;
                    this.prepareForNextElement();
                    return 0;
                }
                case 3: {
                    int stringResult;
                    if (this.elementContentSize > Integer.MAX_VALUE) {
                        throw new IllegalStateException("String element size " + this.elementContentSize + " is larger than MAX_INT");
                    }
                    if (this.stringBytes == null) {
                        this.stringBytes = new byte[(int)this.elementContentSize];
                    }
                    if ((stringResult = this.readBytesInternal(inputStream, this.stringBytes, (int)this.elementContentSize)) != 0) {
                        return stringResult;
                    }
                    String stringValue = new String(this.stringBytes, Charset.forName("UTF-8"));
                    this.stringBytes = null;
                    if (this.eventHandler.onStringElement(this.elementId, stringValue)) break;
                    this.prepareForNextElement();
                    return 0;
                }
                case 4: {
                    if (this.elementContentSize > Integer.MAX_VALUE) {
                        throw new IllegalStateException("Binary element size " + this.elementContentSize + " is larger than MAX_INT");
                    }
                    if (inputStream.getAvailableByteCount() < this.elementContentSize) {
                        return 1;
                    }
                    int binaryHeaderSize = (int)(this.bytesRead - this.elementOffset);
                    boolean keepGoing = this.eventHandler.onBinaryElement(this.elementId, this.elementOffset, binaryHeaderSize, (int)this.elementContentSize, inputStream);
                    long expectedBytesRead = this.elementOffset + (long)binaryHeaderSize + this.elementContentSize;
                    if (expectedBytesRead != this.bytesRead) {
                        throw new IllegalStateException("Incorrect total bytes read. Expected " + expectedBytesRead + " but actually " + this.bytesRead);
                    }
                    if (keepGoing) break;
                    this.prepareForNextElement();
                    return 0;
                }
                case 0: {
                    if (this.elementContentSize > Integer.MAX_VALUE) {
                        throw new IllegalStateException("Unknown element size " + this.elementContentSize + " is larger than MAX_INT");
                    }
                    int skipResult = this.skipBytesInternal(inputStream, (int)this.elementContentSize);
                    if (skipResult == 0) break;
                    return skipResult;
                }
                default: {
                    throw new IllegalStateException("Invalid element type " + type);
                }
            }
            this.prepareForNextElement();
        }
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public void reset() {
        this.prepareForNextElement();
        this.masterElementsStack.clear();
        this.bytesRead = 0L;
    }

    @Override
    public long readVarint(NonBlockingInputStream inputStream) {
        this.varintBytesState = 0;
        int result = this.readVarintBytes(inputStream);
        if (result != 0) {
            throw new IllegalStateException("Couldn't read varint");
        }
        return this.getTempByteArrayValue(this.varintBytesLength, true);
    }

    @Override
    public void readBytes(NonBlockingInputStream inputStream, ByteBuffer byteBuffer, int totalBytes) {
        this.bytesState = 0;
        int result = this.readBytesInternal(inputStream, byteBuffer, totalBytes);
        if (result != 0) {
            throw new IllegalStateException("Couldn't read bytes into buffer");
        }
    }

    @Override
    public void readBytes(NonBlockingInputStream inputStream, byte[] byteArray, int totalBytes) {
        this.bytesState = 0;
        int result = this.readBytesInternal(inputStream, byteArray, totalBytes);
        if (result != 0) {
            throw new IllegalStateException("Couldn't read bytes into array");
        }
    }

    @Override
    public void skipBytes(NonBlockingInputStream inputStream, int totalBytes) {
        this.bytesState = 0;
        int result = this.skipBytesInternal(inputStream, totalBytes);
        if (result != 0) {
            throw new IllegalStateException("Couldn't skip bytes");
        }
    }

    private void prepareForNextElement() {
        this.state = 0;
        this.elementIdState = 0;
        this.elementContentSizeState = 0;
        this.elementOffset = this.bytesRead;
    }

    private int readElementId(NonBlockingInputStream inputStream) {
        int result;
        if (this.elementIdState == 2) {
            return 0;
        }
        if (this.elementIdState == 0) {
            this.varintBytesState = 0;
            this.elementIdState = 1;
        }
        if ((result = this.readVarintBytes(inputStream)) != 0) {
            return result;
        }
        this.elementId = (int)this.getTempByteArrayValue(this.varintBytesLength, false);
        this.elementIdState = 2;
        return 0;
    }

    private int readElementContentSize(NonBlockingInputStream inputStream) {
        int result;
        if (this.elementContentSizeState == 2) {
            return 0;
        }
        if (this.elementContentSizeState == 0) {
            this.varintBytesState = 0;
            this.elementContentSizeState = 1;
        }
        if ((result = this.readVarintBytes(inputStream)) != 0) {
            return result;
        }
        this.elementContentSize = this.getTempByteArrayValue(this.varintBytesLength, true);
        this.elementContentSizeState = 2;
        return 0;
    }

    private int readVarintBytes(NonBlockingInputStream inputStream) {
        int result;
        if (this.varintBytesState == 2) {
            return 0;
        }
        if (this.varintBytesState == 0) {
            this.bytesState = 0;
            result = this.readBytesInternal(inputStream, this.tempByteArray, 1);
            if (result != 0) {
                return result;
            }
            this.varintBytesState = 1;
            int firstByte = this.tempByteArray[0] & 0xFF;
            this.varintBytesLength = -1;
            int i = 0;
            while (i < VARINT_LENGTH_MASKS.length) {
                if ((VARINT_LENGTH_MASKS[i] & firstByte) != 0) {
                    this.varintBytesLength = i + 1;
                    break;
                }
                ++i;
            }
            if (this.varintBytesLength == -1) {
                throw new IllegalStateException("No valid varint length mask found at bytesRead = " + this.bytesRead);
            }
        }
        if ((result = this.readBytesInternal(inputStream, this.tempByteArray, this.varintBytesLength)) != 0) {
            return result;
        }
        return 0;
    }

    private int readBytesInternal(NonBlockingInputStream inputStream, ByteBuffer byteBuffer, int totalBytes) {
        if (this.bytesState == 0 && totalBytes > byteBuffer.capacity()) {
            throw new IllegalArgumentException("Byte buffer not large enough");
        }
        if (this.bytesState >= totalBytes) {
            return 0;
        }
        int remainingBytes = totalBytes - this.bytesState;
        int additionalBytesRead = inputStream.read(byteBuffer, remainingBytes);
        return this.updateBytesState(additionalBytesRead, totalBytes);
    }

    private int readBytesInternal(NonBlockingInputStream inputStream, byte[] byteArray, int totalBytes) {
        if (this.bytesState == 0 && totalBytes > byteArray.length) {
            throw new IllegalArgumentException("Byte array not large enough");
        }
        if (this.bytesState >= totalBytes) {
            return 0;
        }
        int remainingBytes = totalBytes - this.bytesState;
        int additionalBytesRead = inputStream.read(byteArray, this.bytesState, remainingBytes);
        return this.updateBytesState(additionalBytesRead, totalBytes);
    }

    private int skipBytesInternal(NonBlockingInputStream inputStream, int totalBytes) {
        if (this.bytesState >= totalBytes) {
            return 0;
        }
        int remainingBytes = totalBytes - this.bytesState;
        int additionalBytesRead = inputStream.skip(remainingBytes);
        return this.updateBytesState(additionalBytesRead, totalBytes);
    }

    private int updateBytesState(int additionalBytesRead, int totalBytes) {
        if (additionalBytesRead == -1) {
            return 2;
        }
        this.bytesState += additionalBytesRead;
        this.bytesRead += (long)additionalBytesRead;
        if (this.bytesState < totalBytes) {
            return 1;
        }
        return 0;
    }

    private long getTempByteArrayValue(int byteLength, boolean removeLengthMask) {
        if (removeLengthMask) {
            this.tempByteArray[0] = (byte)(this.tempByteArray[0] & ~VARINT_LENGTH_MASKS[this.varintBytesLength - 1]);
        }
        long varint = 0L;
        int i = 0;
        while (i < byteLength) {
            varint = varint << 8 | (long)(this.tempByteArray[i] & 0xFF);
            ++i;
        }
        return varint;
    }

    private static final class MasterElement {
        private final int elementId;
        private final long elementEndOffsetBytes;

        private MasterElement(int elementId, long elementEndOffsetBytes) {
            this.elementId = elementId;
            this.elementEndOffsetBytes = elementEndOffsetBytes;
        }
    }
}

