/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.parser.mp4;

import android.annotation.SuppressLint;
import android.util.Pair;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.parser.SegmentIndex;
import com.google.android.exoplayer.parser.mp4.Atom;
import com.google.android.exoplayer.parser.mp4.CodecSpecificDataUtil;
import com.google.android.exoplayer.parser.mp4.DefaultSampleValues;
import com.google.android.exoplayer.parser.mp4.ParsableByteArray;
import com.google.android.exoplayer.parser.mp4.Track;
import com.google.android.exoplayer.parser.mp4.TrackEncryptionBox;
import com.google.android.exoplayer.parser.mp4.TrackFragment;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import com.google.android.exoplayer.util.Assertions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;

public final class FragmentedMp4Extractor {
    public static final int WORKAROUND_EVERY_VIDEO_FRAME_IS_SYNC_FRAME = 1;
    public static final int RESULT_NEED_MORE_DATA = 1;
    public static final int RESULT_END_OF_STREAM = 2;
    public static final int RESULT_READ_SAMPLE_FULL = 4;
    public static final int RESULT_READ_SAMPLE_PARTIAL = 8;
    public static final int RESULT_READ_MOOV = 16;
    public static final int RESULT_READ_SIDX = 32;
    public static final int RESULT_NEED_SAMPLE_HOLDER = 64;
    private static final int READ_TERMINATING_RESULTS = 71;
    private static final byte[] NAL_START_CODE;
    private static final byte[] PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE;
    private static final int STATE_READING_ATOM_HEADER = 0;
    private static final int STATE_READING_ATOM_PAYLOAD = 1;
    private static final int STATE_READING_CENC_AUXILIARY_DATA = 2;
    private static final int STATE_READING_SAMPLE_START = 3;
    private static final int STATE_READING_SAMPLE_INCREMENTAL = 4;
    private static final int ATOM_HEADER_SIZE = 8;
    private static final int FULL_ATOM_HEADER_SIZE = 12;
    private static final Set<Integer> PARSED_ATOMS;
    private static final Set<Integer> CONTAINER_TYPES;
    private final int workaroundFlags;
    private final ParsableByteArray atomHeader;
    private final Stack<Atom.ContainerAtom> containerAtoms;
    private final Stack<Integer> containerAtomEndPoints;
    private int parserState;
    private int atomBytesRead;
    private int rootAtomBytesRead;
    private int atomType;
    private int atomSize;
    private ParsableByteArray atomData;
    private ParsableByteArray cencAuxiliaryData;
    private int cencAuxiliaryBytesRead;
    private int sampleBytesRead;
    private int pendingSeekTimeMs;
    private int sampleIndex;
    private int pendingSeekSyncSampleIndex;
    private int lastSyncSampleIndex;
    private final HashMap<UUID, byte[]> psshData;
    private SegmentIndex segmentIndex;
    private Track track;
    private DefaultSampleValues extendsDefaults;
    private TrackFragment fragmentRun;

    static {
        byte[] byArray = new byte[4];
        byArray[3] = 1;
        NAL_START_CODE = byArray;
        PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE = new byte[]{-94, 57, 79, 82, 90, -101, 79, 20, -94, 68, 108, 66, 124, 100, -115, -12};
        HashSet<Integer> parsedAtoms = new HashSet<Integer>();
        parsedAtoms.add(1635148593);
        parsedAtoms.add(1635148595);
        parsedAtoms.add(1702061171);
        parsedAtoms.add(1751411826);
        parsedAtoms.add(1835295092);
        parsedAtoms.add(1835296868);
        parsedAtoms.add(1835427940);
        parsedAtoms.add(0x6D6F6F66);
        parsedAtoms.add(1836019574);
        parsedAtoms.add(1836069985);
        parsedAtoms.add(1936286840);
        parsedAtoms.add(1937011556);
        parsedAtoms.add(0x74666474);
        parsedAtoms.add(1952868452);
        parsedAtoms.add(1953196132);
        parsedAtoms.add(1953653094);
        parsedAtoms.add(1953653099);
        parsedAtoms.add(1953654136);
        parsedAtoms.add(1953658222);
        parsedAtoms.add(1836475768);
        parsedAtoms.add(1835297121);
        parsedAtoms.add(1835626086);
        parsedAtoms.add(1937007212);
        parsedAtoms.add(1886614376);
        parsedAtoms.add(1935763834);
        parsedAtoms.add(1970628964);
        PARSED_ATOMS = Collections.unmodifiableSet(parsedAtoms);
        HashSet<Integer> atomContainerTypes = new HashSet<Integer>();
        atomContainerTypes.add(1836019574);
        atomContainerTypes.add(1953653099);
        atomContainerTypes.add(1835297121);
        atomContainerTypes.add(1835626086);
        atomContainerTypes.add(1937007212);
        atomContainerTypes.add(1635148611);
        atomContainerTypes.add(0x6D6F6F66);
        atomContainerTypes.add(1953653094);
        atomContainerTypes.add(1836475768);
        CONTAINER_TYPES = Collections.unmodifiableSet(atomContainerTypes);
    }

    public FragmentedMp4Extractor() {
        this(0);
    }

    public FragmentedMp4Extractor(int workaroundFlags) {
        this.workaroundFlags = workaroundFlags;
        this.parserState = 0;
        this.atomHeader = new ParsableByteArray(8);
        this.containerAtoms = new Stack();
        this.containerAtomEndPoints = new Stack();
        this.psshData = new HashMap();
    }

    public SegmentIndex getSegmentIndex() {
        return this.segmentIndex;
    }

    public Map<UUID, byte[]> getPsshInfo() {
        return this.psshData.isEmpty() ? null : this.psshData;
    }

    public void putPsshInfo(UUID uuid, byte[] data) {
        this.psshData.put(uuid, data);
    }

    public MediaFormat getFormat() {
        return this.track == null ? null : this.track.mediaFormat;
    }

    public Track getTrack() {
        return this.track;
    }

    public void setTrack(Track track) {
        this.extendsDefaults = new DefaultSampleValues(0, 0, 0, 0);
        this.track = track;
    }

    public int read(NonBlockingInputStream inputStream, SampleHolder out) throws ParserException {
        try {
            int results = 0;
            while ((results & 0x47) == 0) {
                switch (this.parserState) {
                    case 0: {
                        results |= this.readAtomHeader(inputStream);
                        break;
                    }
                    case 1: {
                        results |= this.readAtomPayload(inputStream);
                        break;
                    }
                    case 2: {
                        results |= this.readCencAuxiliaryData(inputStream);
                        break;
                    }
                    default: {
                        results |= this.readOrSkipSample(inputStream, out);
                    }
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public boolean seekTo(long seekTimeUs, boolean allowNoop) {
        this.pendingSeekTimeMs = (int)(seekTimeUs / 1000L);
        if (allowNoop && this.fragmentRun != null && this.pendingSeekTimeMs >= this.fragmentRun.getSamplePresentationTime(0) && this.pendingSeekTimeMs <= this.fragmentRun.getSamplePresentationTime(this.fragmentRun.length - 1)) {
            int sampleIndexFound = 0;
            int syncSampleIndexFound = 0;
            int i = 0;
            while (i < this.fragmentRun.length) {
                if (this.fragmentRun.getSamplePresentationTime(i) <= this.pendingSeekTimeMs) {
                    if (this.fragmentRun.sampleIsSyncFrameTable[i]) {
                        syncSampleIndexFound = i;
                    }
                    sampleIndexFound = i;
                }
                ++i;
            }
            if (syncSampleIndexFound == this.lastSyncSampleIndex && sampleIndexFound >= this.sampleIndex) {
                this.pendingSeekTimeMs = 0;
                return false;
            }
        }
        this.containerAtoms.clear();
        this.containerAtomEndPoints.clear();
        this.enterState(0);
        return true;
    }

    private void enterState(int state) {
        switch (state) {
            case 0: {
                this.atomBytesRead = 0;
                if (!this.containerAtomEndPoints.isEmpty()) break;
                this.rootAtomBytesRead = 0;
                break;
            }
            case 2: {
                this.cencAuxiliaryBytesRead = 0;
                break;
            }
            case 3: {
                this.sampleBytesRead = 0;
            }
        }
        this.parserState = state;
    }

    private int readAtomHeader(NonBlockingInputStream inputStream) {
        int remainingBytes = 8 - this.atomBytesRead;
        int bytesRead = inputStream.read(this.atomHeader.getData(), this.atomBytesRead, remainingBytes);
        if (bytesRead == -1) {
            return 2;
        }
        this.rootAtomBytesRead += bytesRead;
        this.atomBytesRead += bytesRead;
        if (this.atomBytesRead != 8) {
            return 1;
        }
        this.atomHeader.setPosition(0);
        this.atomSize = this.atomHeader.readInt();
        this.atomType = this.atomHeader.readInt();
        if (this.atomType == 1835295092) {
            int cencAuxSize = this.fragmentRun.auxiliarySampleInfoTotalSize;
            if (cencAuxSize > 0) {
                this.cencAuxiliaryData = new ParsableByteArray(cencAuxSize);
                this.enterState(2);
            } else {
                this.cencAuxiliaryData = null;
                this.enterState(3);
            }
            return 0;
        }
        if (PARSED_ATOMS.contains(this.atomType)) {
            if (CONTAINER_TYPES.contains(this.atomType)) {
                this.enterState(0);
                this.containerAtoms.add(new Atom.ContainerAtom(this.atomType));
                this.containerAtomEndPoints.add(this.rootAtomBytesRead + this.atomSize - 8);
            } else {
                this.atomData = new ParsableByteArray(this.atomSize);
                System.arraycopy(this.atomHeader.getData(), 0, this.atomData.getData(), 0, 8);
                this.enterState(1);
            }
        } else {
            this.atomData = null;
            this.enterState(1);
        }
        return 0;
    }

    private int readAtomPayload(NonBlockingInputStream inputStream) {
        int bytesRead = this.atomData != null ? inputStream.read(this.atomData.getData(), this.atomBytesRead, this.atomSize - this.atomBytesRead) : inputStream.skip(this.atomSize - this.atomBytesRead);
        if (bytesRead == -1) {
            return 2;
        }
        this.rootAtomBytesRead += bytesRead;
        this.atomBytesRead += bytesRead;
        if (this.atomBytesRead != this.atomSize) {
            return 1;
        }
        int results = 0;
        if (this.atomData != null) {
            results |= this.onLeafAtomRead(new Atom.LeafAtom(this.atomType, this.atomData));
        }
        while (!this.containerAtomEndPoints.isEmpty() && this.containerAtomEndPoints.peek() == this.rootAtomBytesRead) {
            this.containerAtomEndPoints.pop();
            results |= this.onContainerAtomRead(this.containerAtoms.pop());
        }
        this.enterState(0);
        return results;
    }

    private int onLeafAtomRead(Atom.LeafAtom leaf) {
        if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add(leaf);
        } else if (leaf.type == 1936286840) {
            this.segmentIndex = FragmentedMp4Extractor.parseSidx(leaf.getData());
            return 32;
        }
        return 0;
    }

    private int onContainerAtomRead(Atom.ContainerAtom container) {
        if (container.type == 1836019574) {
            this.onMoovContainerAtomRead(container);
            return 16;
        }
        if (container.type == 0x6D6F6F66) {
            this.onMoofContainerAtomRead(container);
        } else if (!this.containerAtoms.isEmpty()) {
            this.containerAtoms.peek().add(container);
        }
        return 0;
    }

    private void onMoovContainerAtomRead(Atom.ContainerAtom moov) {
        List<Atom> moovChildren = moov.getChildren();
        int i = 0;
        while (i < moovChildren.size()) {
            Atom child = moovChildren.get(i);
            if (child.type == 1886614376) {
                ParsableByteArray psshAtom = ((Atom.LeafAtom)child).getData();
                psshAtom.setPosition(12);
                UUID uuid = new UUID(psshAtom.readLong(), psshAtom.readLong());
                int dataSize = psshAtom.readInt();
                byte[] data = new byte[dataSize];
                psshAtom.readBytes(data, 0, dataSize);
                this.psshData.put(uuid, data);
            }
            ++i;
        }
        Atom.ContainerAtom mvex = moov.getContainerAtomOfType(1836475768);
        this.extendsDefaults = FragmentedMp4Extractor.parseTrex(mvex.getLeafAtomOfType(1953654136).getData());
        this.track = FragmentedMp4Extractor.parseTrak(moov.getContainerAtomOfType(1953653099));
    }

    private void onMoofContainerAtomRead(Atom.ContainerAtom moof) {
        this.fragmentRun = new TrackFragment();
        FragmentedMp4Extractor.parseMoof(this.track, this.extendsDefaults, moof, this.fragmentRun, this.workaroundFlags);
        this.sampleIndex = 0;
        this.lastSyncSampleIndex = 0;
        this.pendingSeekSyncSampleIndex = 0;
        if (this.pendingSeekTimeMs != 0) {
            int i = 0;
            while (i < this.fragmentRun.length) {
                if (this.fragmentRun.sampleIsSyncFrameTable[i] && this.fragmentRun.getSamplePresentationTime(i) <= this.pendingSeekTimeMs) {
                    this.pendingSeekSyncSampleIndex = i;
                }
                ++i;
            }
            this.pendingSeekTimeMs = 0;
        }
    }

    private static DefaultSampleValues parseTrex(ParsableByteArray trex) {
        trex.setPosition(16);
        int defaultSampleDescriptionIndex = trex.readUnsignedIntToInt() - 1;
        int defaultSampleDuration = trex.readUnsignedIntToInt();
        int defaultSampleSize = trex.readUnsignedIntToInt();
        int defaultSampleFlags = trex.readInt();
        return new DefaultSampleValues(defaultSampleDescriptionIndex, defaultSampleDuration, defaultSampleSize, defaultSampleFlags);
    }

    private static Track parseTrak(Atom.ContainerAtom trak) {
        Atom.ContainerAtom mdia = trak.getContainerAtomOfType(1835297121);
        int trackType = FragmentedMp4Extractor.parseHdlr(mdia.getLeafAtomOfType(1751411826).getData());
        Assertions.checkState(trackType == 1936684398 || trackType == 1986618469);
        Pair<Integer, Long> header = FragmentedMp4Extractor.parseTkhd(trak.getLeafAtomOfType(1953196132).getData());
        int id = (Integer)header.first;
        long timescale = FragmentedMp4Extractor.parseMdhd(mdia.getLeafAtomOfType(1835296868).getData());
        Atom.ContainerAtom stbl = mdia.getContainerAtomOfType(1835626086).getContainerAtomOfType(1937007212);
        Pair<MediaFormat, TrackEncryptionBox[]> sampleDescriptions = FragmentedMp4Extractor.parseStsd(stbl.getLeafAtomOfType(1937011556).getData());
        return new Track(id, trackType, timescale, (MediaFormat)sampleDescriptions.first, (TrackEncryptionBox[])sampleDescriptions.second);
    }

    private static Pair<Integer, Long> parseTkhd(ParsableByteArray tkhd) {
        tkhd.setPosition(8);
        int fullAtom = tkhd.readInt();
        int version = FragmentedMp4Extractor.parseFullAtomVersion(fullAtom);
        tkhd.skip(version == 0 ? 8 : 16);
        int trackId = tkhd.readInt();
        tkhd.skip(4);
        long duration = version == 0 ? tkhd.readUnsignedInt() : tkhd.readUnsignedLongToLong();
        return Pair.create((Object)trackId, (Object)duration);
    }

    private static int parseHdlr(ParsableByteArray hdlr) {
        hdlr.setPosition(16);
        return hdlr.readInt();
    }

    private static long parseMdhd(ParsableByteArray mdhd) {
        mdhd.setPosition(8);
        int fullAtom = mdhd.readInt();
        int version = FragmentedMp4Extractor.parseFullAtomVersion(fullAtom);
        mdhd.skip(version == 0 ? 8 : 16);
        return mdhd.readUnsignedInt();
    }

    private static Pair<MediaFormat, TrackEncryptionBox[]> parseStsd(ParsableByteArray stsd) {
        stsd.setPosition(12);
        int numberOfEntries = stsd.readInt();
        MediaFormat mediaFormat = null;
        TrackEncryptionBox[] trackEncryptionBoxes = new TrackEncryptionBox[numberOfEntries];
        int i = 0;
        while (i < numberOfEntries) {
            int childStartPosition = stsd.getPosition();
            int childAtomSize = stsd.readInt();
            int childAtomType = stsd.readInt();
            if (childAtomType == 1635148593 || childAtomType == 1635148595 || childAtomType == 1701733238) {
                Pair<MediaFormat, TrackEncryptionBox> avc = FragmentedMp4Extractor.parseAvcFromParent(stsd, childStartPosition, childAtomSize);
                mediaFormat = (MediaFormat)avc.first;
                trackEncryptionBoxes[i] = (TrackEncryptionBox)avc.second;
            } else if (childAtomType == 1836069985 || childAtomType == 1701733217) {
                Pair<MediaFormat, TrackEncryptionBox> mp4a = FragmentedMp4Extractor.parseMp4aFromParent(stsd, childStartPosition, childAtomSize);
                mediaFormat = (MediaFormat)mp4a.first;
                trackEncryptionBoxes[i] = (TrackEncryptionBox)mp4a.second;
            }
            stsd.setPosition(childStartPosition + childAtomSize);
            ++i;
        }
        return Pair.create(mediaFormat, (Object)trackEncryptionBoxes);
    }

    private static Pair<MediaFormat, TrackEncryptionBox> parseAvcFromParent(ParsableByteArray parent, int position, int size) {
        parent.setPosition(position + 8);
        parent.skip(24);
        int width = parent.readUnsignedShort();
        int height = parent.readUnsignedShort();
        parent.skip(50);
        List<byte[]> initializationData = null;
        TrackEncryptionBox trackEncryptionBox = null;
        int childPosition = parent.getPosition();
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childStartPosition = parent.getPosition();
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == 1635148611) {
                initializationData = FragmentedMp4Extractor.parseAvcCFromParent(parent, childStartPosition);
            } else if (childAtomType == 1936289382) {
                trackEncryptionBox = FragmentedMp4Extractor.parseSinfFromParent(parent, childStartPosition, childAtomSize);
            }
            childPosition += childAtomSize;
        }
        MediaFormat format = MediaFormat.createVideoFormat("video/avc", -1, width, height, initializationData);
        return Pair.create((Object)format, trackEncryptionBox);
    }

    private static Pair<MediaFormat, TrackEncryptionBox> parseMp4aFromParent(ParsableByteArray parent, int position, int size) {
        parent.setPosition(position + 8);
        parent.skip(16);
        int channelCount = parent.readUnsignedShort();
        int sampleSize = parent.readUnsignedShort();
        parent.skip(4);
        int sampleRate = parent.readUnsignedFixedPoint1616();
        byte[] initializationData = null;
        TrackEncryptionBox trackEncryptionBox = null;
        int childPosition = parent.getPosition();
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childStartPosition = parent.getPosition();
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == 1702061171) {
                initializationData = FragmentedMp4Extractor.parseEsdsFromParent(parent, childStartPosition);
                Pair<Integer, Integer> audioSpecificConfig = CodecSpecificDataUtil.parseAudioSpecificConfig(initializationData);
                sampleRate = (Integer)audioSpecificConfig.first;
                channelCount = (Integer)audioSpecificConfig.second;
            } else if (childAtomType == 1936289382) {
                trackEncryptionBox = FragmentedMp4Extractor.parseSinfFromParent(parent, childStartPosition, childAtomSize);
            }
            childPosition += childAtomSize;
        }
        MediaFormat format = MediaFormat.createAudioFormat("audio/mp4a-latm", sampleSize, channelCount, sampleRate, Collections.singletonList(initializationData));
        return Pair.create((Object)format, trackEncryptionBox);
    }

    private static List<byte[]> parseAvcCFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8 + 4);
        int nalUnitLength = (parent.readUnsignedByte() & 3) + 1;
        if (nalUnitLength != 4) {
            throw new IllegalStateException();
        }
        ArrayList<byte[]> initializationData = new ArrayList<byte[]>();
        int numSequenceParameterSets = parent.readUnsignedByte() & 0x1F;
        int j = 0;
        while (j < numSequenceParameterSets) {
            initializationData.add(FragmentedMp4Extractor.parseChildNalUnit(parent));
            ++j;
        }
        int numPictureParamterSets = parent.readUnsignedByte();
        int j2 = 0;
        while (j2 < numPictureParamterSets) {
            initializationData.add(FragmentedMp4Extractor.parseChildNalUnit(parent));
            ++j2;
        }
        return initializationData;
    }

    private static byte[] parseChildNalUnit(ParsableByteArray atom) {
        int length = atom.readUnsignedShort();
        int offset = atom.getPosition();
        atom.skip(length);
        return CodecSpecificDataUtil.buildNalUnit(atom.getData(), offset, length);
    }

    private static TrackEncryptionBox parseSinfFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        TrackEncryptionBox trackEncryptionBox = null;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == 1718775137) {
                parent.readInt();
            } else if (childAtomType == 1935894637) {
                parent.skip(4);
                parent.readInt();
                parent.readInt();
            } else if (childAtomType == 1935894633) {
                trackEncryptionBox = FragmentedMp4Extractor.parseSchiFromParent(parent, childPosition, childAtomSize);
            }
            childPosition += childAtomSize;
        }
        return trackEncryptionBox;
    }

    private static TrackEncryptionBox parseSchiFromParent(ParsableByteArray parent, int position, int size) {
        int childPosition = position + 8;
        while (childPosition - position < size) {
            parent.setPosition(childPosition);
            int childAtomSize = parent.readInt();
            int childAtomType = parent.readInt();
            if (childAtomType == 1952804451) {
                parent.skip(4);
                int firstInt = parent.readInt();
                boolean defaultIsEncrypted = firstInt >> 8 == 1;
                int defaultInitVectorSize = firstInt & 0xFF;
                byte[] defaultKeyId = new byte[16];
                parent.readBytes(defaultKeyId, 0, defaultKeyId.length);
                return new TrackEncryptionBox(defaultIsEncrypted, defaultInitVectorSize, defaultKeyId);
            }
            childPosition += childAtomSize;
        }
        return null;
    }

    private static byte[] parseEsdsFromParent(ParsableByteArray parent, int position) {
        parent.setPosition(position + 8 + 4);
        parent.skip(1);
        int varIntByte = parent.readUnsignedByte();
        while (varIntByte > 127) {
            varIntByte = parent.readUnsignedByte();
        }
        parent.skip(2);
        int flags = parent.readUnsignedByte();
        if ((flags & 0x80) != 0) {
            parent.skip(2);
        }
        if ((flags & 0x40) != 0) {
            parent.skip(parent.readUnsignedShort());
        }
        if ((flags & 0x20) != 0) {
            parent.skip(2);
        }
        parent.skip(1);
        varIntByte = parent.readUnsignedByte();
        while (varIntByte > 127) {
            varIntByte = parent.readUnsignedByte();
        }
        parent.skip(13);
        parent.skip(1);
        varIntByte = parent.readUnsignedByte();
        int varInt = varIntByte & 0x7F;
        while (varIntByte > 127) {
            varIntByte = parent.readUnsignedByte();
            varInt <<= 8;
            varInt |= varIntByte & 0x7F;
        }
        byte[] initializationData = new byte[varInt];
        parent.readBytes(initializationData, 0, varInt);
        return initializationData;
    }

    private static void parseMoof(Track track, DefaultSampleValues extendsDefaults, Atom.ContainerAtom moof, TrackFragment out, int workaroundFlags) {
        FragmentedMp4Extractor.parseMfhd(moof.getLeafAtomOfType(1835427940).getData());
        FragmentedMp4Extractor.parseTraf(track, extendsDefaults, moof.getContainerAtomOfType(1953653094), out, workaroundFlags);
    }

    private static int parseMfhd(ParsableByteArray mfhd) {
        mfhd.setPosition(12);
        return mfhd.readUnsignedIntToInt();
    }

    private static void parseTraf(Track track, DefaultSampleValues extendsDefaults, Atom.ContainerAtom traf, TrackFragment out, int workaroundFlags) {
        Atom.LeafAtom tfdtAtom;
        Atom.LeafAtom saiz = traf.getLeafAtomOfType(1935763834);
        if (saiz != null) {
            FragmentedMp4Extractor.parseSaiz(saiz.getData(), out);
        }
        long decodeTime = (tfdtAtom = traf.getLeafAtomOfType(0x74666474)) == null ? 0L : FragmentedMp4Extractor.parseTfdt(traf.getLeafAtomOfType(0x74666474).getData());
        Atom.LeafAtom tfhd = traf.getLeafAtomOfType(1952868452);
        DefaultSampleValues fragmentHeader = FragmentedMp4Extractor.parseTfhd(extendsDefaults, tfhd.getData());
        out.setSampleDescriptionIndex(fragmentHeader.sampleDescriptionIndex);
        Atom.LeafAtom trun = traf.getLeafAtomOfType(1953658222);
        FragmentedMp4Extractor.parseTrun(track, fragmentHeader, decodeTime, workaroundFlags, trun.getData(), out);
        Atom.LeafAtom uuid = traf.getLeafAtomOfType(1970628964);
        if (uuid != null) {
            FragmentedMp4Extractor.parseUuid(uuid.getData(), out);
        }
    }

    private static void parseSaiz(ParsableByteArray saiz, TrackFragment out) {
        saiz.setPosition(8);
        int fullAtom = saiz.readInt();
        int flags = FragmentedMp4Extractor.parseFullAtomFlags(fullAtom);
        if ((flags & 1) == 1) {
            saiz.skip(8);
        }
        int defaultSampleInfoSize = saiz.readUnsignedByte();
        int sampleCount = saiz.readUnsignedIntToInt();
        int totalSize = 0;
        int[] sampleInfoSizes = new int[sampleCount];
        if (defaultSampleInfoSize == 0) {
            int i = 0;
            while (i < sampleCount) {
                sampleInfoSizes[i] = saiz.readUnsignedByte();
                totalSize += sampleInfoSizes[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < sampleCount) {
                sampleInfoSizes[i] = defaultSampleInfoSize;
                totalSize += defaultSampleInfoSize;
                ++i;
            }
        }
        out.setAuxiliarySampleInfoTables(totalSize, sampleInfoSizes);
    }

    private static DefaultSampleValues parseTfhd(DefaultSampleValues extendsDefaults, ParsableByteArray tfhd) {
        tfhd.setPosition(8);
        int fullAtom = tfhd.readInt();
        int flags = FragmentedMp4Extractor.parseFullAtomFlags(fullAtom);
        tfhd.skip(4);
        if ((flags & 1) != 0) {
            tfhd.skip(8);
        }
        int defaultSampleDescriptionIndex = (flags & 2) != 0 ? tfhd.readUnsignedIntToInt() - 1 : extendsDefaults.sampleDescriptionIndex;
        int defaultSampleDuration = (flags & 8) != 0 ? tfhd.readUnsignedIntToInt() : extendsDefaults.duration;
        int defaultSampleSize = (flags & 0x10) != 0 ? tfhd.readUnsignedIntToInt() : extendsDefaults.size;
        int defaultSampleFlags = (flags & 0x20) != 0 ? tfhd.readUnsignedIntToInt() : extendsDefaults.flags;
        return new DefaultSampleValues(defaultSampleDescriptionIndex, defaultSampleDuration, defaultSampleSize, defaultSampleFlags);
    }

    private static long parseTfdt(ParsableByteArray tfdt) {
        tfdt.setPosition(8);
        int fullAtom = tfdt.readInt();
        int version = FragmentedMp4Extractor.parseFullAtomVersion(fullAtom);
        return version == 1 ? tfdt.readUnsignedLongToLong() : tfdt.readUnsignedInt();
    }

    private static void parseTrun(Track track, DefaultSampleValues defaultSampleValues, long decodeTime, int workaroundFlags, ParsableByteArray trun, TrackFragment out) {
        trun.setPosition(8);
        int fullAtom = trun.readInt();
        int version = FragmentedMp4Extractor.parseFullAtomVersion(fullAtom);
        int flags = FragmentedMp4Extractor.parseFullAtomFlags(fullAtom);
        int numberOfEntries = trun.readUnsignedIntToInt();
        if ((flags & 1) != 0) {
            trun.skip(4);
        }
        boolean firstSampleFlagsPresent = (flags & 4) != 0;
        int firstSampleFlags = defaultSampleValues.flags;
        if (firstSampleFlagsPresent) {
            firstSampleFlags = trun.readUnsignedIntToInt();
        }
        boolean sampleDurationsPresent = (flags & 0x100) != 0;
        boolean sampleSizesPresent = (flags & 0x200) != 0;
        boolean sampleFlagsPresent = (flags & 0x400) != 0;
        boolean sampleCompositionTimeOffsetsPresent = (flags & 0x800) != 0;
        int[] sampleSizeTable = new int[numberOfEntries];
        int[] sampleDecodingTimeTable = new int[numberOfEntries];
        int[] sampleCompositionTimeOffsetTable = new int[numberOfEntries];
        boolean[] sampleIsSyncFrameTable = new boolean[numberOfEntries];
        long timescale = track.timescale;
        long cumulativeTime = decodeTime;
        boolean workaroundEveryVideoFrameIsSyncFrame = track.type == 1986618469 && (workaroundFlags & 1) == 1;
        int i = 0;
        while (i < numberOfEntries) {
            boolean isSync;
            int sampleFlags;
            int sampleSize;
            int sampleDuration = sampleDurationsPresent ? trun.readUnsignedIntToInt() : defaultSampleValues.duration;
            int n = sampleSize = sampleSizesPresent ? trun.readUnsignedIntToInt() : defaultSampleValues.size;
            int n2 = i == 0 && firstSampleFlagsPresent ? firstSampleFlags : (sampleFlags = sampleFlagsPresent ? trun.readInt() : defaultSampleValues.flags);
            if (sampleCompositionTimeOffsetsPresent) {
                int sampleOffset = version == 0 ? trun.readInt() : trun.readInt();
                sampleCompositionTimeOffsetTable[i] = (int)((long)(sampleOffset * 1000) / timescale);
            }
            sampleDecodingTimeTable[i] = (int)(cumulativeTime * 1000L / timescale);
            sampleSizeTable[i] = sampleSize;
            boolean bl = isSync = (sampleFlags >> 16 & 1) == 0;
            if (workaroundEveryVideoFrameIsSyncFrame && i != 0) {
                isSync = false;
            }
            if (isSync) {
                sampleIsSyncFrameTable[i] = true;
            }
            cumulativeTime += (long)sampleDuration;
            ++i;
        }
        out.setSampleTables(sampleSizeTable, sampleDecodingTimeTable, sampleCompositionTimeOffsetTable, sampleIsSyncFrameTable);
    }

    private static void parseUuid(ParsableByteArray uuid, TrackFragment out) {
        uuid.setPosition(8);
        byte[] extendedType = new byte[16];
        uuid.readBytes(extendedType, 0, 16);
        if (!Arrays.equals(extendedType, PIFF_SAMPLE_ENCRYPTION_BOX_EXTENDED_TYPE)) {
            return;
        }
        int fullAtom = uuid.readInt();
        int flags = FragmentedMp4Extractor.parseFullAtomFlags(fullAtom);
        if ((flags & 1) != 0) {
            throw new IllegalStateException("Overriding TrackEncryptionBox parameters is unsupported");
        }
        boolean subsampleEncryption = (flags & 2) != 0;
        int numberOfEntries = uuid.readUnsignedIntToInt();
        if (numberOfEntries != out.length) {
            throw new IllegalStateException("Length mismatch: " + numberOfEntries + ", " + out.length);
        }
        int sampleEncryptionDataLength = uuid.length() - uuid.getPosition();
        ParsableByteArray sampleEncryptionData = new ParsableByteArray(sampleEncryptionDataLength);
        uuid.readBytes(sampleEncryptionData.getData(), 0, sampleEncryptionData.length());
        out.setSmoothStreamingSampleEncryptionData(sampleEncryptionData, subsampleEncryption);
    }

    private static SegmentIndex parseSidx(ParsableByteArray atom) {
        long firstOffset;
        long earliestPresentationTime;
        atom.setPosition(8);
        int fullAtom = atom.readInt();
        int version = FragmentedMp4Extractor.parseFullAtomVersion(fullAtom);
        atom.skip(4);
        long timescale = atom.readUnsignedInt();
        if (version == 0) {
            earliestPresentationTime = atom.readUnsignedInt();
            firstOffset = atom.readUnsignedInt();
        } else {
            earliestPresentationTime = atom.readUnsignedLongToLong();
            firstOffset = atom.readUnsignedLongToLong();
        }
        atom.skip(2);
        int referenceCount = atom.readUnsignedShort();
        int[] sizes = new int[referenceCount];
        long[] offsets = new long[referenceCount];
        long[] durationsUs = new long[referenceCount];
        long[] timesUs = new long[referenceCount];
        long offset = firstOffset;
        long time = earliestPresentationTime;
        int i = 0;
        while (i < referenceCount) {
            int firstInt = atom.readInt();
            int type = Integer.MIN_VALUE & firstInt;
            if (type != 0) {
                throw new IllegalStateException("Unhandled indirect reference");
            }
            long referenceDuration = atom.readUnsignedInt();
            sizes[i] = Integer.MAX_VALUE & firstInt;
            offsets[i] = offset;
            timesUs[i] = time * 1000000L / timescale;
            long nextTimeUs = (time + referenceDuration) * 1000000L / timescale;
            durationsUs[i] = nextTimeUs - timesUs[i];
            time += referenceDuration;
            atom.skip(4);
            offset += (long)sizes[i];
            ++i;
        }
        return new SegmentIndex(atom.length(), sizes, offsets, durationsUs, timesUs);
    }

    private int readCencAuxiliaryData(NonBlockingInputStream inputStream) {
        int length = this.cencAuxiliaryData.length();
        int bytesRead = inputStream.read(this.cencAuxiliaryData.getData(), this.cencAuxiliaryBytesRead, length - this.cencAuxiliaryBytesRead);
        if (bytesRead == -1) {
            return 2;
        }
        this.cencAuxiliaryBytesRead += bytesRead;
        if (this.cencAuxiliaryBytesRead < length) {
            return 1;
        }
        this.enterState(3);
        return 0;
    }

    private int readOrSkipSample(NonBlockingInputStream inputStream, SampleHolder out) {
        if (this.sampleIndex >= this.fragmentRun.length) {
            this.enterState(0);
            return 0;
        }
        if (this.sampleIndex < this.pendingSeekSyncSampleIndex) {
            return this.skipSample(inputStream);
        }
        return this.readSample(inputStream, out);
    }

    private int skipSample(NonBlockingInputStream inputStream) {
        int sampleSize;
        int bytesRead;
        if (this.parserState == 3) {
            ParsableByteArray sampleEncryptionData;
            ParsableByteArray parsableByteArray = sampleEncryptionData = this.cencAuxiliaryData != null ? this.cencAuxiliaryData : this.fragmentRun.smoothStreamingSampleEncryptionData;
            if (sampleEncryptionData != null) {
                int subsampleCount;
                TrackEncryptionBox encryptionBox = this.track.sampleDescriptionEncryptionBoxes[this.fragmentRun.sampleDescriptionIndex];
                int vectorSize = encryptionBox.initializationVectorSize;
                boolean subsampleEncryption = this.cencAuxiliaryData != null ? this.fragmentRun.auxiliarySampleInfoSizeTable[this.sampleIndex] > vectorSize : this.fragmentRun.smoothStreamingUsesSubsampleEncryption;
                sampleEncryptionData.skip(vectorSize);
                int n = subsampleCount = subsampleEncryption ? sampleEncryptionData.readUnsignedShort() : 1;
                if (subsampleEncryption) {
                    sampleEncryptionData.skip(6 * subsampleCount);
                }
            }
        }
        if ((bytesRead = inputStream.skip((sampleSize = this.fragmentRun.sampleSizeTable[this.sampleIndex]) - this.sampleBytesRead)) == -1) {
            return 2;
        }
        this.sampleBytesRead += bytesRead;
        if (sampleSize != this.sampleBytesRead) {
            this.enterState(4);
            return 1;
        }
        ++this.sampleIndex;
        this.enterState(3);
        return 0;
    }

    @SuppressLint(value={"InlinedApi"})
    private int readSample(NonBlockingInputStream inputStream, SampleHolder out) {
        int bytesRead;
        if (out == null) {
            return 64;
        }
        int sampleSize = this.fragmentRun.sampleSizeTable[this.sampleIndex];
        ByteBuffer outputData = out.data;
        if (this.parserState == 3) {
            ParsableByteArray sampleEncryptionData;
            out.timeUs = (long)this.fragmentRun.getSamplePresentationTime(this.sampleIndex) * 1000L;
            out.flags = 0;
            if (this.fragmentRun.sampleIsSyncFrameTable[this.sampleIndex]) {
                out.flags |= 1;
                this.lastSyncSampleIndex = this.sampleIndex;
            }
            if (out.allowDataBufferReplacement && (out.data == null || out.data.capacity() < sampleSize)) {
                out.data = outputData = ByteBuffer.allocate(sampleSize);
            }
            ParsableByteArray parsableByteArray = sampleEncryptionData = this.cencAuxiliaryData != null ? this.cencAuxiliaryData : this.fragmentRun.smoothStreamingSampleEncryptionData;
            if (sampleEncryptionData != null) {
                this.readSampleEncryptionData(sampleEncryptionData, out);
            }
        }
        if ((bytesRead = outputData == null ? inputStream.skip(sampleSize - this.sampleBytesRead) : inputStream.read(outputData, sampleSize - this.sampleBytesRead)) == -1) {
            return 2;
        }
        this.sampleBytesRead += bytesRead;
        if (sampleSize != this.sampleBytesRead) {
            this.enterState(4);
            return 9;
        }
        if (outputData != null) {
            if (this.track.type == 1986618469) {
                int sampleOffset;
                int position = sampleOffset = outputData.position() - sampleSize;
                while (position < sampleOffset + sampleSize) {
                    outputData.position(position);
                    int length = FragmentedMp4Extractor.readUnsignedIntToInt(outputData);
                    outputData.position(position);
                    outputData.put(NAL_START_CODE);
                    position += length + 4;
                }
                outputData.position(sampleOffset + sampleSize);
            }
            out.size = sampleSize;
        } else {
            out.size = 0;
        }
        ++this.sampleIndex;
        this.enterState(3);
        return 4;
    }

    @SuppressLint(value={"InlinedApi"})
    private void readSampleEncryptionData(ParsableByteArray sampleEncryptionData, SampleHolder out) {
        int[] encryptedDataSizes;
        TrackEncryptionBox encryptionBox = this.track.sampleDescriptionEncryptionBoxes[this.fragmentRun.sampleDescriptionIndex];
        byte[] keyId = encryptionBox.keyId;
        boolean isEncrypted = encryptionBox.isEncrypted;
        int vectorSize = encryptionBox.initializationVectorSize;
        boolean subsampleEncryption = this.cencAuxiliaryData != null ? this.fragmentRun.auxiliarySampleInfoSizeTable[this.sampleIndex] > vectorSize : this.fragmentRun.smoothStreamingUsesSubsampleEncryption;
        byte[] vector = out.cryptoInfo.iv;
        if (vector == null || vector.length != 16) {
            vector = new byte[16];
        }
        sampleEncryptionData.readBytes(vector, 0, vectorSize);
        int subsampleCount = subsampleEncryption ? sampleEncryptionData.readUnsignedShort() : 1;
        int[] clearDataSizes = out.cryptoInfo.numBytesOfClearData;
        if (clearDataSizes == null || clearDataSizes.length < subsampleCount) {
            clearDataSizes = new int[subsampleCount];
        }
        if ((encryptedDataSizes = out.cryptoInfo.numBytesOfEncryptedData) == null || encryptedDataSizes.length < subsampleCount) {
            encryptedDataSizes = new int[subsampleCount];
        }
        if (subsampleEncryption) {
            int i = 0;
            while (i < subsampleCount) {
                clearDataSizes[i] = sampleEncryptionData.readUnsignedShort();
                encryptedDataSizes[i] = sampleEncryptionData.readUnsignedIntToInt();
                ++i;
            }
        } else {
            clearDataSizes[0] = 0;
            encryptedDataSizes[0] = this.fragmentRun.sampleSizeTable[this.sampleIndex];
        }
        out.cryptoInfo.set(subsampleCount, clearDataSizes, encryptedDataSizes, keyId, vector, isEncrypted ? 1 : 0);
        if (isEncrypted) {
            out.flags |= 2;
        }
    }

    private static int parseFullAtomVersion(int fullAtomInt) {
        return 0xFF & fullAtomInt >> 24;
    }

    private static int parseFullAtomFlags(int fullAtomInt) {
        return 0xFFFFFF & fullAtomInt;
    }

    private static int readUnsignedIntToInt(ByteBuffer data) {
        int result = 0xFF & data.get();
        int i = 1;
        while (i < 4) {
            result <<= 8;
            result |= 0xFF & data.get();
            ++i;
        }
        if (result < 0) {
            throw new IllegalArgumentException("Top bit not zero: " + result);
        }
        return result;
    }
}

