/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.drm;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.DeniedByServerException;
import android.media.MediaCrypto;
import android.media.MediaDrm;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.drm.MediaDrmCallback;
import java.util.Map;
import java.util.UUID;

@TargetApi(value=18)
public class StreamingDrmSessionManager
implements DrmSessionManager {
    private static final int MSG_PROVISION = 0;
    private static final int MSG_KEYS = 1;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private final MediaDrm mediaDrm;
    final MediaDrmHandler mediaDrmHandler;
    final MediaDrmCallback callback;
    final PostResponseHandler postResponseHandler;
    final UUID uuid;
    private HandlerThread requestHandlerThread;
    private Handler postRequestHandler;
    private int openCount;
    private int state;
    private MediaCrypto mediaCrypto;
    private Exception lastException;
    private String mimeType;
    private byte[] schemePsshData;
    private byte[] sessionId;

    public StreamingDrmSessionManager(UUID uuid, Looper playbackLooper, MediaDrmCallback callback, Handler eventHandler, EventListener eventListener) throws UnsupportedSchemeException {
        this.uuid = uuid;
        this.callback = callback;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.mediaDrm = new MediaDrm(uuid);
        this.mediaDrm.setOnEventListener((MediaDrm.OnEventListener)new MediaDrmEventListener());
        this.mediaDrmHandler = new MediaDrmHandler(playbackLooper);
        this.postResponseHandler = new PostResponseHandler(playbackLooper);
        this.state = 1;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public MediaCrypto getMediaCrypto() {
        if (this.state != 3 && this.state != 4) {
            throw new IllegalStateException();
        }
        return this.mediaCrypto;
    }

    @Override
    public boolean requiresSecureDecoderComponent(String mimeType) {
        if (this.state != 3 && this.state != 4) {
            throw new IllegalStateException();
        }
        return this.mediaCrypto.requiresSecureDecoderComponent(mimeType);
    }

    @Override
    public Exception getError() {
        return this.state == 0 ? this.lastException : null;
    }

    public final String getPropertyString(String key) {
        return this.mediaDrm.getPropertyString(key);
    }

    public final byte[] getPropertyByteArray(String key) {
        return this.mediaDrm.getPropertyByteArray(key);
    }

    @Override
    public void open(Map<UUID, byte[]> psshData, String mimeType) {
        if (++this.openCount != 1) {
            return;
        }
        if (this.postRequestHandler == null) {
            this.requestHandlerThread = new HandlerThread("DrmRequestHandler");
            this.requestHandlerThread.start();
            this.postRequestHandler = new PostRequestHandler(this.requestHandlerThread.getLooper());
        }
        if (this.schemePsshData == null) {
            this.mimeType = mimeType;
            this.schemePsshData = psshData.get(this.uuid);
            if (this.schemePsshData == null) {
                this.onError(new IllegalStateException("Media does not support uuid: " + this.uuid));
                return;
            }
        }
        this.state = 2;
        this.openInternal(true);
    }

    @Override
    public void close() {
        if (--this.openCount != 0) {
            return;
        }
        this.state = 1;
        this.mediaDrmHandler.removeCallbacksAndMessages(null);
        this.postResponseHandler.removeCallbacksAndMessages(null);
        this.postRequestHandler.removeCallbacksAndMessages(null);
        this.postRequestHandler = null;
        this.requestHandlerThread.quit();
        this.requestHandlerThread = null;
        this.schemePsshData = null;
        this.mediaCrypto = null;
        this.lastException = null;
        if (this.sessionId != null) {
            this.mediaDrm.closeSession(this.sessionId);
            this.sessionId = null;
        }
    }

    private void openInternal(boolean allowProvisioning) {
        try {
            this.sessionId = this.mediaDrm.openSession();
            this.mediaCrypto = new MediaCrypto(this.uuid, this.sessionId);
            this.state = 3;
            this.postKeyRequest();
        }
        catch (NotProvisionedException e) {
            if (allowProvisioning) {
                this.postProvisionRequest();
            } else {
                this.onError((Exception)((Object)e));
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    private void postProvisionRequest() {
        MediaDrm.ProvisionRequest request = this.mediaDrm.getProvisionRequest();
        this.postRequestHandler.obtainMessage(0, (Object)request).sendToTarget();
    }

    private void onProvisionResponse(Object response) {
        if (this.state != 2 && this.state != 3 && this.state != 4) {
            return;
        }
        if (response instanceof Exception) {
            this.onError((Exception)response);
            return;
        }
        try {
            this.mediaDrm.provideProvisionResponse((byte[])response);
            if (this.state == 2) {
                this.openInternal(false);
            } else {
                this.postKeyRequest();
            }
        }
        catch (DeniedByServerException e) {
            this.onError((Exception)((Object)e));
        }
    }

    private void postKeyRequest() {
        try {
            MediaDrm.KeyRequest keyRequest = this.mediaDrm.getKeyRequest(this.sessionId, this.schemePsshData, this.mimeType, 1, null);
            this.postRequestHandler.obtainMessage(1, (Object)keyRequest).sendToTarget();
        }
        catch (NotProvisionedException e) {
            this.onKeysError((Exception)((Object)e));
        }
    }

    private void onKeyResponse(Object response) {
        if (this.state != 3 && this.state != 4) {
            return;
        }
        if (response instanceof Exception) {
            this.onKeysError((Exception)response);
            return;
        }
        try {
            this.mediaDrm.provideKeyResponse(this.sessionId, (byte[])response);
            this.state = 4;
        }
        catch (Exception e) {
            this.onKeysError(e);
        }
    }

    private void onKeysError(Exception e) {
        if (e instanceof NotProvisionedException) {
            this.postProvisionRequest();
        } else {
            this.onError(e);
        }
    }

    private void onError(Exception e) {
        this.lastException = e;
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    StreamingDrmSessionManager.this.eventListener.onDrmSessionManagerError(StreamingDrmSessionManager.this.lastException);
                }
            });
        }
        if (this.state != 4) {
            this.state = 0;
        }
    }

    public static interface EventListener {
        public void onDrmSessionManagerError(Exception var1);
    }

    private class MediaDrmEventListener
    implements MediaDrm.OnEventListener {
        private MediaDrmEventListener() {
        }

        public void onEvent(MediaDrm md, byte[] sessionId, int event, int extra, byte[] data) {
            StreamingDrmSessionManager.this.mediaDrmHandler.sendEmptyMessage(event);
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class MediaDrmHandler
    extends Handler {
        public MediaDrmHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (StreamingDrmSessionManager.this.openCount == 0 || StreamingDrmSessionManager.this.state != 3 && StreamingDrmSessionManager.this.state != 4) {
                return;
            }
            switch (msg.what) {
                case 2: {
                    StreamingDrmSessionManager.this.postKeyRequest();
                    return;
                }
                case 3: {
                    StreamingDrmSessionManager.this.state = 3;
                    StreamingDrmSessionManager.this.postKeyRequest();
                    return;
                }
                case 1: {
                    StreamingDrmSessionManager.this.state = 3;
                    StreamingDrmSessionManager.this.postProvisionRequest();
                    return;
                }
            }
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class PostRequestHandler
    extends Handler {
        public PostRequestHandler(Looper backgroundLooper) {
            super(backgroundLooper);
        }

        public void handleMessage(Message msg) {
            Object response;
            try {
                switch (msg.what) {
                    case 0: {
                        response = StreamingDrmSessionManager.this.callback.executeProvisionRequest(StreamingDrmSessionManager.this.uuid, (MediaDrm.ProvisionRequest)msg.obj);
                        break;
                    }
                    case 1: {
                        response = StreamingDrmSessionManager.this.callback.executeKeyRequest(StreamingDrmSessionManager.this.uuid, (MediaDrm.KeyRequest)msg.obj);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
            catch (Exception e) {
                response = e;
            }
            StreamingDrmSessionManager.this.postResponseHandler.obtainMessage(msg.what, response).sendToTarget();
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class PostResponseHandler
    extends Handler {
        public PostResponseHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    StreamingDrmSessionManager.this.onProvisionResponse(msg.obj);
                    return;
                }
                case 1: {
                    StreamingDrmSessionManager.this.onKeyResponse(msg.obj);
                    return;
                }
            }
        }
    }
}

