/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.net.Uri;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.Representation;
import com.google.android.exoplayer.dash.mpd.UrlTemplate;
import java.util.List;

public abstract class SegmentBase {
    final RangedUri initialization;
    final long timescale;
    final long presentationTimeOffset;

    public SegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset) {
        this.initialization = initialization;
        this.timescale = timescale;
        this.presentationTimeOffset = presentationTimeOffset;
    }

    public RangedUri getInitialization(Representation representation) {
        return this.initialization;
    }

    public static abstract class MultiSegmentBase
    extends SegmentBase {
        final long periodDurationMs;
        final int startNumber;
        final long duration;
        final List<SegmentTimelineElement> segmentTimeline;

        public MultiSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, long periodDurationMs, int startNumber, long duration, List<SegmentTimelineElement> segmentTimeline) {
            super(initialization, timescale, presentationTimeOffset);
            this.periodDurationMs = periodDurationMs;
            this.startNumber = startNumber;
            this.duration = duration;
            this.segmentTimeline = segmentTimeline;
        }

        public final int getSegmentNum(long timeUs) {
            int index = this.startNumber;
            while (index + 1 <= this.getLastSegmentNum()) {
                if (this.getSegmentTimeUs(index + 1) <= timeUs) {
                    ++index;
                    continue;
                }
                return index;
            }
            return index;
        }

        public final long getSegmentDurationUs(int sequenceNumber) {
            if (this.segmentTimeline != null) {
                return this.segmentTimeline.get((int)(sequenceNumber - this.startNumber)).duration * 1000000L / this.timescale;
            }
            return sequenceNumber == this.getLastSegmentNum() ? this.periodDurationMs * 1000L - this.getSegmentTimeUs(sequenceNumber) : this.duration * 1000000L / this.timescale;
        }

        public final long getSegmentTimeUs(int sequenceNumber) {
            long unscaledSegmentTime = this.segmentTimeline != null ? this.segmentTimeline.get((int)(sequenceNumber - this.startNumber)).startTime - this.presentationTimeOffset : (long)(sequenceNumber - this.startNumber) * this.duration;
            return unscaledSegmentTime * 1000000L / this.timescale;
        }

        public abstract RangedUri getSegmentUrl(Representation var1, int var2);

        public int getFirstSegmentNum() {
            return this.startNumber;
        }

        public abstract int getLastSegmentNum();
    }

    public static class SegmentList
    extends MultiSegmentBase {
        final List<RangedUri> mediaSegments;

        public SegmentList(RangedUri initialization, long timescale, long presentationTimeOffset, long periodDurationMs, int startNumber, long duration, List<SegmentTimelineElement> segmentTimeline, List<RangedUri> mediaSegments) {
            super(initialization, timescale, presentationTimeOffset, periodDurationMs, startNumber, duration, segmentTimeline);
            this.mediaSegments = mediaSegments;
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, int sequenceNumber) {
            return this.mediaSegments.get(sequenceNumber - this.startNumber);
        }

        @Override
        public int getLastSegmentNum() {
            return this.startNumber + this.mediaSegments.size() - 1;
        }
    }

    public static class SegmentTemplate
    extends MultiSegmentBase {
        final UrlTemplate initializationTemplate;
        final UrlTemplate mediaTemplate;
        private final Uri baseUrl;

        public SegmentTemplate(RangedUri initialization, long timescale, long presentationTimeOffset, long periodDurationMs, int startNumber, long duration, List<SegmentTimelineElement> segmentTimeline, UrlTemplate initializationTemplate, UrlTemplate mediaTemplate, Uri baseUrl) {
            super(initialization, timescale, presentationTimeOffset, periodDurationMs, startNumber, duration, segmentTimeline);
            this.initializationTemplate = initializationTemplate;
            this.mediaTemplate = mediaTemplate;
            this.baseUrl = baseUrl;
        }

        @Override
        public RangedUri getInitialization(Representation representation) {
            if (this.initializationTemplate != null) {
                String urlString = this.initializationTemplate.buildUri(representation.format.id, 0, representation.format.bitrate, 0L);
                return new RangedUri(this.baseUrl, urlString, 0L, -1L);
            }
            return super.getInitialization(representation);
        }

        @Override
        public RangedUri getSegmentUrl(Representation representation, int sequenceNumber) {
            long time = 0L;
            time = this.segmentTimeline != null ? ((SegmentTimelineElement)this.segmentTimeline.get((int)(sequenceNumber - this.startNumber))).startTime : (long)(sequenceNumber - this.startNumber) * this.duration;
            String uriString = this.mediaTemplate.buildUri(representation.format.id, sequenceNumber, representation.format.bitrate, time);
            return new RangedUri(this.baseUrl, uriString, 0L, -1L);
        }

        @Override
        public int getLastSegmentNum() {
            if (this.segmentTimeline != null) {
                return this.segmentTimeline.size() + this.startNumber - 1;
            }
            long durationMs = this.duration * 1000L / this.timescale;
            return this.startNumber + (int)(this.periodDurationMs / durationMs);
        }
    }

    public static class SegmentTimelineElement {
        long startTime;
        long duration;

        public SegmentTimelineElement(long startTime, long duration) {
            this.startTime = startTime;
            this.duration = duration;
        }
    }

    public static class SingleSegmentBase
    extends SegmentBase {
        public final Uri uri;
        final long indexStart;
        final long indexLength;

        public SingleSegmentBase(RangedUri initialization, long timescale, long presentationTimeOffset, Uri uri, long indexStart, long indexLength) {
            super(initialization, timescale, presentationTimeOffset);
            this.uri = uri;
            this.indexStart = indexStart;
            this.indexLength = indexLength;
        }

        public RangedUri getIndex() {
            return new RangedUri(this.uri, null, this.indexStart, this.indexLength);
        }
    }
}

