/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash.mpd;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.dash.mpd.AdaptationSet;
import com.google.android.exoplayer.dash.mpd.ContentProtection;
import com.google.android.exoplayer.dash.mpd.MediaPresentationDescription;
import com.google.android.exoplayer.dash.mpd.Period;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.Representation;
import com.google.android.exoplayer.dash.mpd.SegmentBase;
import com.google.android.exoplayer.dash.mpd.UrlTemplate;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.MimeTypes;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class MediaPresentationDescriptionParser
extends DefaultHandler {
    private static final Pattern DURATION = Pattern.compile("^PT(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?$");
    private final XmlPullParserFactory xmlParserFactory;

    public MediaPresentationDescriptionParser() {
        try {
            this.xmlParserFactory = XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Couldn't create XmlPullParserFactory instance", e);
        }
    }

    public MediaPresentationDescription parseMediaPresentationDescription(InputStream inputStream, String inputEncoding, String contentId, Uri baseUrl) throws XmlPullParserException, IOException, ParserException {
        XmlPullParser xpp = this.xmlParserFactory.newPullParser();
        xpp.setInput(inputStream, inputEncoding);
        int eventType = xpp.next();
        if (eventType != 2 || !"MPD".equals(xpp.getName())) {
            throw new ParserException("inputStream does not contain a valid media presentation description");
        }
        return this.parseMediaPresentationDescription(xpp, contentId, baseUrl);
    }

    private MediaPresentationDescription parseMediaPresentationDescription(XmlPullParser xpp, String contentId, Uri baseUrl) throws XmlPullParserException, IOException {
        long durationMs = MediaPresentationDescriptionParser.parseDurationMs(xpp, "mediaPresentationDuration");
        long minBufferTimeMs = MediaPresentationDescriptionParser.parseDurationMs(xpp, "minBufferTime");
        String typeString = xpp.getAttributeValue(null, "type");
        boolean dynamic = typeString != null ? typeString.equals("dynamic") : false;
        long minUpdateTimeMs = dynamic ? MediaPresentationDescriptionParser.parseDurationMs(xpp, "minimumUpdatePeriod", -1L) : -1L;
        ArrayList<Period> periods = new ArrayList<Period>();
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "BaseURL")) {
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "Period")) continue;
            periods.add(this.parsePeriod(xpp, contentId, baseUrl, durationMs));
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "MPD"));
        return new MediaPresentationDescription(durationMs, minBufferTimeMs, dynamic, minUpdateTimeMs, periods);
    }

    private Period parsePeriod(XmlPullParser xpp, String contentId, Uri baseUrl, long mpdDurationMs) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        long startMs = MediaPresentationDescriptionParser.parseDurationMs(xpp, "start", 0L);
        long durationMs = MediaPresentationDescriptionParser.parseDurationMs(xpp, "duration", mpdDurationMs);
        SegmentBase segmentBase = null;
        ArrayList<AdaptationSet> adaptationSets = new ArrayList<AdaptationSet>();
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "BaseURL")) {
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "AdaptationSet")) {
                adaptationSets.add(this.parseAdaptationSet(xpp, contentId, baseUrl, startMs, durationMs, segmentBase));
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, null);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, null, durationMs);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentTemplate")) continue;
            segmentBase = this.parseSegmentTemplate(xpp, baseUrl, null, durationMs);
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "Period"));
        return new Period(id, startMs, durationMs, adaptationSets);
    }

    private AdaptationSet parseAdaptationSet(XmlPullParser xpp, String contentId, Uri baseUrl, long periodStartMs, long periodDurationMs, SegmentBase segmentBase) throws XmlPullParserException, IOException {
        String mimeType = xpp.getAttributeValue(null, "mimeType");
        int contentType = this.parseAdaptationSetTypeFromMimeType(mimeType);
        int id = -1;
        ArrayList<ContentProtection> contentProtections = null;
        ArrayList<Representation> representations = new ArrayList<Representation>();
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "BaseURL")) {
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "ContentProtection")) {
                if (contentProtections == null) {
                    contentProtections = new ArrayList<ContentProtection>();
                }
                contentProtections.add(this.parseContentProtection(xpp));
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "ContentComponent")) {
                id = Integer.parseInt(xpp.getAttributeValue(null, "id"));
                contentType = this.checkAdaptationSetTypeConsistency(contentType, this.parseAdaptationSetType(xpp.getAttributeValue(null, "contentType")));
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "Representation")) {
                Representation representation = this.parseRepresentation(xpp, contentId, baseUrl, periodStartMs, periodDurationMs, mimeType, segmentBase);
                contentType = this.checkAdaptationSetTypeConsistency(contentType, this.parseAdaptationSetTypeFromMimeType(representation.format.mimeType));
                representations.add(representation);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, (SegmentBase.SegmentList)segmentBase, periodDurationMs);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentTemplate")) continue;
            segmentBase = this.parseSegmentTemplate(xpp, baseUrl, (SegmentBase.SegmentTemplate)segmentBase, periodDurationMs);
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "AdaptationSet"));
        return new AdaptationSet(id, contentType, representations, contentProtections);
    }

    private int parseAdaptationSetType(String contentType) {
        return TextUtils.isEmpty((CharSequence)contentType) ? -1 : ("audio".equals(contentType) ? 1 : ("video".equals(contentType) ? 0 : ("text".equals(contentType) ? 2 : -1)));
    }

    private int parseAdaptationSetTypeFromMimeType(String mimeType) {
        return TextUtils.isEmpty((CharSequence)mimeType) ? -1 : (MimeTypes.isAudio(mimeType) ? 1 : (MimeTypes.isVideo(mimeType) ? 0 : (MimeTypes.isText(mimeType) || MimeTypes.isTtml(mimeType) ? 2 : -1)));
    }

    private int checkAdaptationSetTypeConsistency(int firstType, int secondType) {
        if (firstType == -1) {
            return secondType;
        }
        if (secondType == -1) {
            return firstType;
        }
        Assertions.checkState(firstType == secondType);
        return firstType;
    }

    protected ContentProtection parseContentProtection(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String schemeUriId = xpp.getAttributeValue(null, "schemeUriId");
        return new ContentProtection(schemeUriId, null);
    }

    private Representation parseRepresentation(XmlPullParser xpp, String contentId, Uri baseUrl, long periodStartMs, long periodDurationMs, String mimeType, SegmentBase segmentBase) throws XmlPullParserException, IOException {
        String id = xpp.getAttributeValue(null, "id");
        int bandwidth = MediaPresentationDescriptionParser.parseInt(xpp, "bandwidth");
        int audioSamplingRate = MediaPresentationDescriptionParser.parseInt(xpp, "audioSamplingRate");
        int width = MediaPresentationDescriptionParser.parseInt(xpp, "width");
        int height = MediaPresentationDescriptionParser.parseInt(xpp, "height");
        mimeType = MediaPresentationDescriptionParser.parseString(xpp, "mimeType", mimeType);
        int numChannels = -1;
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "BaseURL")) {
                baseUrl = MediaPresentationDescriptionParser.parseBaseUrl(xpp, baseUrl);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "AudioChannelConfiguration")) {
                numChannels = Integer.parseInt(xpp.getAttributeValue(null, "value"));
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentBase")) {
                segmentBase = this.parseSegmentBase(xpp, baseUrl, (SegmentBase.SingleSegmentBase)segmentBase);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentList")) {
                segmentBase = this.parseSegmentList(xpp, baseUrl, (SegmentBase.SegmentList)segmentBase, periodDurationMs);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentTemplate")) continue;
            segmentBase = this.parseSegmentTemplate(xpp, baseUrl, (SegmentBase.SegmentTemplate)segmentBase, periodDurationMs);
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "Representation"));
        Format format = new Format(id, mimeType, width, height, numChannels, audioSamplingRate, bandwidth);
        return Representation.newInstance(periodStartMs, periodDurationMs, contentId, -1L, format, segmentBase);
    }

    private SegmentBase.SingleSegmentBase parseSegmentBase(XmlPullParser xpp, Uri baseUrl, SegmentBase.SingleSegmentBase parent) throws XmlPullParserException, IOException {
        long timescale = MediaPresentationDescriptionParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = MediaPresentationDescriptionParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long indexStart = parent != null ? parent.indexStart : 0L;
        long indexLength = parent != null ? parent.indexLength : -1L;
        String indexRangeText = xpp.getAttributeValue(null, "indexRange");
        if (indexRangeText != null) {
            String[] indexRange = indexRangeText.split("-");
            indexStart = Long.parseLong(indexRange[0]);
            indexLength = Long.parseLong(indexRange[1]) - indexStart + 1L;
        }
        RangedUri initialization = parent != null ? parent.initialization : null;
        do {
            xpp.next();
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "Initialization")) continue;
            initialization = this.parseInitialization(xpp, baseUrl);
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "SegmentBase"));
        return new SegmentBase.SingleSegmentBase(initialization, timescale, presentationTimeOffset, baseUrl, indexStart, indexLength);
    }

    private SegmentBase.SegmentList parseSegmentList(XmlPullParser xpp, Uri baseUrl, SegmentBase.SegmentList parent, long periodDuration) throws XmlPullParserException, IOException {
        long timescale = MediaPresentationDescriptionParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = MediaPresentationDescriptionParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = MediaPresentationDescriptionParser.parseLong(xpp, "duration", parent != null ? parent.duration : -1L);
        int startNumber = MediaPresentationDescriptionParser.parseInt(xpp, "startNumber", parent != null ? parent.startNumber : 0);
        RangedUri initialization = null;
        List timeline = null;
        ArrayList<RangedUri> segments = null;
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "Initialization")) {
                initialization = this.parseInitialization(xpp, baseUrl);
                continue;
            }
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentTimeline")) {
                timeline = this.parseSegmentTimeline(xpp);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentURL")) continue;
            if (segments == null) {
                segments = new ArrayList<RangedUri>();
            }
            segments.add(this.parseSegmentUrl(xpp, baseUrl));
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "SegmentList"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
            segments = segments != null ? segments : parent.mediaSegments;
        }
        return new SegmentBase.SegmentList(initialization, timescale, presentationTimeOffset, periodDuration, startNumber, duration, timeline, segments);
    }

    private SegmentBase.SegmentTemplate parseSegmentTemplate(XmlPullParser xpp, Uri baseUrl, SegmentBase.SegmentTemplate parent, long periodDuration) throws XmlPullParserException, IOException {
        long timescale = MediaPresentationDescriptionParser.parseLong(xpp, "timescale", parent != null ? parent.timescale : 1L);
        long presentationTimeOffset = MediaPresentationDescriptionParser.parseLong(xpp, "presentationTimeOffset", parent != null ? parent.presentationTimeOffset : 0L);
        long duration = MediaPresentationDescriptionParser.parseLong(xpp, "duration", parent != null ? parent.duration : -1L);
        int startNumber = MediaPresentationDescriptionParser.parseInt(xpp, "startNumber", parent != null ? parent.startNumber : 0);
        UrlTemplate mediaTemplate = this.parseUrlTemplate(xpp, "media", parent != null ? parent.mediaTemplate : null);
        UrlTemplate initializationTemplate = this.parseUrlTemplate(xpp, "initialization", parent != null ? parent.initializationTemplate : null);
        RangedUri initialization = null;
        List timeline = null;
        do {
            xpp.next();
            if (MediaPresentationDescriptionParser.isStartTag(xpp, "Initialization")) {
                initialization = this.parseInitialization(xpp, baseUrl);
                continue;
            }
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "SegmentTimeline")) continue;
            timeline = this.parseSegmentTimeline(xpp);
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "SegmentTemplate"));
        if (parent != null) {
            initialization = initialization != null ? initialization : parent.initialization;
            timeline = timeline != null ? timeline : parent.segmentTimeline;
        }
        return new SegmentBase.SegmentTemplate(initialization, timescale, presentationTimeOffset, periodDuration, startNumber, duration, timeline, initializationTemplate, mediaTemplate, baseUrl);
    }

    private List<SegmentBase.SegmentTimelineElement> parseSegmentTimeline(XmlPullParser xpp) throws XmlPullParserException, IOException {
        ArrayList<SegmentBase.SegmentTimelineElement> segmentTimeline = new ArrayList<SegmentBase.SegmentTimelineElement>();
        long elapsedTime = 0L;
        do {
            xpp.next();
            if (!MediaPresentationDescriptionParser.isStartTag(xpp, "S")) continue;
            elapsedTime = MediaPresentationDescriptionParser.parseLong(xpp, "t", elapsedTime);
            long duration = MediaPresentationDescriptionParser.parseLong(xpp, "d");
            int count = 1 + MediaPresentationDescriptionParser.parseInt(xpp, "r", 0);
            int i = 0;
            while (i < count) {
                segmentTimeline.add(new SegmentBase.SegmentTimelineElement(elapsedTime, duration));
                elapsedTime += duration;
                ++i;
            }
        } while (!MediaPresentationDescriptionParser.isEndTag(xpp, "SegmentTimeline"));
        return segmentTimeline;
    }

    private UrlTemplate parseUrlTemplate(XmlPullParser xpp, String name, UrlTemplate defaultValue) {
        String valueString = xpp.getAttributeValue(null, name);
        if (valueString != null) {
            return UrlTemplate.compile(valueString);
        }
        return defaultValue;
    }

    private RangedUri parseInitialization(XmlPullParser xpp, Uri baseUrl) {
        return this.parseRangedUrl(xpp, baseUrl, "sourceURL", "range");
    }

    private RangedUri parseSegmentUrl(XmlPullParser xpp, Uri baseUrl) {
        return this.parseRangedUrl(xpp, baseUrl, "media", "mediaRange");
    }

    private RangedUri parseRangedUrl(XmlPullParser xpp, Uri baseUrl, String urlAttribute, String rangeAttribute) {
        String urlText = xpp.getAttributeValue(null, urlAttribute);
        long rangeStart = 0L;
        long rangeLength = -1L;
        String rangeText = xpp.getAttributeValue(null, rangeAttribute);
        if (rangeText != null) {
            String[] rangeTextArray = rangeText.split("-");
            rangeStart = Long.parseLong(rangeTextArray[0]);
            rangeLength = Long.parseLong(rangeTextArray[1]) - rangeStart + 1L;
        }
        return new RangedUri(baseUrl, urlText, rangeStart, rangeLength);
    }

    protected static boolean isEndTag(XmlPullParser xpp, String name) throws XmlPullParserException {
        return xpp.getEventType() == 3 && name.equals(xpp.getName());
    }

    protected static boolean isStartTag(XmlPullParser xpp, String name) throws XmlPullParserException {
        return xpp.getEventType() == 2 && name.equals(xpp.getName());
    }

    private static long parseDurationMs(XmlPullParser xpp, String name) {
        return MediaPresentationDescriptionParser.parseDurationMs(xpp, name, -1L);
    }

    private static long parseDurationMs(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        if (value != null) {
            Matcher matcher = DURATION.matcher(value);
            if (matcher.matches()) {
                String hours = matcher.group(2);
                double durationSeconds = hours != null ? Double.parseDouble(hours) * 3600.0 : 0.0;
                String minutes = matcher.group(4);
                durationSeconds += minutes != null ? Double.parseDouble(minutes) * 60.0 : 0.0;
                String seconds = matcher.group(6);
                return (long)((durationSeconds += seconds != null ? Double.parseDouble(seconds) : 0.0) * 1000.0);
            }
            return (long)(Double.parseDouble(value) * 3600.0 * 1000.0);
        }
        return defaultValue;
    }

    protected static Uri parseBaseUrl(XmlPullParser xpp, Uri parentBaseUrl) throws XmlPullParserException, IOException {
        xpp.next();
        String newBaseUrlText = xpp.getText();
        Uri newBaseUri = Uri.parse((String)newBaseUrlText);
        if (!newBaseUri.isAbsolute()) {
            newBaseUri = Uri.withAppendedPath((Uri)parentBaseUrl, (String)newBaseUrlText);
        }
        return newBaseUri;
    }

    protected static int parseInt(XmlPullParser xpp, String name) {
        return MediaPresentationDescriptionParser.parseInt(xpp, name, -1);
    }

    protected static int parseInt(XmlPullParser xpp, String name, int defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    protected static long parseLong(XmlPullParser xpp, String name) {
        return MediaPresentationDescriptionParser.parseLong(xpp, name, -1L);
    }

    protected static long parseLong(XmlPullParser xpp, String name, long defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    protected static String parseString(XmlPullParser xpp, String name, String defaultValue) {
        String value = xpp.getAttributeValue(null, name);
        return value == null ? defaultValue : value;
    }
}

