/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash;

import android.net.Uri;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.TrackInfo;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.chunk.WebmMediaChunk;
import com.google.android.exoplayer.dash.DashSegmentIndex;
import com.google.android.exoplayer.dash.DashWrappingSegmentIndex;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.Representation;
import com.google.android.exoplayer.parser.webm.DefaultWebmExtractor;
import com.google.android.exoplayer.parser.webm.WebmExtractor;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class DashWebmChunkSource
implements ChunkSource {
    private final TrackInfo trackInfo;
    private final DataSource dataSource;
    private final FormatEvaluator evaluator;
    private final FormatEvaluator.Evaluation evaluation;
    private final int maxWidth;
    private final int maxHeight;
    private final Format[] formats;
    private final HashMap<String, Representation> representations;
    private final HashMap<String, WebmExtractor> extractors;
    private final HashMap<String, DashSegmentIndex> segmentIndexes;
    private boolean lastChunkWasInitialization;

    public DashWebmChunkSource(DataSource dataSource, FormatEvaluator evaluator, Representation ... representations) {
        this.dataSource = dataSource;
        this.evaluator = evaluator;
        this.formats = new Format[representations.length];
        this.extractors = new HashMap();
        this.segmentIndexes = new HashMap();
        this.representations = new HashMap();
        this.trackInfo = new TrackInfo(representations[0].format.mimeType, representations[0].periodDurationMs * 1000L);
        this.evaluation = new FormatEvaluator.Evaluation();
        int maxWidth = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < representations.length) {
            this.formats[i] = representations[i].format;
            maxWidth = Math.max(this.formats[i].width, maxWidth);
            maxHeight = Math.max(this.formats[i].height, maxHeight);
            this.extractors.put(this.formats[i].id, new DefaultWebmExtractor());
            this.representations.put(this.formats[i].id, representations[i]);
            DashSegmentIndex segmentIndex = representations[i].getIndex();
            if (segmentIndex != null) {
                this.segmentIndexes.put(this.formats[i].id, segmentIndex);
            }
            ++i;
        }
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        Arrays.sort(this.formats, new Format.DecreasingBandwidthComparator());
    }

    @Override
    public final void getMaxVideoDimensions(MediaFormat out) {
        if (this.trackInfo.mimeType.startsWith("video")) {
            out.setMaxVideoDimensions(this.maxWidth, this.maxHeight);
        }
    }

    @Override
    public final TrackInfo getTrackInfo() {
        return this.trackInfo;
    }

    @Override
    public void enable() {
        this.evaluator.enable();
    }

    @Override
    public void disable(List<? extends MediaChunk> queue) {
        this.evaluator.disable();
    }

    @Override
    public void continueBuffering(long playbackPositionUs) {
    }

    @Override
    public final void getChunkOperation(List<? extends MediaChunk> queue, long seekPositionUs, long playbackPositionUs, ChunkOperationHolder out) {
        this.evaluation.queueSize = queue.size();
        if (this.evaluation.format == null || !this.lastChunkWasInitialization) {
            this.evaluator.evaluate(queue, playbackPositionUs, this.formats, this.evaluation);
        }
        Format selectedFormat = this.evaluation.format;
        out.queueSize = this.evaluation.queueSize;
        if (selectedFormat == null) {
            out.chunk = null;
            return;
        }
        if (out.queueSize == queue.size() && out.chunk != null && out.chunk.format.id.equals(selectedFormat.id)) {
            return;
        }
        Representation selectedRepresentation = this.representations.get(selectedFormat.id);
        WebmExtractor extractor = this.extractors.get(selectedRepresentation.format.id);
        if (!extractor.isPrepared()) {
            RangedUri initializationUri = selectedRepresentation.getInitializationUri().attemptMerge(selectedRepresentation.getIndexUri());
            Chunk initializationChunk = this.newInitializationChunk(initializationUri, selectedRepresentation, extractor, this.dataSource, this.evaluation.trigger);
            this.lastChunkWasInitialization = true;
            out.chunk = initializationChunk;
            return;
        }
        DashSegmentIndex segmentIndex = this.segmentIndexes.get(selectedRepresentation.format.id);
        int nextSegmentNum = queue.isEmpty() ? segmentIndex.getSegmentNum(seekPositionUs) : queue.get((int)(out.queueSize - 1)).nextChunkIndex;
        if (nextSegmentNum == -1) {
            out.chunk = null;
            return;
        }
        Chunk nextMediaChunk = this.newMediaChunk(selectedRepresentation, segmentIndex, extractor, this.dataSource, nextSegmentNum, this.evaluation.trigger);
        this.lastChunkWasInitialization = false;
        out.chunk = nextMediaChunk;
    }

    @Override
    public IOException getError() {
        return null;
    }

    @Override
    public void onChunkLoadError(Chunk chunk, Exception e) {
    }

    private Chunk newInitializationChunk(RangedUri initializationUri, Representation representation, WebmExtractor extractor, DataSource dataSource, int trigger) {
        DataSpec dataSpec = new DataSpec(initializationUri.getUri(), initializationUri.start, initializationUri.length, representation.getCacheKey());
        return new InitializationWebmLoadable(dataSource, dataSpec, trigger, representation.format, extractor);
    }

    private Chunk newMediaChunk(Representation representation, DashSegmentIndex segmentIndex, WebmExtractor extractor, DataSource dataSource, int segmentNum, int trigger) {
        int lastSegmentNum = segmentIndex.getLastSegmentNum();
        int nextSegmentNum = segmentNum == lastSegmentNum ? -1 : segmentNum + 1;
        long startTimeUs = segmentIndex.getTimeUs(segmentNum);
        long endTimeUs = segmentNum < lastSegmentNum ? segmentIndex.getTimeUs(segmentNum + 1) : startTimeUs + segmentIndex.getDurationUs(segmentNum);
        RangedUri segmentUri = segmentIndex.getSegmentUrl(segmentNum);
        DataSpec dataSpec = new DataSpec(segmentUri.getUri(), segmentUri.start, segmentUri.length, representation.getCacheKey());
        return new WebmMediaChunk(dataSource, dataSpec, representation.format, trigger, extractor, startTimeUs, endTimeUs, nextSegmentNum);
    }

    private class InitializationWebmLoadable
    extends Chunk {
        private final WebmExtractor extractor;
        private final Uri uri;

        public InitializationWebmLoadable(DataSource dataSource, DataSpec dataSpec, int trigger, Format format, WebmExtractor extractor) {
            super(dataSource, dataSpec, format, trigger);
            this.extractor = extractor;
            this.uri = dataSpec.uri;
        }

        @Override
        protected void consumeStream(NonBlockingInputStream stream) throws IOException {
            this.extractor.read(stream, null);
            if (!this.extractor.isPrepared()) {
                throw new ParserException("Invalid initialization data");
            }
            DashWebmChunkSource.this.segmentIndexes.put(this.format.id, new DashWrappingSegmentIndex(this.extractor.getCues(), this.uri, 0L));
        }
    }
}

