/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.dash;

import android.net.Uri;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.TrackInfo;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.FormatEvaluator;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.chunk.Mp4MediaChunk;
import com.google.android.exoplayer.dash.DashSegmentIndex;
import com.google.android.exoplayer.dash.DashWrappingSegmentIndex;
import com.google.android.exoplayer.dash.mpd.RangedUri;
import com.google.android.exoplayer.dash.mpd.Representation;
import com.google.android.exoplayer.parser.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class DashMp4ChunkSource
implements ChunkSource {
    private final TrackInfo trackInfo;
    private final DataSource dataSource;
    private final FormatEvaluator evaluator;
    private final FormatEvaluator.Evaluation evaluation;
    private final int maxWidth;
    private final int maxHeight;
    private final Format[] formats;
    private final HashMap<String, Representation> representations;
    private final HashMap<String, FragmentedMp4Extractor> extractors;
    private final HashMap<String, DashSegmentIndex> segmentIndexes;
    private boolean lastChunkWasInitialization;

    public DashMp4ChunkSource(DataSource dataSource, FormatEvaluator evaluator, Representation ... representations) {
        this.dataSource = dataSource;
        this.evaluator = evaluator;
        this.formats = new Format[representations.length];
        this.extractors = new HashMap();
        this.segmentIndexes = new HashMap();
        this.representations = new HashMap();
        this.trackInfo = new TrackInfo(representations[0].format.mimeType, representations[0].periodDurationMs * 1000L);
        this.evaluation = new FormatEvaluator.Evaluation();
        int maxWidth = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < representations.length) {
            this.formats[i] = representations[i].format;
            maxWidth = Math.max(this.formats[i].width, maxWidth);
            maxHeight = Math.max(this.formats[i].height, maxHeight);
            this.extractors.put(this.formats[i].id, new FragmentedMp4Extractor());
            this.representations.put(this.formats[i].id, representations[i]);
            DashSegmentIndex segmentIndex = representations[i].getIndex();
            if (segmentIndex != null) {
                this.segmentIndexes.put(this.formats[i].id, segmentIndex);
            }
            ++i;
        }
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        Arrays.sort(this.formats, new Format.DecreasingBandwidthComparator());
    }

    @Override
    public final void getMaxVideoDimensions(MediaFormat out) {
        if (this.trackInfo.mimeType.startsWith("video")) {
            out.setMaxVideoDimensions(this.maxWidth, this.maxHeight);
        }
    }

    @Override
    public final TrackInfo getTrackInfo() {
        return this.trackInfo;
    }

    @Override
    public void enable() {
        this.evaluator.enable();
    }

    @Override
    public void disable(List<? extends MediaChunk> queue) {
        this.evaluator.disable();
    }

    @Override
    public void continueBuffering(long playbackPositionUs) {
    }

    @Override
    public final void getChunkOperation(List<? extends MediaChunk> queue, long seekPositionUs, long playbackPositionUs, ChunkOperationHolder out) {
        this.evaluation.queueSize = queue.size();
        if (this.evaluation.format == null || !this.lastChunkWasInitialization) {
            this.evaluator.evaluate(queue, playbackPositionUs, this.formats, this.evaluation);
        }
        Format selectedFormat = this.evaluation.format;
        out.queueSize = this.evaluation.queueSize;
        if (selectedFormat == null) {
            out.chunk = null;
            return;
        }
        if (out.queueSize == queue.size() && out.chunk != null && out.chunk.format.id.equals(selectedFormat.id)) {
            return;
        }
        Representation selectedRepresentation = this.representations.get(selectedFormat.id);
        FragmentedMp4Extractor extractor = this.extractors.get(selectedRepresentation.format.id);
        RangedUri pendingInitializationUri = null;
        RangedUri pendingIndexUri = null;
        if (extractor.getTrack() == null) {
            pendingInitializationUri = selectedRepresentation.getInitializationUri();
        }
        if (!this.segmentIndexes.containsKey(selectedRepresentation.format.id)) {
            pendingIndexUri = selectedRepresentation.getIndexUri();
        }
        if (pendingInitializationUri != null || pendingIndexUri != null) {
            Chunk initializationChunk = this.newInitializationChunk(pendingInitializationUri, pendingIndexUri, selectedRepresentation, extractor, this.dataSource, this.evaluation.trigger);
            this.lastChunkWasInitialization = true;
            out.chunk = initializationChunk;
            return;
        }
        DashSegmentIndex segmentIndex = this.segmentIndexes.get(selectedRepresentation.format.id);
        int nextSegmentNum = queue.isEmpty() ? segmentIndex.getSegmentNum(seekPositionUs) : queue.get((int)(out.queueSize - 1)).nextChunkIndex;
        if (nextSegmentNum == -1) {
            out.chunk = null;
            return;
        }
        Chunk nextMediaChunk = this.newMediaChunk(selectedRepresentation, segmentIndex, extractor, this.dataSource, nextSegmentNum, this.evaluation.trigger);
        this.lastChunkWasInitialization = false;
        out.chunk = nextMediaChunk;
    }

    @Override
    public IOException getError() {
        return null;
    }

    @Override
    public void onChunkLoadError(Chunk chunk, Exception e) {
    }

    private Chunk newInitializationChunk(RangedUri initializationUri, RangedUri indexUri, Representation representation, FragmentedMp4Extractor extractor, DataSource dataSource, int trigger) {
        RangedUri requestUri;
        int expectedExtractorResult = 2;
        long indexAnchor = 0L;
        if (initializationUri != null) {
            expectedExtractorResult |= 0x10;
            requestUri = initializationUri.attemptMerge(indexUri);
            if (requestUri != null) {
                expectedExtractorResult |= 0x20;
                indexAnchor = indexUri.start + indexUri.length;
            } else {
                requestUri = initializationUri;
            }
        } else {
            requestUri = indexUri;
            indexAnchor = indexUri.start + indexUri.length;
            expectedExtractorResult |= 0x20;
        }
        DataSpec dataSpec = new DataSpec(requestUri.getUri(), requestUri.start, requestUri.length, representation.getCacheKey());
        return new InitializationMp4Loadable(dataSource, dataSpec, trigger, representation.format, extractor, expectedExtractorResult, indexAnchor);
    }

    private Chunk newMediaChunk(Representation representation, DashSegmentIndex segmentIndex, FragmentedMp4Extractor extractor, DataSource dataSource, int segmentNum, int trigger) {
        int lastSegmentNum = segmentIndex.getLastSegmentNum();
        int nextSegmentNum = segmentNum == lastSegmentNum ? -1 : segmentNum + 1;
        long startTimeUs = segmentIndex.getTimeUs(segmentNum);
        long endTimeUs = segmentNum < lastSegmentNum ? segmentIndex.getTimeUs(segmentNum + 1) : startTimeUs + segmentIndex.getDurationUs(segmentNum);
        RangedUri segmentUri = segmentIndex.getSegmentUrl(segmentNum);
        DataSpec dataSpec = new DataSpec(segmentUri.getUri(), segmentUri.start, segmentUri.length, representation.getCacheKey());
        return new Mp4MediaChunk(dataSource, dataSpec, representation.format, trigger, startTimeUs, endTimeUs, nextSegmentNum, extractor, false, 0L);
    }

    private class InitializationMp4Loadable
    extends Chunk {
        private final FragmentedMp4Extractor extractor;
        private final int expectedExtractorResult;
        private final long indexAnchor;
        private final Uri uri;

        public InitializationMp4Loadable(DataSource dataSource, DataSpec dataSpec, int trigger, Format format, FragmentedMp4Extractor extractor, int expectedExtractorResult, long indexAnchor) {
            super(dataSource, dataSpec, format, trigger);
            this.extractor = extractor;
            this.expectedExtractorResult = expectedExtractorResult;
            this.indexAnchor = indexAnchor;
            this.uri = dataSpec.uri;
        }

        @Override
        protected void consumeStream(NonBlockingInputStream stream) throws IOException {
            int result = this.extractor.read(stream, null);
            if (result != this.expectedExtractorResult) {
                throw new ParserException("Invalid extractor result. Expected " + this.expectedExtractorResult + ", got " + result);
            }
            if ((result & 0x20) != 0) {
                DashMp4ChunkSource.this.segmentIndexes.put(this.format.id, new DashWrappingSegmentIndex(this.extractor.getSegmentIndex(), this.uri, this.indexAnchor));
            }
        }
    }
}

