/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.ParserException;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.parser.mp4.FragmentedMp4Extractor;
import com.google.android.exoplayer.upstream.DataSource;
import com.google.android.exoplayer.upstream.DataSpec;
import com.google.android.exoplayer.upstream.NonBlockingInputStream;
import com.google.android.exoplayer.util.Assertions;
import java.util.Map;
import java.util.UUID;

public final class Mp4MediaChunk
extends MediaChunk {
    private final FragmentedMp4Extractor extractor;
    private final boolean maybeSelfContained;
    private final long sampleOffsetUs;
    private boolean prepared;
    private MediaFormat mediaFormat;
    private Map<UUID, byte[]> psshInfo;

    public Mp4MediaChunk(DataSource dataSource, DataSpec dataSpec, Format format, int trigger, long startTimeUs, long endTimeUs, int nextChunkIndex, FragmentedMp4Extractor extractor, boolean maybeSelfContained, long sampleOffsetUs) {
        super(dataSource, dataSpec, format, trigger, startTimeUs, endTimeUs, nextChunkIndex);
        this.extractor = extractor;
        this.maybeSelfContained = maybeSelfContained;
        this.sampleOffsetUs = sampleOffsetUs;
    }

    @Override
    public void seekToStart() {
        this.extractor.seekTo(0L, false);
        this.resetReadPosition();
    }

    @Override
    public boolean seekTo(long positionUs, boolean allowNoop) {
        long seekTimeUs = positionUs + this.sampleOffsetUs;
        boolean isDiscontinuous = this.extractor.seekTo(seekTimeUs, allowNoop);
        if (isDiscontinuous) {
            this.resetReadPosition();
        }
        return isDiscontinuous;
    }

    @Override
    public boolean prepare() throws ParserException {
        if (!this.prepared) {
            if (this.maybeSelfContained) {
                NonBlockingInputStream inputStream = this.getNonBlockingInputStream();
                Assertions.checkState(inputStream != null);
                int result = this.extractor.read(inputStream, null);
                this.prepared = (result & 0x40) != 0;
            } else {
                this.prepared = true;
            }
            if (this.prepared) {
                this.mediaFormat = Assertions.checkNotNull(this.extractor.getFormat());
                this.psshInfo = this.extractor.getPsshInfo();
            }
        }
        return this.prepared;
    }

    @Override
    public boolean read(SampleHolder holder) throws ParserException {
        boolean sampleRead;
        NonBlockingInputStream inputStream = this.getNonBlockingInputStream();
        Assertions.checkState(inputStream != null);
        int result = this.extractor.read(inputStream, holder);
        boolean bl = sampleRead = (result & 4) != 0;
        if (sampleRead) {
            holder.timeUs -= this.sampleOffsetUs;
        }
        return sampleRead;
    }

    @Override
    public MediaFormat getMediaFormat() {
        return this.mediaFormat;
    }

    @Override
    public Map<UUID, byte[]> getPsshInfo() {
        return this.psshInfo;
    }
}

