/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import android.util.Log;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.upstream.BandwidthMeter;
import java.util.List;
import java.util.Random;

public interface FormatEvaluator {
    public static final int TRIGGER_INITIAL = 0;
    public static final int TRIGGER_MANUAL = 1;
    public static final int TRIGGER_ADAPTIVE = 2;
    public static final int TRIGGER_CUSTOM_BASE = 10000;

    public void enable();

    public void disable();

    public void evaluate(List<? extends MediaChunk> var1, long var2, Format[] var4, Evaluation var5);

    public static class AdaptiveEvaluator
    implements FormatEvaluator {
        private static final String TAG = "AdaptiveEvaluator";
        public static final int DEFAULT_MAX_INITIAL_BYTE_RATE = 100000;
        public static final int DEFAULT_MIN_DURATION_FOR_QUALITY_INCREASE_MS = 10000;
        public static final int DEFAULT_MAX_DURATION_FOR_QUALITY_DECREASE_MS = 25000;
        public static final int DEFAULT_MIN_DURATION_TO_RETAIN_AFTER_DISCARD_MS = 25000;
        public static final float DEFAULT_BANDWIDTH_FRACTION = 0.75f;
        private final BandwidthMeter bandwidthMeter;
        private final int maxInitialByteRate;
        private final long minDurationForQualityIncreaseUs;
        private final long maxDurationForQualityDecreaseUs;
        private final long minDurationToRetainAfterDiscardUs;
        private final float bandwidthFraction;

        public AdaptiveEvaluator(BandwidthMeter bandwidthMeter) {
            this(bandwidthMeter, 100000, 10000, 25000, 25000, 0.75f);
        }

        public AdaptiveEvaluator(BandwidthMeter bandwidthMeter, int maxInitialByteRate, int minDurationForQualityIncreaseMs, int maxDurationForQualityDecreaseMs, int minDurationToRetainAfterDiscardMs, float bandwidthFraction) {
            Log.d((String)TAG, (String)TAG);
            this.bandwidthMeter = bandwidthMeter;
            this.maxInitialByteRate = maxInitialByteRate;
            this.minDurationForQualityIncreaseUs = (long)minDurationForQualityIncreaseMs * 1000L;
            this.maxDurationForQualityDecreaseUs = (long)maxDurationForQualityDecreaseMs * 1000L;
            this.minDurationToRetainAfterDiscardUs = (long)minDurationToRetainAfterDiscardMs * 1000L;
            this.bandwidthFraction = bandwidthFraction;
        }

        @Override
        public void enable() {
        }

        @Override
        public void disable() {
        }

        @Override
        public void evaluate(List<? extends MediaChunk> queue, long playbackPositionUs, Format[] formats, Evaluation evaluation) {
            boolean isLower;
            Log.d((String)TAG, (String)"evaluate");
            long bufferedDurationUs = queue.isEmpty() ? 0L : queue.get((int)(queue.size() - 1)).endTimeUs - playbackPositionUs;
            Format current = evaluation.format;
            Log.i((String)TAG, (String)("current index = " + current + " formats.length = " + formats.length));
            Format ideal = this.determineIdealFormat(formats, this.bandwidthMeter.getEstimate());
            boolean isHigher = ideal != null && current != null && ideal.bitrate > current.bitrate;
            boolean bl = isLower = ideal != null && current != null && ideal.bitrate < current.bitrate;
            if (isHigher) {
                if (bufferedDurationUs < this.minDurationForQualityIncreaseUs) {
                    ideal = current;
                } else if (bufferedDurationUs >= this.minDurationToRetainAfterDiscardUs) {
                    int i = 1;
                    while (i < queue.size()) {
                        MediaChunk thisChunk = queue.get(i);
                        long durationBeforeThisSegmentUs = thisChunk.startTimeUs - playbackPositionUs;
                        if (durationBeforeThisSegmentUs >= this.minDurationToRetainAfterDiscardUs && thisChunk.format.bitrate < ideal.bitrate && thisChunk.format.height < ideal.height && thisChunk.format.height < 720 && thisChunk.format.width < 1280) {
                            evaluation.queueSize = i;
                            break;
                        }
                        ++i;
                    }
                }
            } else if (isLower && current != null && bufferedDurationUs >= this.maxDurationForQualityDecreaseUs) {
                ideal = current;
            }
            if (current != null && ideal != current) {
                evaluation.trigger = 2;
            }
            evaluation.format = ideal;
        }

        protected Format determineIdealFormat(Format[] formats, long bandwidthEstimate) {
            Log.d((String)TAG, (String)"determineIdealFormat");
            long effectiveBandwidth = this.computeEffectiveBandwidthEstimate(bandwidthEstimate);
            int i = 0;
            while (i < formats.length) {
                Format format = formats[i];
                if ((long)(format.bitrate / 8) <= effectiveBandwidth) {
                    return format;
                }
                ++i;
            }
            return formats[formats.length - 1];
        }

        protected long computeEffectiveBandwidthEstimate(long bandwidthEstimate) {
            Log.d((String)TAG, (String)"computeEffectiveBandwidthEstimate");
            return bandwidthEstimate == -1L ? (long)this.maxInitialByteRate : (long)((float)bandwidthEstimate * this.bandwidthFraction);
        }
    }

    public static final class Evaluation {
        public int queueSize;
        public int trigger = 0;
        public Format format;
    }

    public static class FixedEvaluator
    implements FormatEvaluator {
        @Override
        public void enable() {
        }

        @Override
        public void disable() {
        }

        @Override
        public void evaluate(List<? extends MediaChunk> queue, long playbackPositionUs, Format[] formats, Evaluation evaluation) {
            evaluation.format = formats[0];
        }
    }

    public static class RandomEvaluator
    implements FormatEvaluator {
        private final Random random = new Random();

        @Override
        public void enable() {
        }

        @Override
        public void disable() {
        }

        @Override
        public void evaluate(List<? extends MediaChunk> queue, long playbackPositionUs, Format[] formats, Evaluation evaluation) {
            Format newFormat = formats[this.random.nextInt(formats.length)];
            if (evaluation.format != null && !evaluation.format.id.equals(newFormat.id)) {
                evaluation.trigger = 2;
            }
            evaluation.format = newFormat;
        }
    }
}

