/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer.chunk;

import android.os.Handler;
import android.os.SystemClock;
import com.google.android.exoplayer.FormatHolder;
import com.google.android.exoplayer.LoadControl;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackInfo;
import com.google.android.exoplayer.chunk.Chunk;
import com.google.android.exoplayer.chunk.ChunkOperationHolder;
import com.google.android.exoplayer.chunk.ChunkSource;
import com.google.android.exoplayer.chunk.Format;
import com.google.android.exoplayer.chunk.MediaChunk;
import com.google.android.exoplayer.upstream.Loader;
import com.google.android.exoplayer.util.Assertions;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ChunkSampleSource
implements SampleSource,
Loader.Listener {
    private static final int STATE_UNPREPARED = 0;
    private static final int STATE_PREPARED = 1;
    private static final int STATE_ENABLED = 2;
    private static final int NO_RESET_PENDING = -1;
    private final int eventSourceId;
    private final LoadControl loadControl;
    private final ChunkSource chunkSource;
    private final ChunkOperationHolder currentLoadableHolder;
    private final LinkedList<MediaChunk> mediaChunks;
    private final List<MediaChunk> readOnlyMediaChunks;
    private final int bufferSizeContribution;
    private final boolean frameAccurateSeeking;
    private final Handler eventHandler;
    private final EventListener eventListener;
    private int state;
    private long downstreamPositionUs;
    private long lastSeekPositionUs;
    private long pendingResetTime;
    private long lastPerformedBufferOperation;
    private boolean pendingDiscontinuity;
    private Loader loader;
    private IOException currentLoadableException;
    private boolean currentLoadableExceptionFatal;
    private int currentLoadableExceptionCount;
    private long currentLoadableExceptionTimestamp;
    private MediaFormat downstreamMediaFormat;
    private volatile Format downstreamFormat;

    public ChunkSampleSource(ChunkSource chunkSource, LoadControl loadControl, int bufferSizeContribution, boolean frameAccurateSeeking) {
        this(chunkSource, loadControl, bufferSizeContribution, frameAccurateSeeking, null, null, 0);
    }

    public ChunkSampleSource(ChunkSource chunkSource, LoadControl loadControl, int bufferSizeContribution, boolean frameAccurateSeeking, Handler eventHandler, EventListener eventListener, int eventSourceId) {
        this.chunkSource = chunkSource;
        this.loadControl = loadControl;
        this.bufferSizeContribution = bufferSizeContribution;
        this.frameAccurateSeeking = frameAccurateSeeking;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.eventSourceId = eventSourceId;
        this.currentLoadableHolder = new ChunkOperationHolder();
        this.mediaChunks = new LinkedList();
        this.readOnlyMediaChunks = Collections.unmodifiableList(this.mediaChunks);
        this.state = 0;
    }

    public Format getFormat() {
        return this.downstreamFormat;
    }

    @Override
    public boolean prepare() {
        Assertions.checkState(this.state == 0);
        this.loader = new Loader("Loader:" + this.chunkSource.getTrackInfo().mimeType, this);
        this.state = 1;
        return true;
    }

    @Override
    public int getTrackCount() {
        Assertions.checkState(this.state != 0);
        return 1;
    }

    @Override
    public TrackInfo getTrackInfo(int track) {
        Assertions.checkState(this.state != 0);
        Assertions.checkState(track == 0);
        return this.chunkSource.getTrackInfo();
    }

    @Override
    public void enable(int track, long timeUs) {
        Assertions.checkState(this.state == 1);
        Assertions.checkState(track == 0);
        this.state = 2;
        this.chunkSource.enable();
        this.loadControl.register(this, this.bufferSizeContribution);
        this.downstreamFormat = null;
        this.downstreamMediaFormat = null;
        this.downstreamPositionUs = timeUs;
        this.lastSeekPositionUs = timeUs;
        this.restartFrom(timeUs);
    }

    @Override
    public void disable(int track) {
        Assertions.checkState(this.state == 2);
        Assertions.checkState(track == 0);
        this.pendingDiscontinuity = false;
        this.state = 1;
        this.loadControl.unregister(this);
        this.chunkSource.disable(this.mediaChunks);
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.clearMediaChunks();
            this.clearCurrentLoadable();
            this.loadControl.trimAllocator();
        }
    }

    @Override
    public void continueBuffering(long playbackPositionUs) {
        Assertions.checkState(this.state == 2);
        this.downstreamPositionUs = playbackPositionUs;
        this.chunkSource.continueBuffering(playbackPositionUs);
        this.updateLoadControl();
    }

    @Override
    public int readData(int track, long playbackPositionUs, FormatHolder formatHolder, SampleHolder sampleHolder, boolean onlyReadDiscontinuity) throws IOException {
        Assertions.checkState(this.state == 2);
        Assertions.checkState(track == 0);
        if (this.pendingDiscontinuity) {
            this.pendingDiscontinuity = false;
            return -5;
        }
        if (onlyReadDiscontinuity) {
            return -2;
        }
        this.downstreamPositionUs = playbackPositionUs;
        if (this.isPendingReset()) {
            if (this.currentLoadableException != null) {
                throw this.currentLoadableException;
            }
            IOException chunkSourceException = this.chunkSource.getError();
            if (chunkSourceException != null) {
                throw chunkSourceException;
            }
            return -2;
        }
        MediaChunk mediaChunk = this.mediaChunks.getFirst();
        if (mediaChunk.isReadFinished()) {
            if (this.mediaChunks.size() > 1) {
                this.discardDownstreamMediaChunk();
                mediaChunk = this.mediaChunks.getFirst();
                mediaChunk.seekToStart();
                return this.readData(track, playbackPositionUs, formatHolder, sampleHolder, false);
            }
            if (mediaChunk.isLastChunk()) {
                return -1;
            }
            IOException chunkSourceException = this.chunkSource.getError();
            if (chunkSourceException != null) {
                throw chunkSourceException;
            }
            return -2;
        }
        if (this.downstreamFormat == null || !this.downstreamFormat.equals(mediaChunk.format)) {
            this.notifyDownstreamFormatChanged(mediaChunk.format.id, mediaChunk.trigger, mediaChunk.startTimeUs);
            this.downstreamFormat = mediaChunk.format;
        }
        if (!mediaChunk.prepare()) {
            return -2;
        }
        MediaFormat mediaFormat = mediaChunk.getMediaFormat();
        if (mediaFormat != null && !mediaFormat.equals(this.downstreamMediaFormat)) {
            this.chunkSource.getMaxVideoDimensions(mediaFormat);
            formatHolder.format = mediaFormat;
            formatHolder.drmInitData = mediaChunk.getPsshInfo();
            this.downstreamMediaFormat = mediaFormat;
            return -4;
        }
        if (mediaChunk.read(sampleHolder)) {
            sampleHolder.decodeOnly = this.frameAccurateSeeking && sampleHolder.timeUs < this.lastSeekPositionUs;
            this.onSampleRead(mediaChunk, sampleHolder);
            return -3;
        }
        if (this.currentLoadableException != null) {
            throw this.currentLoadableException;
        }
        return -2;
    }

    @Override
    public void seekToUs(long timeUs) {
        Assertions.checkState(this.state == 2);
        this.downstreamPositionUs = timeUs;
        this.lastSeekPositionUs = timeUs;
        if (this.pendingResetTime == timeUs) {
            return;
        }
        MediaChunk mediaChunk = this.getMediaChunk(timeUs);
        if (mediaChunk == null) {
            this.restartFrom(timeUs);
            this.pendingDiscontinuity = true;
        } else {
            this.pendingDiscontinuity |= mediaChunk.seekTo(timeUs, mediaChunk == this.mediaChunks.getFirst());
            this.discardDownstreamMediaChunks(mediaChunk);
            this.updateLoadControl();
        }
    }

    private MediaChunk getMediaChunk(long timeUs) {
        for (MediaChunk mediaChunk : this.mediaChunks) {
            if (timeUs < mediaChunk.startTimeUs) {
                return null;
            }
            if (!mediaChunk.isLastChunk() && timeUs >= mediaChunk.endTimeUs) continue;
            return mediaChunk;
        }
        return null;
    }

    @Override
    public long getBufferedPositionUs() {
        Assertions.checkState(this.state == 2);
        if (this.isPendingReset()) {
            return this.pendingResetTime;
        }
        MediaChunk mediaChunk = this.mediaChunks.getLast();
        Chunk currentLoadable = this.currentLoadableHolder.chunk;
        if (currentLoadable != null && mediaChunk == currentLoadable) {
            long chunkLength = mediaChunk.getLength();
            if (chunkLength != -1L) {
                return mediaChunk.startTimeUs + (mediaChunk.endTimeUs - mediaChunk.startTimeUs) * mediaChunk.bytesLoaded() / chunkLength;
            }
            return mediaChunk.startTimeUs;
        }
        if (mediaChunk.isLastChunk()) {
            return -3L;
        }
        return mediaChunk.endTimeUs;
    }

    @Override
    public void release() {
        Assertions.checkState(this.state != 2);
        if (this.loader != null) {
            this.loader.release();
            this.loader = null;
        }
        this.state = 0;
    }

    @Override
    public void onLoaded() {
        Chunk currentLoadable = this.currentLoadableHolder.chunk;
        try {
            try {
                currentLoadable.consume();
            }
            catch (IOException e) {
                this.currentLoadableException = e;
                ++this.currentLoadableExceptionCount;
                this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
                this.currentLoadableExceptionFatal = true;
                this.notifyConsumptionError(e);
                if (!this.isMediaChunk(currentLoadable)) {
                    currentLoadable.release();
                }
                if (!this.currentLoadableExceptionFatal) {
                    this.clearCurrentLoadable();
                }
                this.notifyLoadCompleted();
                this.updateLoadControl();
            }
        }
        finally {
            if (!this.isMediaChunk(currentLoadable)) {
                currentLoadable.release();
            }
            if (!this.currentLoadableExceptionFatal) {
                this.clearCurrentLoadable();
            }
            this.notifyLoadCompleted();
            this.updateLoadControl();
        }
    }

    @Override
    public void onCanceled() {
        Chunk currentLoadable = this.currentLoadableHolder.chunk;
        if (!this.isMediaChunk(currentLoadable)) {
            currentLoadable.release();
        }
        this.clearCurrentLoadable();
        this.notifyLoadCanceled();
        if (this.state == 2) {
            this.restartFrom(this.pendingResetTime);
        } else {
            this.clearMediaChunks();
            this.loadControl.trimAllocator();
        }
    }

    @Override
    public void onError(IOException e) {
        this.currentLoadableException = e;
        ++this.currentLoadableExceptionCount;
        this.currentLoadableExceptionTimestamp = SystemClock.elapsedRealtime();
        this.notifyUpstreamError(e);
        this.chunkSource.onChunkLoadError(this.currentLoadableHolder.chunk, e);
        this.updateLoadControl();
    }

    protected void onSampleRead(MediaChunk mediaChunk, SampleHolder sampleHolder) {
    }

    private void restartFrom(long timeUs) {
        this.pendingResetTime = timeUs;
        if (this.loader.isLoading()) {
            this.loader.cancelLoading();
        } else {
            this.clearMediaChunks();
            this.clearCurrentLoadable();
            this.updateLoadControl();
        }
    }

    private void clearMediaChunks() {
        this.discardDownstreamMediaChunks(null);
    }

    private void clearCurrentLoadable() {
        this.currentLoadableHolder.chunk = null;
        this.currentLoadableException = null;
        this.currentLoadableExceptionCount = 0;
        this.currentLoadableExceptionFatal = false;
    }

    private void updateLoadControl() {
        long loadPositionUs;
        if (this.isPendingReset()) {
            loadPositionUs = this.pendingResetTime;
        } else {
            MediaChunk lastMediaChunk = this.mediaChunks.getLast();
            loadPositionUs = lastMediaChunk.nextChunkIndex == -1 ? -1L : lastMediaChunk.endTimeUs;
        }
        boolean isBackedOff = this.currentLoadableException != null && !this.currentLoadableExceptionFatal;
        boolean nextLoader = this.loadControl.update(this, this.downstreamPositionUs, loadPositionUs, isBackedOff || this.loader.isLoading(), this.currentLoadableExceptionFatal);
        if (this.currentLoadableExceptionFatal) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        if (isBackedOff) {
            long elapsedMillis = now - this.currentLoadableExceptionTimestamp;
            if (elapsedMillis >= this.getRetryDelayMillis(this.currentLoadableExceptionCount)) {
                this.resumeFromBackOff();
            }
            return;
        }
        if (!this.loader.isLoading()) {
            if (this.currentLoadableHolder.chunk == null || now - this.lastPerformedBufferOperation > 1000L) {
                this.lastPerformedBufferOperation = now;
                this.currentLoadableHolder.queueSize = this.readOnlyMediaChunks.size();
                this.chunkSource.getChunkOperation(this.readOnlyMediaChunks, this.pendingResetTime, this.downstreamPositionUs, this.currentLoadableHolder);
                this.discardUpstreamMediaChunks(this.currentLoadableHolder.queueSize);
            }
            if (nextLoader) {
                this.maybeStartLoading();
            }
        }
    }

    private void resumeFromBackOff() {
        this.currentLoadableException = null;
        Chunk backedOffChunk = this.currentLoadableHolder.chunk;
        if (!this.isMediaChunk(backedOffChunk)) {
            this.currentLoadableHolder.queueSize = this.readOnlyMediaChunks.size();
            this.chunkSource.getChunkOperation(this.readOnlyMediaChunks, this.pendingResetTime, this.downstreamPositionUs, this.currentLoadableHolder);
            this.discardUpstreamMediaChunks(this.currentLoadableHolder.queueSize);
            if (this.currentLoadableHolder.chunk == backedOffChunk) {
                this.loader.startLoading(backedOffChunk);
            } else {
                backedOffChunk.release();
                this.maybeStartLoading();
            }
            return;
        }
        if (backedOffChunk == this.mediaChunks.getFirst()) {
            this.loader.startLoading(backedOffChunk);
            return;
        }
        MediaChunk removedChunk = this.mediaChunks.removeLast();
        Assertions.checkState(backedOffChunk == removedChunk);
        this.currentLoadableHolder.queueSize = this.readOnlyMediaChunks.size();
        this.chunkSource.getChunkOperation(this.readOnlyMediaChunks, this.pendingResetTime, this.downstreamPositionUs, this.currentLoadableHolder);
        this.mediaChunks.add(removedChunk);
        if (this.currentLoadableHolder.chunk == backedOffChunk) {
            this.loader.startLoading(backedOffChunk);
        } else {
            this.discardUpstreamMediaChunks(this.currentLoadableHolder.queueSize);
            this.clearCurrentLoadable();
            this.maybeStartLoading();
        }
    }

    private void maybeStartLoading() {
        Chunk currentLoadable = this.currentLoadableHolder.chunk;
        if (currentLoadable == null) {
            return;
        }
        currentLoadable.init(this.loadControl.getAllocator());
        if (this.isMediaChunk(currentLoadable)) {
            MediaChunk mediaChunk = (MediaChunk)currentLoadable;
            if (this.isPendingReset()) {
                mediaChunk.seekTo(this.pendingResetTime, false);
                this.pendingResetTime = -1L;
            }
            this.mediaChunks.add(mediaChunk);
            this.notifyLoadStarted(mediaChunk.format.id, mediaChunk.trigger, false, mediaChunk.startTimeUs, mediaChunk.endTimeUs, mediaChunk.getLength());
        } else {
            this.notifyLoadStarted(currentLoadable.format.id, currentLoadable.trigger, true, -1L, -1L, currentLoadable.getLength());
        }
        this.loader.startLoading(currentLoadable);
    }

    private void discardDownstreamMediaChunks(MediaChunk untilChunk) {
        if (this.mediaChunks.isEmpty() || untilChunk == this.mediaChunks.getFirst()) {
            return;
        }
        long totalBytes = 0L;
        long startTimeUs = this.mediaChunks.getFirst().startTimeUs;
        long endTimeUs = 0L;
        while (!this.mediaChunks.isEmpty() && untilChunk != this.mediaChunks.getFirst()) {
            MediaChunk removed = this.mediaChunks.removeFirst();
            totalBytes += removed.bytesLoaded();
            endTimeUs = removed.endTimeUs;
            removed.release();
        }
        this.notifyDownstreamDiscarded(startTimeUs, endTimeUs, totalBytes);
    }

    private void discardDownstreamMediaChunk() {
        MediaChunk removed = this.mediaChunks.removeFirst();
        long totalBytes = removed.bytesLoaded();
        removed.release();
        this.notifyDownstreamDiscarded(removed.startTimeUs, removed.endTimeUs, totalBytes);
    }

    private void discardUpstreamMediaChunks(int queueLength) {
        if (this.mediaChunks.size() <= queueLength) {
            return;
        }
        long totalBytes = 0L;
        long startTimeUs = 0L;
        long endTimeUs = this.mediaChunks.getLast().endTimeUs;
        while (this.mediaChunks.size() > queueLength) {
            MediaChunk removed = this.mediaChunks.removeLast();
            totalBytes += removed.bytesLoaded();
            startTimeUs = removed.startTimeUs;
            removed.release();
        }
        this.notifyUpstreamDiscarded(startTimeUs, endTimeUs, totalBytes);
    }

    private boolean isMediaChunk(Chunk chunk) {
        return chunk instanceof MediaChunk;
    }

    private boolean isPendingReset() {
        return this.pendingResetTime != -1L;
    }

    private long getRetryDelayMillis(long errorCount) {
        return Math.min((errorCount - 1L) * 1000L, 5000L);
    }

    protected final int usToMs(long timeUs) {
        return (int)(timeUs / 1000L);
    }

    private void notifyLoadStarted(final String formatId, final int trigger, final boolean isInitialization, final long mediaStartTimeUs, final long mediaEndTimeUs, final long totalBytes) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadStarted(ChunkSampleSource.this.eventSourceId, formatId, trigger, isInitialization, ChunkSampleSource.this.usToMs(mediaStartTimeUs), ChunkSampleSource.this.usToMs(mediaEndTimeUs), totalBytes);
                }
            });
        }
    }

    private void notifyLoadCompleted() {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadCompleted(ChunkSampleSource.this.eventSourceId);
                }
            });
        }
    }

    private void notifyLoadCanceled() {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onLoadCanceled(ChunkSampleSource.this.eventSourceId);
                }
            });
        }
    }

    private void notifyUpstreamError(final IOException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onUpstreamError(ChunkSampleSource.this.eventSourceId, e);
                }
            });
        }
    }

    private void notifyConsumptionError(final IOException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onConsumptionError(ChunkSampleSource.this.eventSourceId, e);
                }
            });
        }
    }

    private void notifyUpstreamDiscarded(final long mediaStartTimeUs, final long mediaEndTimeUs, final long totalBytes) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onUpstreamDiscarded(ChunkSampleSource.this.eventSourceId, ChunkSampleSource.this.usToMs(mediaStartTimeUs), ChunkSampleSource.this.usToMs(mediaEndTimeUs), totalBytes);
                }
            });
        }
    }

    private void notifyDownstreamFormatChanged(final String formatId, final int trigger, final long mediaTimeUs) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onDownstreamFormatChanged(ChunkSampleSource.this.eventSourceId, formatId, trigger, ChunkSampleSource.this.usToMs(mediaTimeUs));
                }
            });
        }
    }

    private void notifyDownstreamDiscarded(final long mediaStartTimeUs, final long mediaEndTimeUs, final long totalBytes) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    ChunkSampleSource.this.eventListener.onDownstreamDiscarded(ChunkSampleSource.this.eventSourceId, ChunkSampleSource.this.usToMs(mediaStartTimeUs), ChunkSampleSource.this.usToMs(mediaEndTimeUs), totalBytes);
                }
            });
        }
    }

    public static interface EventListener {
        public void onLoadStarted(int var1, String var2, int var3, boolean var4, int var5, int var6, long var7);

        public void onLoadCompleted(int var1);

        public void onLoadCanceled(int var1);

        public void onUpstreamDiscarded(int var1, int var2, int var3, long var4);

        public void onUpstreamError(int var1, IOException var2);

        public void onConsumptionError(int var1, IOException var2);

        public void onDownstreamDiscarded(int var1, int var2, int var3, long var4);

        public void onDownstreamFormatChanged(int var1, String var2, int var3, int var4);
    }
}

