/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.util.Assertions;

public abstract class TrackRenderer
implements ExoPlayer.ExoPlayerComponent {
    protected static final int STATE_RELEASED = -2;
    protected static final int STATE_IGNORE = -1;
    protected static final int STATE_UNPREPARED = 0;
    protected static final int STATE_PREPARED = 1;
    protected static final int STATE_ENABLED = 2;
    protected static final int STATE_STARTED = 3;
    public static final long UNKNOWN_TIME = -1L;
    public static final long MATCH_LONGEST = -2L;
    public static final long END_OF_TRACK = -3L;
    private int state;

    protected boolean isTimeSource() {
        return false;
    }

    protected final int getState() {
        return this.state;
    }

    final int prepare() throws ExoPlaybackException {
        Assertions.checkState(this.state == 0);
        this.state = this.doPrepare();
        Assertions.checkState(this.state == 0 || this.state == 1 || this.state == -1);
        return this.state;
    }

    protected abstract int doPrepare() throws ExoPlaybackException;

    final void enable(long timeUs, boolean joining) throws ExoPlaybackException {
        Assertions.checkState(this.state == 1);
        this.state = 2;
        this.onEnabled(timeUs, joining);
    }

    protected void onEnabled(long timeUs, boolean joining) throws ExoPlaybackException {
    }

    final void start() throws ExoPlaybackException {
        Assertions.checkState(this.state == 2);
        this.state = 3;
        this.onStarted();
    }

    protected void onStarted() throws ExoPlaybackException {
    }

    final void stop() throws ExoPlaybackException {
        Assertions.checkState(this.state == 3);
        this.state = 2;
        this.onStopped();
    }

    protected void onStopped() throws ExoPlaybackException {
    }

    final void disable() throws ExoPlaybackException {
        Assertions.checkState(this.state == 2);
        this.state = 1;
        this.onDisabled();
    }

    protected void onDisabled() throws ExoPlaybackException {
    }

    final void release() throws ExoPlaybackException {
        Assertions.checkState(this.state != 2 && this.state != 3 && this.state != -2);
        this.state = -2;
        this.onReleased();
    }

    protected void onReleased() throws ExoPlaybackException {
    }

    protected abstract boolean isEnded();

    protected abstract boolean isReady();

    protected abstract void doSomeWork(long var1) throws ExoPlaybackException;

    protected abstract long getDurationUs();

    protected abstract long getCurrentPositionUs();

    protected abstract long getBufferedPositionUs();

    protected abstract void seekTo(long var1) throws ExoPlaybackException;

    @Override
    public void handleMessage(int what, Object object) throws ExoPlaybackException {
    }
}

