/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.TraceUtil;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaCodecVideoTrackRenderer
extends MediaCodecTrackRenderer {
    private static final String TAG = "MediaCodecVideoTrackRenderer";
    private static final String KEY_CROP_LEFT = "crop-left";
    private static final String KEY_CROP_RIGHT = "crop-right";
    private static final String KEY_CROP_BOTTOM = "crop-bottom";
    private static final String KEY_CROP_TOP = "crop-top";
    public static final int MSG_SET_SURFACE = 1;
    private final EventListener eventListener;
    private final long allowedJoiningTimeUs;
    private final int videoScalingMode;
    private final int maxDroppedFrameCountToNotify;
    private Surface surface;
    private boolean drawnToSurface;
    private boolean renderedFirstFrame;
    private long joiningDeadlineUs;
    private long droppedFrameAccumulationStartTimeMs;
    private int droppedFrameCount;
    private int currentWidth;
    private int currentHeight;
    private int lastReportedWidth;
    private int lastReportedHeight;

    public MediaCodecVideoTrackRenderer(SampleSource source, int videoScalingMode) {
        this(source, null, true, videoScalingMode);
        Log.i((String)TAG, (String)"MediaCodecVideoTrackRenderer 1");
    }

    public MediaCodecVideoTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, int videoScalingMode) {
        this(source, drmSessionManager, playClearSamplesWithoutKeys, videoScalingMode, 0L);
        Log.i((String)TAG, (String)"MediaCodecVideoTrackRenderer 2");
    }

    public MediaCodecVideoTrackRenderer(SampleSource source, int videoScalingMode, long allowedJoiningTimeMs) {
        this(source, null, true, videoScalingMode, allowedJoiningTimeMs);
        Log.i((String)TAG, (String)"MediaCodecVideoTrackRenderer 3");
    }

    public MediaCodecVideoTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, int videoScalingMode, long allowedJoiningTimeMs) {
        this(source, drmSessionManager, playClearSamplesWithoutKeys, videoScalingMode, allowedJoiningTimeMs, null, null, -1);
        Log.i((String)TAG, (String)"MediaCodecVideoTrackRenderer 4");
    }

    public MediaCodecVideoTrackRenderer(SampleSource source, int videoScalingMode, long allowedJoiningTimeMs, Handler eventHandler, EventListener eventListener, int maxDroppedFrameCountToNotify) {
        this(source, null, true, videoScalingMode, allowedJoiningTimeMs, eventHandler, eventListener, maxDroppedFrameCountToNotify);
        Log.i((String)TAG, (String)"MediaCodecVideoTrackRenderer 5");
    }

    public MediaCodecVideoTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, int videoScalingMode, long allowedJoiningTimeMs, Handler eventHandler, EventListener eventListener, int maxDroppedFrameCountToNotify) {
        super(source, drmSessionManager, playClearSamplesWithoutKeys, eventHandler, eventListener);
        Log.i((String)TAG, (String)"MediaCodecVideoTrackRenderer 6");
        this.videoScalingMode = videoScalingMode;
        this.allowedJoiningTimeUs = allowedJoiningTimeMs * 1000L;
        this.eventListener = eventListener;
        this.maxDroppedFrameCountToNotify = maxDroppedFrameCountToNotify;
        this.joiningDeadlineUs = -1L;
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
    }

    @Override
    protected boolean handlesMimeType(String mimeType) {
        Log.i((String)TAG, (String)"handlesMimeType");
        return MimeTypes.isVideo(mimeType) && super.handlesMimeType(mimeType);
    }

    @Override
    protected void onEnabled(long startTimeUs, boolean joining) {
        Log.i((String)TAG, (String)"onEnabled");
        super.onEnabled(startTimeUs, joining);
        this.renderedFirstFrame = false;
        if (joining && this.allowedJoiningTimeUs > 0L) {
            this.joiningDeadlineUs = SystemClock.elapsedRealtime() * 1000L + this.allowedJoiningTimeUs;
        }
    }

    @Override
    protected void seekTo(long timeUs) throws ExoPlaybackException {
        Log.i((String)TAG, (String)"seekTo");
        super.seekTo(timeUs);
        this.renderedFirstFrame = false;
        this.joiningDeadlineUs = -1L;
    }

    @Override
    protected boolean isReady() {
        Log.i((String)TAG, (String)"isReady");
        if (super.isReady() && (this.renderedFirstFrame || !this.codecInitialized())) {
            this.joiningDeadlineUs = -1L;
            return true;
        }
        if (this.joiningDeadlineUs == -1L) {
            return false;
        }
        if (SystemClock.elapsedRealtime() * 1000L < this.joiningDeadlineUs) {
            return true;
        }
        this.joiningDeadlineUs = -1L;
        return false;
    }

    @Override
    protected void onStarted() {
        Log.i((String)TAG, (String)"onStarted");
        super.onStarted();
        this.droppedFrameCount = 0;
        this.droppedFrameAccumulationStartTimeMs = SystemClock.elapsedRealtime();
    }

    @Override
    protected void onStopped() {
        Log.i((String)TAG, (String)"onStopped");
        super.onStopped();
        this.joiningDeadlineUs = -1L;
        this.notifyAndResetDroppedFrameCount();
    }

    @Override
    public void onDisabled() {
        Log.i((String)TAG, (String)"onDisabled");
        super.onDisabled();
        this.currentWidth = -1;
        this.currentHeight = -1;
        this.lastReportedWidth = -1;
        this.lastReportedHeight = -1;
    }

    @Override
    public void handleMessage(int messageType, Object message) throws ExoPlaybackException {
        Log.i((String)TAG, (String)"handleMessage");
        if (messageType == 1) {
            this.setSurface((Surface)message);
        } else {
            super.handleMessage(messageType, message);
        }
    }

    private void setSurface(Surface surface) throws ExoPlaybackException {
        Log.i((String)TAG, (String)"setSurface");
        if (this.surface == surface) {
            return;
        }
        this.surface = surface;
        this.drawnToSurface = false;
        int state = this.getState();
        if (state == 2 || state == 3) {
            this.releaseCodec();
            this.maybeInitCodec();
        }
    }

    @Override
    protected boolean shouldInitCodec() {
        Log.i((String)TAG, (String)"shouldInitCodec");
        return super.shouldInitCodec() && this.surface != null;
    }

    @Override
    protected void configureCodec(MediaCodec codec, android.media.MediaFormat format, MediaCrypto crypto) {
        Log.i((String)TAG, (String)"configureCodec");
        codec.configure(format, this.surface, crypto, 0);
        codec.setVideoScalingMode(this.videoScalingMode);
    }

    @Override
    protected void onOutputFormatChanged(android.media.MediaFormat format) {
        Log.i((String)TAG, (String)"onOutputFormatChanged");
        boolean hasCrop = format.containsKey(KEY_CROP_RIGHT) && format.containsKey(KEY_CROP_LEFT) && format.containsKey(KEY_CROP_BOTTOM) && format.containsKey(KEY_CROP_TOP);
        this.currentWidth = hasCrop ? format.getInteger(KEY_CROP_RIGHT) - format.getInteger(KEY_CROP_LEFT) + 1 : format.getInteger("width");
        this.currentHeight = hasCrop ? format.getInteger(KEY_CROP_BOTTOM) - format.getInteger(KEY_CROP_TOP) + 1 : format.getInteger("height");
    }

    @Override
    protected boolean canReconfigureCodec(MediaCodec codec, boolean codecIsAdaptive, MediaFormat oldFormat, MediaFormat newFormat) {
        Log.i((String)TAG, (String)"canReconfigureCodec");
        return newFormat.mimeType.equals("video/avc") && oldFormat.mimeType.equals("video/avc") && codecIsAdaptive || oldFormat.width == newFormat.width && oldFormat.height == newFormat.height;
    }

    @Override
    protected boolean processOutputBuffer(long timeUs, MediaCodec codec, ByteBuffer buffer, MediaCodec.BufferInfo bufferInfo, int bufferIndex, boolean shouldSkip) {
        Log.i((String)TAG, (String)"processOutputBuffer");
        if (shouldSkip) {
            this.skipOutputBuffer(codec, bufferIndex);
            return true;
        }
        long earlyUs = bufferInfo.presentationTimeUs - timeUs;
        if (earlyUs < -30000L) {
            this.dropOutputBuffer(codec, bufferIndex);
            return true;
        }
        if (!this.renderedFirstFrame) {
            this.renderOutputBuffer(codec, bufferIndex);
            this.renderedFirstFrame = true;
            return true;
        }
        if (this.getState() == 3 && earlyUs < 30000L) {
            if (earlyUs > 11000L) {
                try {
                    Thread.sleep((earlyUs - 10000L) / 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.renderOutputBuffer(codec, bufferIndex);
            return true;
        }
        return false;
    }

    private void skipOutputBuffer(MediaCodec codec, int bufferIndex) {
        TraceUtil.beginSection("skipVideoBuffer");
        codec.releaseOutputBuffer(bufferIndex, false);
        TraceUtil.endSection();
        ++this.codecCounters.skippedOutputBufferCount;
    }

    private void dropOutputBuffer(MediaCodec codec, int bufferIndex) {
        Log.i((String)TAG, (String)"dropOutputBuffer");
        TraceUtil.beginSection("dropVideoBuffer");
        codec.releaseOutputBuffer(bufferIndex, false);
        TraceUtil.endSection();
        ++this.codecCounters.droppedOutputBufferCount;
        ++this.droppedFrameCount;
        if (this.droppedFrameCount == this.maxDroppedFrameCountToNotify) {
            this.notifyAndResetDroppedFrameCount();
        }
    }

    private void renderOutputBuffer(MediaCodec codec, int bufferIndex) {
        Log.i((String)TAG, (String)"renderOutputBuffer");
        if (this.lastReportedWidth != this.currentWidth || this.lastReportedHeight != this.currentHeight) {
            this.lastReportedWidth = this.currentWidth;
            this.lastReportedHeight = this.currentHeight;
            this.notifyVideoSizeChanged(this.currentWidth, this.currentHeight);
        }
        TraceUtil.beginSection("renderVideoBuffer");
        codec.releaseOutputBuffer(bufferIndex, true);
        TraceUtil.endSection();
        ++this.codecCounters.renderedOutputBufferCount;
        if (!this.drawnToSurface) {
            this.drawnToSurface = true;
            this.notifyDrawnToSurface(this.surface);
        }
    }

    private void notifyVideoSizeChanged(final int width, final int height) {
        Log.i((String)TAG, (String)"notifyVideoSizeChanged");
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecVideoTrackRenderer.this.eventListener.onVideoSizeChanged(width, height);
                }
            });
        }
    }

    private void notifyDrawnToSurface(final Surface surface) {
        Log.i((String)TAG, (String)"notifyDrawnToSurface");
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecVideoTrackRenderer.this.eventListener.onDrawnToSurface(surface);
                }
            });
        }
    }

    private void notifyAndResetDroppedFrameCount() {
        Log.i((String)TAG, (String)"notifyAndResetDroppedFrameCount");
        if (this.eventHandler != null && this.eventListener != null && this.droppedFrameCount > 0) {
            long now = SystemClock.elapsedRealtime();
            final int countToNotify = this.droppedFrameCount;
            final long elapsedToNotify = now - this.droppedFrameAccumulationStartTimeMs;
            this.droppedFrameCount = 0;
            this.droppedFrameAccumulationStartTimeMs = now;
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecVideoTrackRenderer.this.eventListener.onDroppedFrames(countToNotify, elapsedToNotify);
                }
            });
        }
    }

    public static interface EventListener
    extends MediaCodecTrackRenderer.EventListener {
        public void onDroppedFrames(int var1, long var2);

        public void onVideoSizeChanged(int var1, int var2);

        public void onDrawnToSurface(Surface var1);
    }
}

