/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.util.Pair;
import com.google.android.exoplayer.DecoderInfo;
import com.google.android.exoplayer.util.Util;
import java.util.HashMap;

@TargetApi(value=16)
public class MediaCodecUtil {
    private static final HashMap<String, Pair<MediaCodecInfo, MediaCodecInfo.CodecCapabilities>> codecs = new HashMap();

    public static DecoderInfo getDecoderInfo(String mimeType) {
        Pair<MediaCodecInfo, MediaCodecInfo.CodecCapabilities> info = MediaCodecUtil.getMediaCodecInfo(mimeType);
        if (info == null) {
            return null;
        }
        return new DecoderInfo(((MediaCodecInfo)info.first).getName(), MediaCodecUtil.isAdaptive((MediaCodecInfo.CodecCapabilities)info.second));
    }

    public static synchronized void warmCodecs(String[] mimeTypes) {
        int i = 0;
        while (i < mimeTypes.length) {
            MediaCodecUtil.getMediaCodecInfo(mimeTypes[i]);
            ++i;
        }
    }

    private static synchronized Pair<MediaCodecInfo, MediaCodecInfo.CodecCapabilities> getMediaCodecInfo(String mimeType) {
        Pair result = codecs.get(mimeType);
        if (result != null) {
            return result;
        }
        int numberOfCodecs = MediaCodecList.getCodecCount();
        int i = 0;
        while (i < numberOfCodecs) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            String codecName = info.getName();
            if (!info.isEncoder() && MediaCodecUtil.isOmxCodec(codecName)) {
                String[] supportedTypes = info.getSupportedTypes();
                int j = 0;
                while (j < supportedTypes.length) {
                    String supportedType = supportedTypes[j];
                    if (supportedType.equalsIgnoreCase(mimeType)) {
                        result = Pair.create((Object)info, (Object)info.getCapabilitiesForType(supportedType));
                        codecs.put(mimeType, (Pair<MediaCodecInfo, MediaCodecInfo.CodecCapabilities>)result);
                        return result;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private static boolean isOmxCodec(String name) {
        return name.startsWith("OMX.");
    }

    private static boolean isAdaptive(MediaCodecInfo.CodecCapabilities capabilities) {
        if (Util.SDK_INT >= 19) {
            return MediaCodecUtil.isAdaptiveV19(capabilities);
        }
        return false;
    }

    @TargetApi(value=19)
    private static boolean isAdaptiveV19(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.isFeatureSupported("adaptive-playback");
    }

    public static boolean isH264ProfileSupported(int profile, int level) {
        Pair<MediaCodecInfo, MediaCodecInfo.CodecCapabilities> info = MediaCodecUtil.getMediaCodecInfo("video/avc");
        if (info == null) {
            return false;
        }
        MediaCodecInfo.CodecCapabilities capabilities = (MediaCodecInfo.CodecCapabilities)info.second;
        int i = 0;
        while (i < capabilities.profileLevels.length) {
            MediaCodecInfo.CodecProfileLevel profileLevel = capabilities.profileLevels[i];
            if (profileLevel.profile == profile && profileLevel.level >= level) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int maxH264DecodableFrameSize() {
        Pair<MediaCodecInfo, MediaCodecInfo.CodecCapabilities> info = MediaCodecUtil.getMediaCodecInfo("video/avc");
        if (info == null) {
            return 0;
        }
        int maxH264DecodableFrameSize = 0;
        MediaCodecInfo.CodecCapabilities capabilities = (MediaCodecInfo.CodecCapabilities)info.second;
        int i = 0;
        while (i < capabilities.profileLevels.length) {
            MediaCodecInfo.CodecProfileLevel profileLevel = capabilities.profileLevels[i];
            maxH264DecodableFrameSize = Math.max(MediaCodecUtil.avcLevelToMaxFrameSize(profileLevel.level), maxH264DecodableFrameSize);
            ++i;
        }
        return maxH264DecodableFrameSize;
    }

    private static int avcLevelToMaxFrameSize(int avcLevel) {
        switch (avcLevel) {
            case 1: {
                return 25344;
            }
            case 2: {
                return 25344;
            }
            case 8: {
                return 101376;
            }
            case 16: {
                return 101376;
            }
            case 32: {
                return 101376;
            }
            case 64: {
                return 202752;
            }
            case 128: {
                return 414720;
            }
            case 256: {
                return 414720;
            }
            case 512: {
                return 921600;
            }
            case 1024: {
                return 0x140000;
            }
            case 2048: {
                return 0x200000;
            }
            case 4096: {
                return 0x200000;
            }
            case 8192: {
                return 0x220000;
            }
            case 16384: {
                return 5652480;
            }
            case 32768: {
                return 0x900000;
            }
        }
        return -1;
    }
}

