/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCrypto;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.exoplayer.CodecCounters;
import com.google.android.exoplayer.DecoderInfo;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.FormatHolder;
import com.google.android.exoplayer.MediaCodecUtil;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;

@TargetApi(value=16)
public abstract class MediaCodecTrackRenderer
extends TrackRenderer {
    private static final long MAX_CODEC_HOTSWAP_TIME_MS = 1000L;
    private static final int RECONFIGURATION_STATE_NONE = 0;
    private static final int RECONFIGURATION_STATE_WRITE_PENDING = 1;
    private static final int RECONFIGURATION_STATE_QUEUE_PENDING = 2;
    public final CodecCounters codecCounters;
    private final DrmSessionManager drmSessionManager;
    private final boolean playClearSamplesWithoutKeys;
    private final SampleSource source;
    private final SampleHolder sampleHolder;
    private final FormatHolder formatHolder;
    private final HashSet<Long> decodeOnlyPresentationTimestamps;
    private final MediaCodec.BufferInfo outputBufferInfo;
    private final EventListener eventListener;
    protected final Handler eventHandler;
    private MediaFormat format;
    private Map<UUID, byte[]> drmInitData;
    private MediaCodec codec;
    private boolean codecIsAdaptive;
    private ByteBuffer[] inputBuffers;
    private ByteBuffer[] outputBuffers;
    private long codecHotswapTimeMs;
    private int inputIndex;
    private int outputIndex;
    private boolean openedDrmSession;
    private boolean codecReconfigured;
    private int codecReconfigurationState;
    private int trackIndex;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private boolean waitingForKeys;
    private boolean waitingForFirstSyncFrame;
    private long currentPositionUs;
    private static final String TAG = "MediaCodecTrackRenderer";

    public MediaCodecTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, EventListener eventListener) {
        Assertions.checkState(Util.SDK_INT >= 16);
        this.source = source;
        this.drmSessionManager = drmSessionManager;
        this.playClearSamplesWithoutKeys = playClearSamplesWithoutKeys;
        this.eventHandler = eventHandler;
        this.eventListener = eventListener;
        this.codecCounters = new CodecCounters();
        this.sampleHolder = new SampleHolder(false);
        this.formatHolder = new FormatHolder();
        this.decodeOnlyPresentationTimestamps = new HashSet();
        this.outputBufferInfo = new MediaCodec.BufferInfo();
    }

    @Override
    protected int doPrepare() throws ExoPlaybackException {
        try {
            boolean sourcePrepared = this.source.prepare();
            if (!sourcePrepared) {
                return 0;
            }
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
        int i = 0;
        while (i < this.source.getTrackCount()) {
            if (this.handlesMimeType(this.source.getTrackInfo((int)i).mimeType)) {
                this.trackIndex = i;
                return 1;
            }
            ++i;
        }
        return -1;
    }

    protected boolean handlesMimeType(String mimeType) {
        return true;
    }

    @Override
    protected void onEnabled(long timeUs, boolean joining) {
        this.source.enable(this.trackIndex, timeUs);
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        this.waitingForKeys = false;
        this.currentPositionUs = timeUs;
    }

    protected void configureCodec(MediaCodec codec, android.media.MediaFormat x, MediaCrypto crypto) {
        codec.configure(x, null, crypto, 0);
    }

    protected final void maybeInitCodec() throws ExoPlaybackException {
        if (!this.shouldInitCodec()) {
            return;
        }
        String mimeType = this.format.mimeType;
        MediaCrypto mediaCrypto = null;
        boolean requiresSecureDecoder = false;
        if (this.drmInitData != null) {
            int drmSessionState;
            if (this.drmSessionManager == null) {
                throw new ExoPlaybackException("Media requires a DrmSessionManager");
            }
            if (!this.openedDrmSession) {
                this.drmSessionManager.open(this.drmInitData, mimeType);
                this.openedDrmSession = true;
            }
            if ((drmSessionState = this.drmSessionManager.getState()) == 0) {
                throw new ExoPlaybackException(this.drmSessionManager.getError());
            }
            if (drmSessionState == 3 || drmSessionState == 4) {
                mediaCrypto = this.drmSessionManager.getMediaCrypto();
                requiresSecureDecoder = this.drmSessionManager.requiresSecureDecoderComponent(mimeType);
            } else {
                return;
            }
        }
        DecoderInfo selectedDecoderInfo = MediaCodecUtil.getDecoderInfo(mimeType);
        String selectedDecoderName = selectedDecoderInfo.name;
        if (requiresSecureDecoder) {
            selectedDecoderName = MediaCodecTrackRenderer.getSecureDecoderName(selectedDecoderName);
        }
        this.codecIsAdaptive = selectedDecoderInfo.adaptive;
        try {
            this.codec = MediaCodec.createByCodecName((String)selectedDecoderName);
            this.configureCodec(this.codec, this.format.getFrameworkMediaFormatV16(), mediaCrypto);
            this.codec.start();
            this.inputBuffers = this.codec.getInputBuffers();
            this.outputBuffers = this.codec.getOutputBuffers();
        }
        catch (Exception e) {
            DecoderInitializationException exception = new DecoderInitializationException(selectedDecoderName, this.format, e);
            this.notifyDecoderInitializationError(exception);
            throw new ExoPlaybackException(exception);
        }
        this.codecHotswapTimeMs = this.getState() == 3 ? SystemClock.elapsedRealtime() : -1L;
        this.inputIndex = -1;
        this.outputIndex = -1;
        this.waitingForFirstSyncFrame = true;
        ++this.codecCounters.codecInitCount;
    }

    protected boolean shouldInitCodec() {
        return this.codec == null && this.format != null;
    }

    protected final boolean codecInitialized() {
        return this.codec != null;
    }

    protected final boolean haveFormat() {
        return this.format != null;
    }

    @Override
    protected void onDisabled() {
        this.releaseCodec();
        this.format = null;
        this.drmInitData = null;
        if (this.openedDrmSession) {
            this.drmSessionManager.close();
            this.openedDrmSession = false;
        }
        this.source.disable(this.trackIndex);
    }

    protected void releaseCodec() {
        if (this.codec != null) {
            this.codecHotswapTimeMs = -1L;
            this.inputIndex = -1;
            this.outputIndex = -1;
            this.decodeOnlyPresentationTimestamps.clear();
            this.inputBuffers = null;
            this.outputBuffers = null;
            this.codecReconfigured = false;
            this.codecIsAdaptive = false;
            this.codecReconfigurationState = 0;
            ++this.codecCounters.codecReleaseCount;
            try {
                this.codec.stop();
            }
            finally {
                try {
                    this.codec.release();
                }
                finally {
                    this.codec = null;
                }
            }
        }
    }

    @Override
    protected void onReleased() {
        this.source.release();
    }

    @Override
    protected long getCurrentPositionUs() {
        return this.currentPositionUs;
    }

    @Override
    protected long getDurationUs() {
        return this.source.getTrackInfo((int)this.trackIndex).durationUs;
    }

    @Override
    protected long getBufferedPositionUs() {
        long sourceBufferedPosition = this.source.getBufferedPositionUs();
        return sourceBufferedPosition == -1L || sourceBufferedPosition == -3L ? sourceBufferedPosition : Math.max(sourceBufferedPosition, this.getCurrentPositionUs());
    }

    @Override
    protected void seekTo(long timeUs) throws ExoPlaybackException {
        this.currentPositionUs = timeUs;
        this.source.seekToUs(timeUs);
        this.inputStreamEnded = false;
        this.outputStreamEnded = false;
        this.waitingForKeys = false;
    }

    @Override
    protected void onStarted() {
    }

    @Override
    protected void onStopped() {
    }

    @Override
    protected void doSomeWork(long timeUs) throws ExoPlaybackException {
        try {
            this.source.continueBuffering(timeUs);
            this.checkForDiscontinuity();
            if (this.format == null) {
                this.readFormat();
            } else if (this.codec == null && !this.shouldInitCodec() && this.getState() == 3) {
                this.discardSamples(timeUs);
            } else {
                if (this.codec == null && this.shouldInitCodec()) {
                    this.maybeInitCodec();
                }
                if (this.codec != null) {
                    while (this.drainOutputBuffer(timeUs)) {
                    }
                    while (this.feedInputBuffer()) {
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ExoPlaybackException(e);
        }
    }

    private void readFormat() throws IOException, ExoPlaybackException {
        int result = this.source.readData(this.trackIndex, this.currentPositionUs, this.formatHolder, this.sampleHolder, false);
        if (result == -4) {
            this.onInputFormatChanged(this.formatHolder);
        }
    }

    private void discardSamples(long timeUs) throws IOException, ExoPlaybackException {
        this.sampleHolder.data = null;
        int result = -3;
        while (result == -3 && this.currentPositionUs <= timeUs) {
            result = this.source.readData(this.trackIndex, this.currentPositionUs, this.formatHolder, this.sampleHolder, false);
            if (result == -3) {
                if (!this.sampleHolder.decodeOnly) {
                    this.currentPositionUs = this.sampleHolder.timeUs;
                }
                ++this.codecCounters.discardedSamplesCount;
                continue;
            }
            if (result != -4) continue;
            this.onInputFormatChanged(this.formatHolder);
        }
    }

    private void checkForDiscontinuity() throws IOException, ExoPlaybackException {
        if (this.codec == null) {
            return;
        }
        int result = this.source.readData(this.trackIndex, this.currentPositionUs, this.formatHolder, this.sampleHolder, true);
        if (result == -5) {
            this.flushCodec();
        }
    }

    private void flushCodec() throws ExoPlaybackException {
        this.codecHotswapTimeMs = -1L;
        this.inputIndex = -1;
        this.outputIndex = -1;
        this.decodeOnlyPresentationTimestamps.clear();
        if (Util.SDK_INT >= 18) {
            this.codec.flush();
        } else {
            this.releaseCodec();
            this.maybeInitCodec();
        }
        if (this.codecReconfigured && this.format != null) {
            this.codecReconfigurationState = 1;
        }
    }

    private boolean feedInputBuffer() throws IOException, ExoPlaybackException {
        int result;
        if (this.inputStreamEnded) {
            return false;
        }
        if (this.inputIndex < 0) {
            this.inputIndex = this.codec.dequeueInputBuffer(0L);
            if (this.inputIndex < 0) {
                return false;
            }
            this.sampleHolder.data = this.inputBuffers[this.inputIndex];
            this.sampleHolder.data.clear();
        }
        if (this.waitingForKeys) {
            result = -3;
        } else {
            if (this.codecReconfigurationState == 1) {
                int i = 0;
                while (i < this.format.initializationData.size()) {
                    byte[] data = this.format.initializationData.get(i);
                    this.sampleHolder.data.put(data);
                    ++i;
                }
                this.codecReconfigurationState = 2;
            }
            result = this.source.readData(this.trackIndex, this.currentPositionUs, this.formatHolder, this.sampleHolder, false);
        }
        if (result == -2) {
            ++this.codecCounters.inputBufferWaitingForSampleCount;
            return false;
        }
        if (result == -5) {
            this.flushCodec();
            return true;
        }
        if (result == -4) {
            if (this.codecReconfigurationState == 2) {
                this.sampleHolder.data.clear();
                this.codecReconfigurationState = 1;
            }
            this.onInputFormatChanged(this.formatHolder);
            return true;
        }
        if (result == -1) {
            if (this.codecReconfigurationState == 2) {
                this.sampleHolder.data.clear();
                this.codecReconfigurationState = 1;
            }
            this.inputStreamEnded = true;
            try {
                this.codec.queueInputBuffer(this.inputIndex, 0, 0, 0L, 4);
                this.inputIndex = -1;
                ++this.codecCounters.queuedEndOfStreamCount;
            }
            catch (MediaCodec.CryptoException e) {
                this.notifyCryptoError(e);
                throw new ExoPlaybackException(e);
            }
            return false;
        }
        if (this.waitingForFirstSyncFrame) {
            if ((this.sampleHolder.flags & 1) == 0) {
                this.sampleHolder.data.clear();
                if (this.codecReconfigurationState == 2) {
                    this.codecReconfigurationState = 1;
                }
                return true;
            }
            this.waitingForFirstSyncFrame = false;
        }
        boolean sampleEncrypted = (this.sampleHolder.flags & 2) != 0;
        this.waitingForKeys = this.shouldWaitForKeys(sampleEncrypted);
        if (this.waitingForKeys) {
            return false;
        }
        try {
            int bufferSize = this.sampleHolder.data.position();
            int adaptiveReconfigurationBytes = bufferSize - this.sampleHolder.size;
            long presentationTimeUs = this.sampleHolder.timeUs;
            if (this.sampleHolder.decodeOnly) {
                this.decodeOnlyPresentationTimestamps.add(presentationTimeUs);
            }
            if (sampleEncrypted) {
                MediaCodec.CryptoInfo cryptoInfo = MediaCodecTrackRenderer.getFrameworkCryptoInfo(this.sampleHolder, adaptiveReconfigurationBytes);
                this.codec.queueSecureInputBuffer(this.inputIndex, 0, cryptoInfo, presentationTimeUs, 0);
            } else {
                this.codec.queueInputBuffer(this.inputIndex, 0, bufferSize, presentationTimeUs, 0);
            }
            ++this.codecCounters.queuedInputBufferCount;
            if ((this.sampleHolder.flags & 1) != 0) {
                ++this.codecCounters.keyframeCount;
            }
            this.inputIndex = -1;
            this.codecReconfigurationState = 0;
        }
        catch (MediaCodec.CryptoException e) {
            this.notifyCryptoError(e);
            throw new ExoPlaybackException(e);
        }
        return true;
    }

    private static MediaCodec.CryptoInfo getFrameworkCryptoInfo(SampleHolder sampleHolder, int adaptiveReconfigurationBytes) {
        MediaCodec.CryptoInfo cryptoInfo = sampleHolder.cryptoInfo.getFrameworkCryptoInfoV16();
        if (adaptiveReconfigurationBytes == 0) {
            return cryptoInfo;
        }
        if (cryptoInfo.numBytesOfClearData == null) {
            cryptoInfo.numBytesOfClearData = new int[1];
        }
        cryptoInfo.numBytesOfClearData[0] = cryptoInfo.numBytesOfClearData[0] + adaptiveReconfigurationBytes;
        return cryptoInfo;
    }

    private boolean shouldWaitForKeys(boolean sampleEncrypted) throws ExoPlaybackException {
        if (!this.openedDrmSession) {
            return false;
        }
        int drmManagerState = this.drmSessionManager.getState();
        if (drmManagerState == 0) {
            throw new ExoPlaybackException(this.drmSessionManager.getError());
        }
        return drmManagerState != 4 && (sampleEncrypted || !this.playClearSamplesWithoutKeys);
    }

    private void onInputFormatChanged(FormatHolder formatHolder) throws ExoPlaybackException {
        MediaFormat oldFormat = this.format;
        this.format = formatHolder.format;
        this.drmInitData = formatHolder.drmInitData;
        if (this.codec != null && this.canReconfigureCodec(this.codec, this.codecIsAdaptive, oldFormat, this.format)) {
            this.codecReconfigured = true;
            this.codecReconfigurationState = 1;
        } else {
            this.releaseCodec();
            this.maybeInitCodec();
        }
    }

    protected void onOutputFormatChanged(android.media.MediaFormat format) {
    }

    protected boolean canReconfigureCodec(MediaCodec codec, boolean codecIsAdaptive, MediaFormat oldFormat, MediaFormat newFormat) {
        return false;
    }

    @Override
    protected boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    protected boolean isReady() {
        return this.format != null && !this.waitingForKeys && (this.codec == null && !this.shouldInitCodec() || this.outputIndex >= 0 || this.inputIndex < 0 || this.isWithinHotswapPeriod());
    }

    private boolean isWithinHotswapPeriod() {
        return SystemClock.elapsedRealtime() < this.codecHotswapTimeMs + 1000L;
    }

    private boolean drainOutputBuffer(long timeUs) throws ExoPlaybackException {
        if (this.outputStreamEnded) {
            return false;
        }
        if (this.outputIndex < 0) {
            this.outputIndex = this.codec.dequeueOutputBuffer(this.outputBufferInfo, 0L);
        }
        if (this.outputIndex == -2) {
            Log.d((String)TAG, (String)"call onOutputFormatChanged");
            this.onOutputFormatChanged(this.codec.getOutputFormat());
            ++this.codecCounters.outputFormatChangedCount;
            return true;
        }
        if (this.outputIndex == -3) {
            this.outputBuffers = this.codec.getOutputBuffers();
            ++this.codecCounters.outputBuffersChangedCount;
            return true;
        }
        if (this.outputIndex < 0) {
            return false;
        }
        if ((this.outputBufferInfo.flags & 4) != 0) {
            this.outputStreamEnded = true;
            return false;
        }
        boolean decodeOnly = this.decodeOnlyPresentationTimestamps.contains(this.outputBufferInfo.presentationTimeUs);
        if (this.processOutputBuffer(timeUs, this.codec, this.outputBuffers[this.outputIndex], this.outputBufferInfo, this.outputIndex, decodeOnly)) {
            if (decodeOnly) {
                this.decodeOnlyPresentationTimestamps.remove(this.outputBufferInfo.presentationTimeUs);
            } else {
                this.currentPositionUs = this.outputBufferInfo.presentationTimeUs;
            }
            this.outputIndex = -1;
            return true;
        }
        return false;
    }

    protected abstract boolean processOutputBuffer(long var1, MediaCodec var3, ByteBuffer var4, MediaCodec.BufferInfo var5, int var6, boolean var7) throws ExoPlaybackException;

    private static String getSecureDecoderName(String rawDecoderName) {
        return String.valueOf(rawDecoderName) + ".secure";
    }

    private void notifyDecoderInitializationError(final DecoderInitializationException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecTrackRenderer.this.eventListener.onDecoderInitializationError(e);
                }
            });
        }
    }

    private void notifyCryptoError(final MediaCodec.CryptoException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecTrackRenderer.this.eventListener.onCryptoError(e);
                }
            });
        }
    }

    public static class DecoderInitializationException
    extends Exception {
        public final String decoderName;

        public DecoderInitializationException(String decoderName, MediaFormat mediaFormat, Exception cause) {
            super("Decoder init failed: " + decoderName + ", " + mediaFormat, cause);
            this.decoderName = decoderName;
        }
    }

    public static interface EventListener {
        public void onDecoderInitializationError(DecoderInitializationException var1);

        public void onCryptoError(MediaCodec.CryptoException var1);
    }
}

