/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.TargetApi;
import android.media.AudioTimestamp;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.ConditionVariable;
import android.os.Handler;
import android.util.Log;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.MediaCodecTrackRenderer;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.drm.DrmSessionManager;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.MimeTypes;
import com.google.android.exoplayer.util.Util;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

@TargetApi(value=16)
public class MediaCodecAudioTrackRenderer
extends MediaCodecTrackRenderer {
    public static final int MSG_SET_VOLUME = 1;
    public static final float DEFAULT_MIN_BUFFER_MULTIPLICATION_FACTOR = 4.0f;
    private static final String TAG = "MediaCodecAudioTrackRenderer";
    private static final long MICROS_PER_SECOND = 1000000L;
    private static final int MAX_PLAYHEAD_OFFSET_COUNT = 10;
    private static final int MIN_PLAYHEAD_OFFSET_SAMPLE_INTERVAL_US = 30000;
    private static final int MIN_TIMESTAMP_SAMPLE_INTERVAL_US = 500000;
    private static final int START_NOT_SET = 0;
    private static final int START_IN_SYNC = 1;
    private static final int START_NEED_SYNC = 2;
    private final EventListener eventListener;
    private final ConditionVariable audioTrackReleasingConditionVariable;
    private final AudioTimestampCompat audioTimestampCompat;
    private final long[] playheadOffsets;
    private final float minBufferMultiplicationFactor;
    private int nextPlayheadOffsetIndex;
    private int playheadOffsetCount;
    private long smoothedPlayheadOffsetUs;
    private long lastPlayheadSampleTimeUs;
    private boolean audioTimestampSet;
    private long lastTimestampSampleTimeUs;
    private long lastRawPlaybackHeadPosition;
    private long rawPlaybackHeadWrapCount;
    private int sampleRate;
    private int frameSize;
    private int channelConfig;
    private int minBufferSize;
    private int bufferSize;
    private AudioTrack audioTrack;
    private Method audioTrackGetLatencyMethod;
    private int audioSessionId;
    private long submittedBytes;
    private int audioTrackStartMediaTimeState;
    private long audioTrackStartMediaTimeUs;
    private long audioTrackResumeSystemTimeUs;
    private long lastReportedCurrentPositionUs;
    private long audioTrackLatencyUs;
    private float volume;
    private byte[] temporaryBuffer;
    private int temporaryBufferOffset;
    private int temporaryBufferSize;

    public MediaCodecAudioTrackRenderer(SampleSource source) {
        this(source, null, true);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys) {
        this(source, drmSessionManager, playClearSamplesWithoutKeys, null, null);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, Handler eventHandler, EventListener eventListener) {
        this(source, null, true, eventHandler, eventListener);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, EventListener eventListener) {
        this(source, drmSessionManager, playClearSamplesWithoutKeys, 4.0f, eventHandler, eventListener);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, float minBufferMultiplicationFactor, Handler eventHandler, EventListener eventListener) {
        this(source, null, true, minBufferMultiplicationFactor, eventHandler, eventListener);
    }

    public MediaCodecAudioTrackRenderer(SampleSource source, DrmSessionManager drmSessionManager, boolean playClearSamplesWithoutKeys, float minBufferMultiplicationFactor, Handler eventHandler, EventListener eventListener) {
        super(source, drmSessionManager, playClearSamplesWithoutKeys, eventHandler, eventListener);
        Assertions.checkState(minBufferMultiplicationFactor >= 1.0f);
        this.minBufferMultiplicationFactor = minBufferMultiplicationFactor;
        this.eventListener = eventListener;
        this.audioTrackReleasingConditionVariable = new ConditionVariable(true);
        this.audioTimestampCompat = Util.SDK_INT >= 19 ? new AudioTimestampCompatV19() : new NoopAudioTimestampCompat();
        if (Util.SDK_INT >= 18) {
            try {
                this.audioTrackGetLatencyMethod = AudioTrack.class.getMethod("getLatency", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.playheadOffsets = new long[10];
        this.volume = 1.0f;
    }

    @Override
    protected boolean isTimeSource() {
        return true;
    }

    @Override
    protected boolean handlesMimeType(String mimeType) {
        return MimeTypes.isAudio(mimeType) && super.handlesMimeType(mimeType);
    }

    @Override
    protected void onEnabled(long timeUs, boolean joining) {
        super.onEnabled(timeUs, joining);
        this.lastReportedCurrentPositionUs = 0L;
    }

    @Override
    protected void doSomeWork(long timeUs) throws ExoPlaybackException {
        super.doSomeWork(timeUs);
        this.maybeSampleSyncParams();
    }

    @Override
    protected void onOutputFormatChanged(MediaFormat format) {
        int channelConfig;
        this.releaseAudioTrack();
        this.sampleRate = format.getInteger("sample-rate");
        int channelCount = format.getInteger("channel-count");
        switch (channelCount) {
            case 1: {
                channelConfig = 4;
                break;
            }
            case 2: {
                channelConfig = 12;
                break;
            }
            case 6: {
                channelConfig = 252;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported channel count: " + channelCount);
            }
        }
        this.channelConfig = channelConfig;
        this.minBufferSize = AudioTrack.getMinBufferSize((int)this.sampleRate, (int)channelConfig, (int)2);
        this.bufferSize = (int)(this.minBufferMultiplicationFactor * (float)this.minBufferSize);
        this.frameSize = 2 * channelCount;
    }

    private void initAudioTrack() throws ExoPlaybackException {
        this.audioTrackReleasingConditionVariable.block();
        if (this.audioSessionId == 0) {
            this.audioTrack = new AudioTrack(3, this.sampleRate, this.channelConfig, 2, this.bufferSize, 1);
            this.checkAudioTrackInitialized();
            this.audioSessionId = this.audioTrack.getAudioSessionId();
            this.onAudioSessionId(this.audioSessionId);
        } else {
            this.audioTrack = new AudioTrack(3, this.sampleRate, this.channelConfig, 2, this.bufferSize, 1, this.audioSessionId);
            this.checkAudioTrackInitialized();
        }
        this.audioTrack.setStereoVolume(this.volume, this.volume);
        if (this.getState() == 3) {
            this.audioTrackResumeSystemTimeUs = System.nanoTime() / 1000L;
            this.audioTrack.play();
        }
    }

    private void checkAudioTrackInitialized() throws ExoPlaybackException {
        int audioTrackState;
        block6: {
            audioTrackState = this.audioTrack.getState();
            if (audioTrackState == 1) {
                return;
            }
            try {
                try {
                    this.audioTrack.release();
                }
                catch (Exception exception) {
                    this.audioTrack = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.audioTrack = null;
                throw throwable;
            }
            this.audioTrack = null;
        }
        AudioTrackInitializationException exception = new AudioTrackInitializationException(audioTrackState, this.sampleRate, this.channelConfig, this.bufferSize);
        this.notifyAudioTrackInitializationError(exception);
        throw new ExoPlaybackException(exception);
    }

    protected void onAudioSessionId(int audioSessionId) {
    }

    private void releaseAudioTrack() {
        if (this.audioTrack != null) {
            this.submittedBytes = 0L;
            this.temporaryBufferSize = 0;
            this.lastRawPlaybackHeadPosition = 0L;
            this.rawPlaybackHeadWrapCount = 0L;
            this.audioTrackStartMediaTimeUs = 0L;
            this.audioTrackStartMediaTimeState = 0;
            this.resetSyncParams();
            int playState = this.audioTrack.getPlayState();
            if (playState == 3) {
                this.audioTrack.pause();
            }
            final AudioTrack toRelease = this.audioTrack;
            this.audioTrack = null;
            this.audioTrackReleasingConditionVariable.close();
            new Thread(){

                @Override
                public void run() {
                    try {
                        toRelease.release();
                    }
                    finally {
                        MediaCodecAudioTrackRenderer.this.audioTrackReleasingConditionVariable.open();
                    }
                }
            }.start();
        }
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        if (this.audioTrack != null) {
            this.audioTrackResumeSystemTimeUs = System.nanoTime() / 1000L;
            this.audioTrack.play();
        }
    }

    @Override
    protected void onStopped() {
        super.onStopped();
        if (this.audioTrack != null) {
            this.resetSyncParams();
            this.audioTrack.pause();
        }
    }

    @Override
    protected boolean isEnded() {
        return super.isEnded() && (this.getPendingFrameCount() == 0 || this.submittedBytes < (long)this.minBufferSize);
    }

    @Override
    protected boolean isReady() {
        return this.getPendingFrameCount() > 0;
    }

    @Override
    protected long getCurrentPositionUs() {
        long currentPositionUs;
        long systemClockUs = System.nanoTime() / 1000L;
        if (this.audioTrack == null || this.audioTrackStartMediaTimeState == 0) {
            currentPositionUs = super.getCurrentPositionUs();
        } else if (this.audioTimestampSet) {
            long presentationDiff = systemClockUs - this.audioTimestampCompat.getNanoTime() / 1000L;
            long framesDiff = this.durationUsToFrames(presentationDiff);
            long currentFramePosition = this.audioTimestampCompat.getFramePosition() + framesDiff;
            currentPositionUs = this.framesToDurationUs(currentFramePosition) + this.audioTrackStartMediaTimeUs;
        } else {
            currentPositionUs = this.playheadOffsetCount == 0 ? this.getPlayheadPositionUs() + this.audioTrackStartMediaTimeUs : systemClockUs + this.smoothedPlayheadOffsetUs + this.audioTrackStartMediaTimeUs;
            if (!this.isEnded()) {
                currentPositionUs -= this.audioTrackLatencyUs;
            }
        }
        this.lastReportedCurrentPositionUs = currentPositionUs = Math.max(this.lastReportedCurrentPositionUs, currentPositionUs);
        return currentPositionUs;
    }

    private void maybeSampleSyncParams() {
        if (this.audioTrack == null || this.audioTrackStartMediaTimeState == 0 || this.getState() != 3) {
            return;
        }
        long playheadPositionUs = this.getPlayheadPositionUs();
        if (playheadPositionUs == 0L) {
            return;
        }
        long systemClockUs = System.nanoTime() / 1000L;
        if (systemClockUs - this.lastPlayheadSampleTimeUs >= 30000L) {
            this.playheadOffsets[this.nextPlayheadOffsetIndex] = playheadPositionUs - systemClockUs;
            this.nextPlayheadOffsetIndex = (this.nextPlayheadOffsetIndex + 1) % 10;
            if (this.playheadOffsetCount < 10) {
                ++this.playheadOffsetCount;
            }
            this.lastPlayheadSampleTimeUs = systemClockUs;
            this.smoothedPlayheadOffsetUs = 0L;
            int i = 0;
            while (i < this.playheadOffsetCount) {
                this.smoothedPlayheadOffsetUs += this.playheadOffsets[i] / (long)this.playheadOffsetCount;
                ++i;
            }
        }
        if (systemClockUs - this.lastTimestampSampleTimeUs >= 500000L) {
            this.audioTimestampSet = this.audioTimestampCompat.initTimestamp(this.audioTrack);
            if (this.audioTimestampSet && this.audioTimestampCompat.getNanoTime() / 1000L < this.audioTrackResumeSystemTimeUs) {
                this.audioTimestampSet = false;
            }
            if (this.audioTrackGetLatencyMethod != null) {
                try {
                    this.audioTrackLatencyUs = (long)((Integer)this.audioTrackGetLatencyMethod.invoke((Object)this.audioTrack, null)).intValue() * 1000L - this.framesToDurationUs(this.bufferSize / this.frameSize);
                    this.audioTrackLatencyUs = Math.max(this.audioTrackLatencyUs, 0L);
                }
                catch (Exception e) {
                    this.audioTrackGetLatencyMethod = null;
                }
            }
            this.lastTimestampSampleTimeUs = systemClockUs;
        }
    }

    private void resetSyncParams() {
        this.smoothedPlayheadOffsetUs = 0L;
        this.playheadOffsetCount = 0;
        this.nextPlayheadOffsetIndex = 0;
        this.lastPlayheadSampleTimeUs = 0L;
        this.audioTimestampSet = false;
        this.lastTimestampSampleTimeUs = 0L;
    }

    private long getPlayheadPositionUs() {
        return this.framesToDurationUs(this.getPlaybackHeadPosition());
    }

    private long framesToDurationUs(long frameCount) {
        return frameCount * 1000000L / (long)this.sampleRate;
    }

    private long durationUsToFrames(long durationUs) {
        return durationUs * (long)this.sampleRate / 1000000L;
    }

    @Override
    protected void onDisabled() {
        super.onDisabled();
        this.releaseAudioTrack();
        this.audioSessionId = 0;
    }

    @Override
    protected void seekTo(long timeUs) throws ExoPlaybackException {
        super.seekTo(timeUs);
        this.releaseAudioTrack();
        this.lastReportedCurrentPositionUs = 0L;
    }

    @Override
    protected boolean processOutputBuffer(long timeUs, MediaCodec codec, ByteBuffer buffer, MediaCodec.BufferInfo bufferInfo, int bufferIndex, boolean shouldSkip) throws ExoPlaybackException {
        int bytesPending;
        int bytesToWrite;
        if (shouldSkip) {
            codec.releaseOutputBuffer(bufferIndex, false);
            ++this.codecCounters.skippedOutputBufferCount;
            if (this.audioTrackStartMediaTimeState == 1) {
                this.audioTrackStartMediaTimeState = 2;
            }
            return true;
        }
        if (this.temporaryBufferSize == 0) {
            long bufferStartTime = bufferInfo.presentationTimeUs - this.framesToDurationUs(bufferInfo.size / this.frameSize);
            if (this.audioTrackStartMediaTimeState == 0) {
                this.audioTrackStartMediaTimeUs = Math.max(0L, bufferStartTime);
                this.audioTrackStartMediaTimeState = 1;
            } else {
                long expectedBufferStartTime = this.audioTrackStartMediaTimeUs + this.framesToDurationUs(this.submittedBytes / (long)this.frameSize);
                if (this.audioTrackStartMediaTimeState == 1 && Math.abs(expectedBufferStartTime - bufferStartTime) > 200000L) {
                    Log.e((String)TAG, (String)("Discontinuity detected [expected " + expectedBufferStartTime + ", got " + bufferStartTime + "]"));
                    this.audioTrackStartMediaTimeState = 2;
                }
                if (this.audioTrackStartMediaTimeState == 2) {
                    this.audioTrackStartMediaTimeUs += bufferStartTime - expectedBufferStartTime;
                    this.lastReportedCurrentPositionUs = 0L;
                }
            }
            if (this.temporaryBuffer == null || this.temporaryBuffer.length < bufferInfo.size) {
                this.temporaryBuffer = new byte[bufferInfo.size];
            }
            buffer.position(bufferInfo.offset);
            buffer.get(this.temporaryBuffer, 0, bufferInfo.size);
            this.temporaryBufferOffset = 0;
            this.temporaryBufferSize = bufferInfo.size;
        }
        if (this.audioTrack == null) {
            this.initAudioTrack();
        }
        if ((bytesToWrite = this.bufferSize - (bytesPending = (int)(this.submittedBytes - this.getPlaybackHeadPosition() * (long)this.frameSize))) > 0) {
            bytesToWrite = Math.min(this.temporaryBufferSize, bytesToWrite);
            this.audioTrack.write(this.temporaryBuffer, this.temporaryBufferOffset, bytesToWrite);
            this.temporaryBufferOffset += bytesToWrite;
            this.temporaryBufferSize -= bytesToWrite;
            this.submittedBytes += (long)bytesToWrite;
            if (this.temporaryBufferSize == 0) {
                codec.releaseOutputBuffer(bufferIndex, false);
                ++this.codecCounters.renderedOutputBufferCount;
                return true;
            }
        }
        return false;
    }

    private long getPlaybackHeadPosition() {
        long rawPlaybackHeadPosition = 0xFFFFFFFFL & (long)this.audioTrack.getPlaybackHeadPosition();
        if (this.lastRawPlaybackHeadPosition > rawPlaybackHeadPosition) {
            ++this.rawPlaybackHeadWrapCount;
        }
        this.lastRawPlaybackHeadPosition = rawPlaybackHeadPosition;
        return rawPlaybackHeadPosition + (this.rawPlaybackHeadWrapCount << 32);
    }

    private int getPendingFrameCount() {
        return this.audioTrack == null ? 0 : (int)(this.submittedBytes / (long)this.frameSize - this.getPlaybackHeadPosition());
    }

    @Override
    public void handleMessage(int messageType, Object message) throws ExoPlaybackException {
        if (messageType == 1) {
            this.setVolume(((Float)message).floatValue());
        } else {
            super.handleMessage(messageType, message);
        }
    }

    private void setVolume(float volume) {
        this.volume = volume;
        if (this.audioTrack != null) {
            this.audioTrack.setStereoVolume(volume, volume);
        }
    }

    private void notifyAudioTrackInitializationError(final AudioTrackInitializationException e) {
        if (this.eventHandler != null && this.eventListener != null) {
            this.eventHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaCodecAudioTrackRenderer.this.eventListener.onAudioTrackInitializationError(e);
                }
            });
        }
    }

    private static interface AudioTimestampCompat {
        public boolean initTimestamp(AudioTrack var1);

        public long getNanoTime();

        public long getFramePosition();
    }

    @TargetApi(value=19)
    private static final class AudioTimestampCompatV19
    implements AudioTimestampCompat {
        private final AudioTimestamp audioTimestamp = new AudioTimestamp();

        @Override
        public boolean initTimestamp(AudioTrack audioTrack) {
            return audioTrack.getTimestamp(this.audioTimestamp);
        }

        @Override
        public long getNanoTime() {
            return this.audioTimestamp.nanoTime;
        }

        @Override
        public long getFramePosition() {
            return this.audioTimestamp.framePosition;
        }
    }

    public static class AudioTrackInitializationException
    extends Exception {
        public final int audioTrackState;

        public AudioTrackInitializationException(int audioTrackState, int sampleRate, int channelConfig, int bufferSize) {
            super("AudioTrack init failed: " + audioTrackState + ", Config(" + sampleRate + ", " + channelConfig + ", " + bufferSize + ")");
            this.audioTrackState = audioTrackState;
        }
    }

    public static interface EventListener
    extends MediaCodecTrackRenderer.EventListener {
        public void onAudioTrackInitializationError(AudioTrackInitializationException var1);
    }

    private static final class NoopAudioTimestampCompat
    implements AudioTimestampCompat {
        private NoopAudioTimestampCompat() {
        }

        @Override
        public boolean initTimestamp(AudioTrack audioTrack) {
            return false;
        }

        @Override
        public long getNanoTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getFramePosition() {
            throw new UnsupportedOperationException();
        }
    }
}

