/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.os.SystemClock;

class MediaClock {
    private boolean started;
    private long timeUs;
    private long deltaUs;

    MediaClock() {
    }

    public void start() {
        if (!this.started) {
            this.started = true;
            this.deltaUs = this.elapsedRealtimeMinus(this.timeUs);
        }
    }

    public void stop() {
        if (this.started) {
            this.timeUs = this.elapsedRealtimeMinus(this.deltaUs);
            this.started = false;
        }
    }

    public void setTimeUs(long timeUs) {
        this.timeUs = timeUs;
        this.deltaUs = this.elapsedRealtimeMinus(timeUs);
    }

    public long getTimeUs() {
        return this.started ? this.elapsedRealtimeMinus(this.deltaUs) : this.timeUs;
    }

    private long elapsedRealtimeMinus(long microSeconds) {
        return SystemClock.elapsedRealtime() * 1000L - microSeconds;
    }
}

