/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.MediaClock;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.TraceUtil;
import java.util.ArrayList;
import java.util.List;

final class ExoPlayerImplInternal
implements Handler.Callback {
    private static final String TAG = "ExoPlayerImplInternal";
    public static final int MSG_STATE_CHANGED = 1;
    public static final int MSG_SET_PLAY_WHEN_READY_ACK = 2;
    public static final int MSG_ERROR = 3;
    private static final int MSG_PREPARE = 1;
    private static final int MSG_INCREMENTAL_PREPARE = 2;
    private static final int MSG_SET_PLAY_WHEN_READY = 3;
    private static final int MSG_STOP = 4;
    private static final int MSG_RELEASE = 5;
    private static final int MSG_SEEK_TO = 6;
    private static final int MSG_DO_SOME_WORK = 7;
    private static final int MSG_SET_RENDERER_ENABLED = 8;
    private static final int MSG_CUSTOM = 9;
    private static final int PREPARE_INTERVAL_MS = 10;
    private static final int RENDERING_INTERVAL_MS = 10;
    private static final int IDLE_INTERVAL_MS = 1000;
    private final Handler handler;
    private final HandlerThread internalPlayerThread;
    private final Handler eventHandler;
    private final MediaClock mediaClock;
    private final boolean[] rendererEnabledFlags;
    private final long minBufferUs;
    private final long minRebufferUs;
    private final List<TrackRenderer> enabledRenderers;
    private TrackRenderer[] renderers;
    private TrackRenderer timeSourceTrackRenderer;
    private boolean released;
    private boolean playWhenReady;
    private boolean rebuffering;
    private int state;
    private int customMessagesSent = 0;
    private int customMessagesProcessed = 0;
    private volatile long durationUs;
    private volatile long positionUs;
    private volatile long bufferedPositionUs;

    @SuppressLint(value={"HandlerLeak"})
    public ExoPlayerImplInternal(Handler eventHandler, boolean playWhenReady, boolean[] rendererEnabledFlags, int minBufferMs, int minRebufferMs) {
        Log.w((String)TAG, (String)"create ExoPlayerImplInternal");
        this.eventHandler = eventHandler;
        this.playWhenReady = playWhenReady;
        this.rendererEnabledFlags = new boolean[rendererEnabledFlags.length];
        this.minBufferUs = (long)minBufferMs * 1000L;
        this.minRebufferUs = (long)minRebufferMs * 1000L;
        int i = 0;
        while (i < rendererEnabledFlags.length) {
            this.rendererEnabledFlags[i] = rendererEnabledFlags[i];
            ++i;
        }
        this.state = 1;
        this.durationUs = -1L;
        this.bufferedPositionUs = -1L;
        this.mediaClock = new MediaClock();
        this.enabledRenderers = new ArrayList<TrackRenderer>(rendererEnabledFlags.length);
        this.internalPlayerThread = new HandlerThread(String.valueOf(this.getClass().getSimpleName()) + ":Handler"){

            public void run() {
                Process.setThreadPriority((int)-16);
                super.run();
            }
        };
        this.internalPlayerThread.start();
        this.handler = new Handler(this.internalPlayerThread.getLooper(), (Handler.Callback)this);
    }

    public Looper getPlaybackLooper() {
        Log.w((String)TAG, (String)"getPlaybackLooper");
        return this.internalPlayerThread.getLooper();
    }

    public int getCurrentPosition() {
        Log.w((String)TAG, (String)"getCurrentPosition");
        return (int)(this.positionUs / 1000L);
    }

    public int getBufferedPosition() {
        Log.w((String)TAG, (String)"getBufferedPosition");
        return this.bufferedPositionUs == -1L ? -1 : (int)(this.bufferedPositionUs / 1000L);
    }

    public int getDuration() {
        Log.w((String)TAG, (String)"getDuration");
        return this.durationUs == -1L ? -1 : (int)(this.durationUs / 1000L);
    }

    public void prepare(TrackRenderer ... renderers) {
        Log.w((String)TAG, (String)"prepare");
        this.handler.obtainMessage(1, (Object)renderers).sendToTarget();
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        Log.w((String)TAG, (String)"setPlayWhenReady");
        this.handler.obtainMessage(3, playWhenReady ? 1 : 0, 0).sendToTarget();
    }

    public void seekTo(int positionMs) {
        Log.w((String)TAG, (String)"seekTo");
        this.handler.obtainMessage(6, positionMs, 0).sendToTarget();
    }

    public void stop() {
        Log.w((String)TAG, (String)"stop");
        this.handler.sendEmptyMessage(4);
    }

    public void setRendererEnabled(int index, boolean enabled) {
        Log.w((String)TAG, (String)"setRendererEnabled");
        this.handler.obtainMessage(8, index, enabled ? 1 : 0).sendToTarget();
    }

    public void sendMessage(ExoPlayer.ExoPlayerComponent target, int messageType, Object message) {
        Log.w((String)TAG, (String)"sendMessage");
        ++this.customMessagesSent;
        this.handler.obtainMessage(9, messageType, 0, (Object)Pair.create((Object)target, (Object)message)).sendToTarget();
    }

    public synchronized void blockingSendMessage(ExoPlayer.ExoPlayerComponent target, int messageType, Object message) {
        Log.w((String)TAG, (String)"blockingSendMessage");
        int messageNumber = this.customMessagesSent++;
        this.handler.obtainMessage(9, messageType, 0, (Object)Pair.create((Object)target, (Object)message)).sendToTarget();
        while (this.customMessagesProcessed <= messageNumber) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void release() {
        Log.w((String)TAG, (String)"release");
        if (!this.released) {
            this.handler.sendEmptyMessage(5);
            while (!this.released) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.internalPlayerThread.quit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleMessage(Message msg) {
        Log.w((String)TAG, (String)("handleMessage msg = " + msg.what));
        try {
            switch (msg.what) {
                case 1: {
                    this.prepareInternal((TrackRenderer[])msg.obj);
                    return true;
                }
                case 2: {
                    this.incrementalPrepareInternal();
                    return true;
                }
                case 3: {
                    this.setPlayWhenReadyInternal(msg.arg1 != 0);
                    return true;
                }
                case 7: {
                    this.doSomeWork();
                    return true;
                }
                case 6: {
                    this.seekToInternal(msg.arg1);
                    return true;
                }
                case 4: {
                    this.stopInternal();
                    return true;
                }
                case 5: {
                    this.releaseInternal();
                    return true;
                }
                case 9: {
                    this.sendMessageInternal(msg.arg1, msg.obj);
                    return true;
                }
                case 8: {
                    this.setRendererEnabledInternal(msg.arg1, msg.arg2 != 0);
                    return true;
                }
            }
            return false;
        }
        catch (ExoPlaybackException e) {
            Log.e((String)TAG, (String)"Internal track renderer error.", (Throwable)e);
            this.eventHandler.obtainMessage(3, (Object)e).sendToTarget();
            this.stopInternal();
            return true;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Internal runtime error.", (Throwable)e);
            this.eventHandler.obtainMessage(3, (Object)new ExoPlaybackException(e)).sendToTarget();
            this.stopInternal();
            return true;
        }
    }

    private void setState(int state) {
        Log.w((String)TAG, (String)"setState");
        if (this.state != state) {
            this.state = state;
            this.eventHandler.obtainMessage(1, state, 0).sendToTarget();
        }
    }

    private void prepareInternal(TrackRenderer[] renderers) {
        Log.w((String)TAG, (String)"prepareInternal");
        this.rebuffering = false;
        this.renderers = renderers;
        int i = 0;
        while (i < renderers.length) {
            if (renderers[i].isTimeSource()) {
                Assertions.checkState(this.timeSourceTrackRenderer == null);
                this.timeSourceTrackRenderer = renderers[i];
            }
            ++i;
        }
        this.setState(2);
        this.handler.sendEmptyMessage(2);
    }

    private void incrementalPrepareInternal() throws ExoPlaybackException {
        Log.w((String)TAG, (String)"incrementalPrepareInternal");
        long operationStartTimeMs = SystemClock.elapsedRealtime();
        boolean prepared = true;
        int i = 0;
        while (i < this.renderers.length) {
            int state;
            if (this.renderers[i].getState() == 0 && (state = this.renderers[i].prepare()) == 0) {
                prepared = false;
            }
            ++i;
        }
        if (!prepared) {
            this.scheduleNextOperation(2, operationStartTimeMs, 10L);
            return;
        }
        long durationUs = 0L;
        boolean isEnded = true;
        boolean allRenderersReadyOrEnded = true;
        int i2 = 0;
        while (i2 < this.renderers.length) {
            TrackRenderer renderer = this.renderers[i2];
            if (this.rendererEnabledFlags[i2] && renderer.getState() == 1) {
                renderer.enable(this.positionUs, false);
                this.enabledRenderers.add(renderer);
                isEnded = isEnded && renderer.isEnded();
                boolean bl = allRenderersReadyOrEnded = allRenderersReadyOrEnded && this.rendererReadyOrEnded(renderer);
                if (durationUs != -1L) {
                    long trackDurationUs = renderer.getDurationUs();
                    if (trackDurationUs == -1L) {
                        durationUs = -1L;
                    } else if (trackDurationUs != -2L) {
                        durationUs = Math.max(durationUs, trackDurationUs);
                    }
                }
            }
            ++i2;
        }
        this.durationUs = durationUs;
        if (isEnded) {
            this.setState(5);
        } else {
            this.setState(allRenderersReadyOrEnded ? 4 : 3);
            if (this.playWhenReady && this.state == 4) {
                this.startRenderers();
            }
        }
        this.handler.sendEmptyMessage(7);
    }

    private boolean rendererReadyOrEnded(TrackRenderer renderer) {
        long minBufferDurationUs;
        Log.w((String)TAG, (String)"rendererReadyOrEnded");
        if (renderer.isEnded()) {
            return true;
        }
        if (!renderer.isReady()) {
            return false;
        }
        if (this.state == 4) {
            return true;
        }
        long rendererDurationUs = renderer.getDurationUs();
        long rendererBufferedPositionUs = renderer.getBufferedPositionUs();
        long l = minBufferDurationUs = this.rebuffering ? this.minRebufferUs : this.minBufferUs;
        return minBufferDurationUs <= 0L || rendererBufferedPositionUs == -1L || rendererBufferedPositionUs == -3L || rendererBufferedPositionUs >= this.positionUs + minBufferDurationUs || rendererDurationUs != -1L && rendererDurationUs != -2L && rendererBufferedPositionUs >= rendererDurationUs;
    }

    private void setPlayWhenReadyInternal(boolean playWhenReady) throws ExoPlaybackException {
        Log.w((String)TAG, (String)"setPlayWhenReadyInternal");
        try {
            this.rebuffering = false;
            this.playWhenReady = playWhenReady;
            if (!playWhenReady) {
                this.stopRenderers();
                this.updatePositionUs();
            } else if (this.state == 4) {
                this.startRenderers();
                this.handler.sendEmptyMessage(7);
            } else if (this.state == 3) {
                this.handler.sendEmptyMessage(7);
            }
        }
        finally {
            this.eventHandler.obtainMessage(2).sendToTarget();
        }
    }

    private void startRenderers() throws ExoPlaybackException {
        Log.w((String)TAG, (String)"startRenderers");
        this.rebuffering = false;
        this.mediaClock.start();
        int i = 0;
        while (i < this.enabledRenderers.size()) {
            this.enabledRenderers.get(i).start();
            ++i;
        }
    }

    private void stopRenderers() throws ExoPlaybackException {
        Log.w((String)TAG, (String)"stopRenderers");
        this.mediaClock.stop();
        int i = 0;
        while (i < this.enabledRenderers.size()) {
            this.ensureStopped(this.enabledRenderers.get(i));
            ++i;
        }
    }

    private void updatePositionUs() {
        Log.w((String)TAG, (String)"updatePositionUs");
        this.positionUs = this.timeSourceTrackRenderer != null && this.enabledRenderers.contains(this.timeSourceTrackRenderer) ? this.timeSourceTrackRenderer.getCurrentPositionUs() : this.mediaClock.getTimeUs();
    }

    private void doSomeWork() throws ExoPlaybackException {
        Log.w((String)TAG, (String)"doSomeWork");
        TraceUtil.beginSection("doSomeWork");
        long operationStartTimeMs = SystemClock.elapsedRealtime();
        long bufferedPositionUs = this.durationUs != -1L ? this.durationUs : Long.MAX_VALUE;
        boolean isEnded = true;
        boolean allRenderersReadyOrEnded = true;
        this.updatePositionUs();
        int i = 0;
        while (i < this.enabledRenderers.size()) {
            TrackRenderer renderer = this.enabledRenderers.get(i);
            renderer.doSomeWork(this.positionUs);
            isEnded = isEnded && renderer.isEnded();
            boolean bl = allRenderersReadyOrEnded = allRenderersReadyOrEnded && this.rendererReadyOrEnded(renderer);
            if (bufferedPositionUs != -1L) {
                long rendererDurationUs = renderer.getDurationUs();
                long rendererBufferedPositionUs = renderer.getBufferedPositionUs();
                if (rendererBufferedPositionUs == -1L) {
                    bufferedPositionUs = -1L;
                } else if (rendererBufferedPositionUs != -3L && (rendererDurationUs == -1L || rendererDurationUs == -2L || rendererBufferedPositionUs < rendererDurationUs)) {
                    bufferedPositionUs = Math.min(bufferedPositionUs, rendererBufferedPositionUs);
                }
            }
            ++i;
        }
        this.bufferedPositionUs = bufferedPositionUs;
        if (isEnded) {
            this.setState(5);
            this.stopRenderers();
        } else if (this.state == 3 && allRenderersReadyOrEnded) {
            this.setState(4);
            if (this.playWhenReady) {
                this.startRenderers();
            }
        } else if (this.state == 4 && !allRenderersReadyOrEnded) {
            this.rebuffering = this.playWhenReady;
            this.setState(3);
            this.stopRenderers();
        }
        this.handler.removeMessages(7);
        if (this.playWhenReady && this.state == 4 || this.state == 3) {
            this.scheduleNextOperation(7, operationStartTimeMs, 10L);
        } else if (!this.enabledRenderers.isEmpty()) {
            this.scheduleNextOperation(7, operationStartTimeMs, 1000L);
        }
        TraceUtil.endSection();
    }

    private void scheduleNextOperation(int operationType, long thisOperationStartTimeMs, long intervalMs) {
        Log.w((String)TAG, (String)"scheduleNextOperation");
        long nextOperationStartTimeMs = thisOperationStartTimeMs + intervalMs;
        long nextOperationDelayMs = nextOperationStartTimeMs - SystemClock.elapsedRealtime();
        if (nextOperationDelayMs <= 0L) {
            this.handler.sendEmptyMessage(operationType);
        } else {
            this.handler.sendEmptyMessageDelayed(operationType, nextOperationDelayMs);
        }
    }

    private void seekToInternal(int positionMs) throws ExoPlaybackException {
        Log.w((String)TAG, (String)"seekToInternal");
        this.rebuffering = false;
        this.positionUs = (long)positionMs * 1000L;
        this.mediaClock.stop();
        this.mediaClock.setTimeUs(this.positionUs);
        if (this.state == 1 || this.state == 2) {
            return;
        }
        int i = 0;
        while (i < this.enabledRenderers.size()) {
            TrackRenderer renderer = this.enabledRenderers.get(i);
            this.ensureStopped(renderer);
            renderer.seekTo(this.positionUs);
            ++i;
        }
        this.setState(3);
        this.handler.sendEmptyMessage(7);
    }

    private void stopInternal() {
        Log.w((String)TAG, (String)"stopInternal");
        this.rebuffering = false;
        this.resetInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInternal() {
        Log.w((String)TAG, (String)"releaseInternal");
        this.resetInternal();
        ExoPlayerImplInternal exoPlayerImplInternal = this;
        synchronized (exoPlayerImplInternal) {
            this.released = true;
            this.notifyAll();
        }
    }

    private void resetInternal() {
        Log.w((String)TAG, (String)"resetInternal");
        this.handler.removeMessages(7);
        this.handler.removeMessages(2);
        this.mediaClock.stop();
        if (this.renderers == null) {
            return;
        }
        int i = 0;
        while (i < this.renderers.length) {
            try {
                TrackRenderer renderer = this.renderers[i];
                this.ensureStopped(renderer);
                if (renderer.getState() == 2) {
                    renderer.disable();
                }
                renderer.release();
            }
            catch (ExoPlaybackException e) {
                Log.e((String)TAG, (String)"Stop failed.", (Throwable)e);
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"Stop failed.", (Throwable)e);
            }
            ++i;
        }
        this.renderers = null;
        this.timeSourceTrackRenderer = null;
        this.enabledRenderers.clear();
        this.setState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void sendMessageInternal(int what, Object obj) throws ExoPlaybackException {
        Log.w((String)TAG, (String)"sendMessageInternal");
        try {
            Pair targetAndMessage = (Pair)obj;
            ((ExoPlayer.ExoPlayerComponent)targetAndMessage.first).handleMessage(what, targetAndMessage.second);
        }
        catch (Throwable throwable) {
            ExoPlayerImplInternal exoPlayerImplInternal = this;
            synchronized (exoPlayerImplInternal) {
                ++this.customMessagesProcessed;
                this.notifyAll();
            }
            throw throwable;
        }
        ExoPlayerImplInternal exoPlayerImplInternal = this;
        synchronized (exoPlayerImplInternal) {
            ++this.customMessagesProcessed;
            this.notifyAll();
        }
        if (this.state != 1) {
            this.handler.sendEmptyMessage(7);
        }
    }

    private void setRendererEnabledInternal(int index, boolean enabled) throws ExoPlaybackException {
        Log.w((String)TAG, (String)"setRendererEnabledInternal");
        if (this.rendererEnabledFlags[index] == enabled) {
            return;
        }
        this.rendererEnabledFlags[index] = enabled;
        if (this.state == 1 || this.state == 2) {
            return;
        }
        TrackRenderer renderer = this.renderers[index];
        int rendererState = renderer.getState();
        if (rendererState != 1 && rendererState != 2 && rendererState != 3) {
            return;
        }
        if (enabled) {
            boolean playing = this.playWhenReady && this.state == 4;
            renderer.enable(this.positionUs, playing);
            this.enabledRenderers.add(renderer);
            if (playing) {
                renderer.start();
            }
            this.handler.sendEmptyMessage(7);
        } else {
            if (renderer == this.timeSourceTrackRenderer) {
                this.mediaClock.setTimeUs(renderer.getCurrentPositionUs());
            }
            this.ensureStopped(renderer);
            this.enabledRenderers.remove(renderer);
            renderer.disable();
        }
    }

    private void ensureStopped(TrackRenderer renderer) throws ExoPlaybackException {
        Log.w((String)TAG, (String)"ensureStopped");
        if (renderer.getState() == 3) {
            renderer.stop();
        }
    }
}

