/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.ExoPlayerImplInternal;
import com.google.android.exoplayer.TrackRenderer;
import java.util.concurrent.CopyOnWriteArraySet;

final class ExoPlayerImpl
implements ExoPlayer {
    private static final String TAG = "ExoPlayerImpl";
    private final Handler eventHandler;
    private final ExoPlayerImplInternal internalPlayer;
    private final CopyOnWriteArraySet<ExoPlayer.Listener> listeners;
    private final boolean[] rendererEnabledFlags;
    private boolean playWhenReady;
    private int playbackState;
    private int pendingPlayWhenReadyAcks;

    @SuppressLint(value={"HandlerLeak"})
    public ExoPlayerImpl(int rendererCount, int minBufferMs, int minRebufferMs) {
        Log.i((String)TAG, (String)"Test Init 1.0.11");
        this.playbackState = 1;
        this.listeners = new CopyOnWriteArraySet();
        this.rendererEnabledFlags = new boolean[rendererCount];
        int i = 0;
        while (i < this.rendererEnabledFlags.length) {
            this.rendererEnabledFlags[i] = true;
            ++i;
        }
        this.eventHandler = new Handler(){

            public void handleMessage(Message msg) {
                ExoPlayerImpl.this.handleEvent(msg);
            }
        };
        this.internalPlayer = new ExoPlayerImplInternal(this.eventHandler, this.playWhenReady, this.rendererEnabledFlags, minBufferMs, minRebufferMs);
    }

    @Override
    public Looper getPlaybackLooper() {
        Log.i((String)TAG, (String)"getPlaybackLooper");
        return this.internalPlayer.getPlaybackLooper();
    }

    @Override
    public void addListener(ExoPlayer.Listener listener) {
        Log.i((String)TAG, (String)"addListener");
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ExoPlayer.Listener listener) {
        Log.i((String)TAG, (String)"removeListener");
        this.listeners.remove(listener);
    }

    @Override
    public int getPlaybackState() {
        Log.i((String)TAG, (String)"getPlaybackState");
        return this.playbackState;
    }

    @Override
    public void prepare(TrackRenderer ... renderers) {
        Log.i((String)TAG, (String)"prepare");
        this.internalPlayer.prepare(renderers);
    }

    @Override
    public void setRendererEnabled(int index, boolean enabled) {
        Log.i((String)TAG, (String)"setRendererEnabled");
        if (this.rendererEnabledFlags[index] != enabled) {
            this.rendererEnabledFlags[index] = enabled;
            this.internalPlayer.setRendererEnabled(index, enabled);
        }
    }

    @Override
    public boolean getRendererEnabled(int index) {
        Log.i((String)TAG, (String)"getRendererEnabled");
        return this.rendererEnabledFlags[index];
    }

    @Override
    public void setPlayWhenReady(boolean playWhenReady) {
        Log.i((String)TAG, (String)"setPlayWhenReady");
        if (this.playWhenReady != playWhenReady) {
            this.playWhenReady = playWhenReady;
            ++this.pendingPlayWhenReadyAcks;
            this.internalPlayer.setPlayWhenReady(playWhenReady);
            for (ExoPlayer.Listener listener : this.listeners) {
                listener.onPlayerStateChanged(playWhenReady, this.playbackState);
            }
        }
    }

    @Override
    public boolean getPlayWhenReady() {
        Log.i((String)TAG, (String)"getPlayWhenReady");
        return this.playWhenReady;
    }

    @Override
    public boolean isPlayWhenReadyCommitted() {
        Log.i((String)TAG, (String)"isPlayWhenReadyCommitted");
        return this.pendingPlayWhenReadyAcks == 0;
    }

    @Override
    public void seekTo(int positionMs) {
        Log.i((String)TAG, (String)"seekTo");
        this.internalPlayer.seekTo(positionMs);
    }

    @Override
    public void stop() {
        Log.i((String)TAG, (String)"stop");
        this.internalPlayer.stop();
    }

    @Override
    public void release() {
        Log.i((String)TAG, (String)"release");
        this.internalPlayer.release();
        this.eventHandler.removeCallbacksAndMessages(null);
    }

    @Override
    public void sendMessage(ExoPlayer.ExoPlayerComponent target, int messageType, Object message) {
        Log.i((String)TAG, (String)"sendMessage");
        this.internalPlayer.sendMessage(target, messageType, message);
    }

    @Override
    public void blockingSendMessage(ExoPlayer.ExoPlayerComponent target, int messageType, Object message) {
        this.internalPlayer.blockingSendMessage(target, messageType, message);
    }

    @Override
    public int getDuration() {
        Log.i((String)TAG, (String)"getDuration");
        return this.internalPlayer.getDuration();
    }

    @Override
    public int getCurrentPosition() {
        Log.i((String)TAG, (String)"getCurrentPosition");
        return this.internalPlayer.getCurrentPosition();
    }

    @Override
    public int getBufferedPosition() {
        Log.i((String)TAG, (String)"getBufferedPosition");
        return this.internalPlayer.getBufferedPosition();
    }

    @Override
    public int getBufferedPercentage() {
        Log.i((String)TAG, (String)"getBufferedPercentage");
        int bufferedPosition = this.getBufferedPosition();
        int duration = this.getDuration();
        return bufferedPosition == -1 || duration == -1 ? 0 : (duration == 0 ? 100 : bufferedPosition * 100 / duration);
    }

    void handleEvent(Message msg) {
        Log.i((String)TAG, (String)("handleEvent what = " + msg.what));
        switch (msg.what) {
            case 1: {
                this.playbackState = msg.arg1;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayerStateChanged(this.playWhenReady, this.playbackState);
                }
                break;
            }
            case 2: {
                --this.pendingPlayWhenReadyAcks;
                if (this.pendingPlayWhenReadyAcks != 0) break;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayWhenReadyCommitted();
                }
                break;
            }
            case 3: {
                ExoPlaybackException exception = (ExoPlaybackException)msg.obj;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayerError(exception);
                }
                break;
            }
        }
    }
}

