/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef LIVE_SESSION_H_

#define LIVE_SESSION_H_

#include <media/stagefright/foundation/AHandler.h>

#ifdef SEC_MMFW_HLS
//Added for Res-Parsing
#include <sys/types.h>
#include <media/stagefright/foundation/ABase.h>
#include <utils/Vector.h>
#include <utils/RefBase.h>
#endif

namespace android {

struct ABuffer;
struct DataSource;
struct LiveDataSource;
struct M3UParser;
struct NuHTTPDataSource;

#ifdef SEC_MMFW_HLS
struct ABitReader;
#endif

struct LiveSession : public AHandler {
    enum Flags {
        // Don't log any URLs.
        kFlagIncognito = 1,
    };
    LiveSession(uint32_t flags = 0);

    sp<DataSource> getDataSource();

    void connect(const char *url);
    void disconnect();

    // Blocks until seek is complete.
    void seekTo(int64_t timeUs);

    status_t getDuration(int64_t *durationUs);
    bool isSeekable();
    char* getAudioType();	

protected:
    virtual ~LiveSession();

    virtual void onMessageReceived(const sp<AMessage> &msg);

private:
    enum {
        kMaxNumQueuedFragments = 8, //3,
        kMaxNumRetries         = 5 //5,
    };

    static const int64_t kMaxPlaylistAgeUs;

    enum {
        kWhatConnect        = 'conn',
        kWhatDisconnect     = 'disc',
        kWhatMonitorQueue   = 'moni',
        kWhatSeek           = 'seek',
    };

    struct BandwidthItem {
        AString mURI;
        unsigned long mBandwidth;
#ifdef SEC_MMFW_HLS
		size_t mBandwidthWidth;//Info. Bandwidth Width
		size_t mBandwidthHeight;//Info. Bandwidth height
#endif
    };

    uint32_t mFlags;

    sp<LiveDataSource> mDataSource;

    sp<NuHTTPDataSource> mHTTPDataSource;

    AString mMasterURL;
    Vector<BandwidthItem> mBandwidthItems;

    KeyedVector<AString, sp<ABuffer> > mAESKeyForURI;

    ssize_t mPrevBandwidthIndex;
    int64_t mLastPlaylistFetchTimeUs;
#ifdef SEC_MMFW_HLS
    int32_t mLastMediaFileDurationSec; /* WONPIA initial reload delay */
    sp<M3UParser> mPlaylistWithoutSub; /* WONPIA */
	sp<M3UParser>	mDummyplaylist;
    Mutex mLockReloadDelay;	/* WONPIA initial reload delay */
	int64_t mDownloadPlaylistStartTime;//Playlist update start time
	int64_t mDownloadPlaylistEndTime;//TS file download end time
	int64_t mDownloadDeltaTime;//mDownloadPlaylistStartTime - mDownloadPlaylistEndTime
	bool mDownloadMasterlist;//flag for Master Index file
	size_t mPrevIndex;//Previous Bandwidth
	size_t mIndex;//Current Bandwidth
	int32_t	mPlayTime;//the total TS Play time During mDownloadPlaylistStartTime - mDownloadPlaylistEndTime
	int mPrevHeight;//Previous Contents Height
	int	mPrevWidth;//Previous Contents Width
	bool mResolution;//Resolution flag
	bool mSingleBandwidth;
	bool mAudioOnly;
    int32_t mNumRetriesTSconnection;
    int32_t mNumRetriesTScontent;
	bool mCheckFirstBW; //select the first Bandwidth to support High BW
	int mNumOfContinuousBW; //the number of continuous Bandwidth to change the high BW
	char audioType[50];
#endif
    sp<M3UParser> mPlaylist;
    int32_t mSeqNumber;
    int64_t mSeekTimeUs;
    int32_t mNumRetries;

    Mutex mLock;
    Condition mCondition;
    int64_t mDurationUs;
    bool mSeekDone;
    bool mDisconnectPending;

    int32_t mMonitorQueueGeneration;

    void onConnect(const sp<AMessage> &msg);
    void onDisconnect();
    void onDownloadNext();
    void onMonitorQueue();
    void onSeek(const sp<AMessage> &msg);

    status_t fetchFile(const char *url, sp<ABuffer> *out);
    sp<M3UParser> fetchPlaylist(const char *url);
    size_t getBandwidthIndex();

    status_t decryptBuffer(
            size_t playlistIndex, const sp<ABuffer> &buffer);

    void postMonitorQueue(int64_t delayUs = 0);

    static int SortByBandwidth(const BandwidthItem *, const BandwidthItem *);

#ifdef SEC_MMFW_HLS
    bool parseResolution(const sp<ABuffer> &buffer, int* findwidth, int* findheight);
    void getPayloadData(ABitReader *br, uint8_t* payload, unsigned *payloadSize);
    void getProgramID(ABitReader *br, unsigned *selProgram);
    void getStreamID(ABitReader *br, unsigned *selStream);	
#endif	
    DISALLOW_EVIL_CONSTRUCTORS(LiveSession);
};

}  // namespace android

#endif  // LIVE_SESSION_H_
