/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml;

import com.android.tools.layoutlib.create.OverrideMethod;
import org.xml.sax.Attributes;

abstract class ExpatAttributes
implements Attributes {
    private static final String CDATA = "CDATA";

    ExpatAttributes() {
    }

    @Override
    public abstract int getLength();

    abstract long getParserPointer();

    public abstract long getPointer();

    @Override
    public String getURI(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return ExpatAttributes.getURI(this.getParserPointer(), this.getPointer(), index);
    }

    @Override
    public String getLocalName(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getLocalName(this.getParserPointer(), this.getPointer(), index);
    }

    @Override
    public String getQName(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getQName(this.getParserPointer(), this.getPointer(), index);
    }

    @Override
    public String getType(int index) {
        return index < 0 || index >= this.getLength() ? null : CDATA;
    }

    @Override
    public String getValue(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getValueByIndex(this.getPointer(), index);
    }

    @Override
    public int getIndex(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        if (localName == null) {
            throw new NullPointerException("localName == null");
        }
        long pointer = this.getPointer();
        if (pointer == 0L) {
            return -1;
        }
        return ExpatAttributes.getIndex(pointer, uri, localName);
    }

    @Override
    public int getIndex(String qName) {
        if (qName == null) {
            throw new NullPointerException("qName == null");
        }
        long pointer = this.getPointer();
        if (pointer == 0L) {
            return -1;
        }
        return ExpatAttributes.getIndexForQName(pointer, qName);
    }

    @Override
    public String getType(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        if (localName == null) {
            throw new NullPointerException("localName == null");
        }
        return this.getIndex(uri, localName) == -1 ? null : CDATA;
    }

    @Override
    public String getType(String qName) {
        return this.getIndex(qName) == -1 ? null : CDATA;
    }

    @Override
    public String getValue(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        if (localName == null) {
            throw new NullPointerException("localName == null");
        }
        long pointer = this.getPointer();
        if (pointer == 0L) {
            return null;
        }
        return ExpatAttributes.getValue(pointer, uri, localName);
    }

    @Override
    public String getValue(String qName) {
        if (qName == null) {
            throw new NullPointerException("qName == null");
        }
        long pointer = this.getPointer();
        if (pointer == 0L) {
            return null;
        }
        return ExpatAttributes.getValueForQName(pointer, qName);
    }

    private static String getURI(long l, long l2, int n) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getURI(JJI)Ljava/lang/String;", true, null);
    }

    private static String getLocalName(long l, long l2, int n) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getLocalName(JJI)Ljava/lang/String;", true, null);
    }

    private static String getQName(long l, long l2, int n) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getQName(JJI)Ljava/lang/String;", true, null);
    }

    private static String getValueByIndex(long l, int n) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getValueByIndex(JI)Ljava/lang/String;", true, null);
    }

    private static int getIndex(long l, String string2, String string3) {
        return OverrideMethod.invokeI("org.apache.harmony.xml.ExpatAttributes#getIndex(JLjava/lang/String;Ljava/lang/String;)I", true, null);
    }

    private static int getIndexForQName(long l, String string2) {
        return OverrideMethod.invokeI("org.apache.harmony.xml.ExpatAttributes#getIndexForQName(JLjava/lang/String;)I", true, null);
    }

    private static String getValue(long l, String string2, String string3) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getValue(JLjava/lang/String;Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    private static String getValueForQName(long l, String string2) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getValueForQName(JLjava/lang/String;)Ljava/lang/String;", true, null);
    }

    protected void freeAttributes(long l) {
        OverrideMethod.invokeV("org.apache.harmony.xml.ExpatAttributes#freeAttributes(J)V", true, this);
    }
}

