/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x509.GeneralName;

public class GeneralNames {
    private List<GeneralName> generalNames;
    private byte[] encoding;
    public static final ASN1Type ASN1 = new ASN1SequenceOf(GeneralName.ASN1){

        @Override
        public Object getDecodedObject(BerInputStream in) {
            return new GeneralNames((List)in.content, in.getEncoded());
        }

        public Collection getValues(Object object) {
            GeneralNames gns = (GeneralNames)object;
            return gns.generalNames;
        }
    };

    public GeneralNames() {
        this.generalNames = new ArrayList<GeneralName>();
    }

    public GeneralNames(List<GeneralName> generalNames) {
        this.generalNames = generalNames;
    }

    private GeneralNames(List<GeneralName> generalNames, byte[] encoding) {
        this.generalNames = generalNames;
        this.encoding = encoding;
    }

    public List<GeneralName> getNames() {
        if (this.generalNames == null || this.generalNames.size() == 0) {
            return null;
        }
        return new ArrayList<GeneralName>(this.generalNames);
    }

    public Collection<List<?>> getPairsList() {
        ArrayList result = new ArrayList();
        if (this.generalNames == null) {
            return result;
        }
        for (GeneralName generalName : this.generalNames) {
            List<Object> genNameList;
            try {
                genNameList = generalName.getAsList();
            }
            catch (IllegalArgumentException ignored) {
                continue;
            }
            result.add(genNameList);
        }
        return result;
    }

    public void addName(GeneralName name) {
        this.encoding = null;
        if (this.generalNames == null) {
            this.generalNames = new ArrayList<GeneralName>();
        }
        this.generalNames.add(name);
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    public void dumpValue(StringBuilder sb, String prefix) {
        if (this.generalNames == null) {
            return;
        }
        for (GeneralName generalName : this.generalNames) {
            sb.append(prefix);
            sb.append(generalName);
            sb.append('\n');
        }
    }
}

