/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.harmony.security.utils.ObjectIdentifier;
import org.apache.harmony.security.x501.AttributeTypeAndValue;
import org.apache.harmony.security.x501.AttributeValue;

public class DNParser {
    private int pos;
    private int beg;
    private int end;
    private final char[] chars;
    private boolean hasQE;
    private byte[] encoded;

    public DNParser(String dn) throws IOException {
        this.chars = dn.toCharArray();
    }

    private String nextAT() throws IOException {
        this.hasQE = false;
        while (this.pos < this.chars.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (this.pos == this.chars.length) {
            return null;
        }
        this.beg = this.pos++;
        while (this.pos < this.chars.length && this.chars[this.pos] != '=' && this.chars[this.pos] != ' ') {
            ++this.pos;
        }
        if (this.pos >= this.chars.length) {
            throw new IOException("Invalid distinguished name string");
        }
        this.end = this.pos;
        if (this.chars[this.pos] == ' ') {
            while (this.pos < this.chars.length && this.chars[this.pos] != '=' && this.chars[this.pos] == ' ') {
                ++this.pos;
            }
            if (this.chars[this.pos] != '=' || this.pos == this.chars.length) {
                throw new IOException("Invalid distinguished name string");
            }
        }
        ++this.pos;
        while (this.pos < this.chars.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        if (!(this.end - this.beg <= 4 || this.chars[this.beg + 3] != '.' || this.chars[this.beg] != 'O' && this.chars[this.beg] != 'o' || this.chars[this.beg + 1] != 'I' && this.chars[this.beg + 1] != 'i' || this.chars[this.beg + 2] != 'D' && this.chars[this.beg + 2] != 'd')) {
            this.beg += 4;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private String quotedAV() throws IOException {
        ++this.pos;
        this.end = this.beg = this.pos;
        while (true) {
            if (this.pos == this.chars.length) {
                throw new IOException("Invalid distinguished name string");
            }
            if (this.chars[this.pos] == '\"') {
                ++this.pos;
                break;
            }
            this.chars[this.end] = this.chars[this.pos] == '\\' ? this.getEscaped() : this.chars[this.pos];
            ++this.pos;
            ++this.end;
        }
        while (this.pos < this.chars.length && this.chars[this.pos] == ' ') {
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private String hexAV() throws IOException {
        if (this.pos + 4 >= this.chars.length) {
            throw new IOException("Invalid distinguished name string");
        }
        this.beg = this.pos++;
        while (true) {
            if (this.pos == this.chars.length || this.chars[this.pos] == '+' || this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                this.end = this.pos;
                break;
            }
            if (this.chars[this.pos] == ' ') {
                this.end = this.pos++;
                while (this.pos < this.chars.length && this.chars[this.pos] == ' ') {
                    ++this.pos;
                }
                break;
            }
            if (this.chars[this.pos] >= 'A' && this.chars[this.pos] <= 'F') {
                int n = this.pos;
                this.chars[n] = (char)(this.chars[n] + 32);
            }
            ++this.pos;
        }
        int hexLen = this.end - this.beg;
        if (hexLen < 5 || (hexLen & 1) == 0) {
            throw new IOException("Invalid distinguished name string");
        }
        this.encoded = new byte[hexLen / 2];
        int p = this.beg + 1;
        for (int i = 0; i < this.encoded.length; ++i) {
            this.encoded[i] = (byte)this.getByte(p);
            p += 2;
        }
        return new String(this.chars, this.beg, hexLen);
    }

    private String escapedAV() throws IOException {
        this.beg = this.pos;
        this.end = this.pos;
        block5: while (this.pos < this.chars.length) {
            switch (this.chars[this.pos]) {
                case '+': 
                case ',': 
                case ';': {
                    return new String(this.chars, this.beg, this.end - this.beg);
                }
                case '\\': {
                    this.chars[this.end++] = this.getEscaped();
                    ++this.pos;
                    continue block5;
                }
                case ' ': {
                    int cur = this.end;
                    ++this.pos;
                    this.chars[this.end++] = 32;
                    while (this.pos < this.chars.length && this.chars[this.pos] == ' ') {
                        this.chars[this.end++] = 32;
                        ++this.pos;
                    }
                    if (this.pos != this.chars.length && this.chars[this.pos] != ',' && this.chars[this.pos] != '+' && this.chars[this.pos] != ';') continue block5;
                    return new String(this.chars, this.beg, cur - this.beg);
                }
            }
            this.chars[this.end++] = this.chars[this.pos];
            ++this.pos;
        }
        return new String(this.chars, this.beg, this.end - this.beg);
    }

    private char getEscaped() throws IOException {
        ++this.pos;
        if (this.pos == this.chars.length) {
            throw new IOException("Invalid distinguished name string");
        }
        char ch = this.chars[this.pos];
        switch (ch) {
            case '\"': 
            case '\\': {
                this.hasQE = true;
                return ch;
            }
            case ' ': 
            case '#': 
            case '%': 
            case '*': 
            case '+': 
            case ',': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '_': {
                return ch;
            }
        }
        return this.getUTF8();
    }

    protected char getUTF8() throws IOException {
        int res = this.getByte(this.pos);
        ++this.pos;
        if (res < 128) {
            return (char)res;
        }
        if (res >= 192 && res <= 247) {
            int count;
            if (res <= 223) {
                count = 1;
                res &= 0x1F;
            } else if (res <= 239) {
                count = 2;
                res &= 0xF;
            } else {
                count = 3;
                res &= 7;
            }
            for (int i = 0; i < count; ++i) {
                ++this.pos;
                if (this.pos == this.chars.length || this.chars[this.pos] != '\\') {
                    return '?';
                }
                ++this.pos;
                int b = this.getByte(this.pos);
                ++this.pos;
                if ((b & 0xC0) != 128) {
                    return '?';
                }
                res = (res << 6) + (b & 0x3F);
            }
            return (char)res;
        }
        return '?';
    }

    private int getByte(int position) throws IOException {
        if (position + 1 >= this.chars.length) {
            throw new IOException("Invalid distinguished name string");
        }
        int b1 = this.chars[position];
        if (b1 >= 48 && b1 <= 57) {
            b1 -= 48;
        } else if (b1 >= 97 && b1 <= 102) {
            b1 -= 87;
        } else if (b1 >= 65 && b1 <= 70) {
            b1 -= 55;
        } else {
            throw new IOException("Invalid distinguished name string");
        }
        int b2 = this.chars[position + 1];
        if (b2 >= 48 && b2 <= 57) {
            b2 -= 48;
        } else if (b2 >= 97 && b2 <= 102) {
            b2 -= 87;
        } else if (b2 >= 65 && b2 <= 70) {
            b2 -= 55;
        } else {
            throw new IOException("Invalid distinguished name string");
        }
        return (b1 << 4) + b2;
    }

    public List<List<AttributeTypeAndValue>> parse() throws IOException {
        ArrayList<List<AttributeTypeAndValue>> list = new ArrayList<List<AttributeTypeAndValue>>();
        String attType = this.nextAT();
        if (attType == null) {
            return list;
        }
        ObjectIdentifier oid = AttributeTypeAndValue.getObjectIdentifier(attType);
        ArrayList<AttributeTypeAndValue> atav = new ArrayList<AttributeTypeAndValue>();
        while (true) {
            if (this.pos == this.chars.length) {
                atav.add(new AttributeTypeAndValue(oid, new AttributeValue("", false, oid)));
                list.add(0, atav);
                return list;
            }
            switch (this.chars[this.pos]) {
                case '\"': {
                    atav.add(new AttributeTypeAndValue(oid, new AttributeValue(this.quotedAV(), this.hasQE, oid)));
                    break;
                }
                case '#': {
                    atav.add(new AttributeTypeAndValue(oid, new AttributeValue(this.hexAV(), this.encoded)));
                    break;
                }
                case '+': 
                case ',': 
                case ';': {
                    atav.add(new AttributeTypeAndValue(oid, new AttributeValue("", false, oid)));
                    break;
                }
                default: {
                    atav.add(new AttributeTypeAndValue(oid, new AttributeValue(this.escapedAV(), this.hasQE, oid)));
                }
            }
            if (this.pos >= this.chars.length) {
                list.add(0, atav);
                return list;
            }
            if (this.chars[this.pos] == ',' || this.chars[this.pos] == ';') {
                list.add(0, atav);
                atav = new ArrayList();
            } else if (this.chars[this.pos] != '+') {
                throw new IOException("Invalid distinguished name string");
            }
            ++this.pos;
            attType = this.nextAT();
            if (attType == null) {
                throw new IOException("Invalid distinguished name string");
            }
            oid = AttributeTypeAndValue.getObjectIdentifier(attType);
        }
    }
}

