/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.OsConstants;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.java.AutoCloseable;
import java.io.FileDescriptor;
import java.nio.ByteOrder;
import libcore.io.BufferIterator;
import libcore.io.Libcore;
import libcore.io.MemoryMappedFile_Delegate;
import libcore.io.NioBufferIterator;

public class MemoryMappedFile
implements AutoCloseable {
    private long address;
    private final long size;

    public MemoryMappedFile(long address, long size) {
        this.address = address;
        this.size = size;
    }

    public static MemoryMappedFile mmapRO_Original(String path) throws ErrnoException {
        FileDescriptor fd = Libcore.os.open(path, OsConstants.O_RDONLY, 0);
        long size = Libcore.os.fstat((FileDescriptor)fd).st_size;
        long address = Libcore.os.mmap(0L, size, OsConstants.PROT_READ, OsConstants.MAP_SHARED, fd, 0L);
        Libcore.os.close(fd);
        return new MemoryMappedFile(address, size);
    }

    @LayoutlibDelegate
    public static MemoryMappedFile mmapRO(String string2) throws ErrnoException {
        return MemoryMappedFile_Delegate.mmapRO(string2);
    }

    public synchronized void close_Original() throws ErrnoException {
        if (this.address != 0L) {
            Libcore.os.munmap(this.address, this.size);
            this.address = 0L;
        }
    }

    @Override
    @LayoutlibDelegate
    public synchronized void close() throws ErrnoException {
        MemoryMappedFile_Delegate.close(this);
    }

    public BufferIterator bigEndianIterator_Original() {
        return new NioBufferIterator(this.address, (int)this.size, ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN);
    }

    @LayoutlibDelegate
    public BufferIterator bigEndianIterator() {
        return MemoryMappedFile_Delegate.bigEndianIterator(this);
    }

    public BufferIterator littleEndianIterator() {
        return new NioBufferIterator(this.address, (int)this.size, ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN);
    }

    public long size() {
        return this.size;
    }
}

