/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.impl.DelegateManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.ibm.icu.text.DateIntervalFormat;
import com.ibm.icu.util.DateInterval;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.FieldPosition;

public class DateIntervalFormat_Delegate {
    private static final DelegateManager<DateIntervalFormat_Delegate> sManager = new DelegateManager<DateIntervalFormat_Delegate>(DateIntervalFormat_Delegate.class);
    private DateIntervalFormat mFormat;

    @LayoutlibDelegate
    static String formatDateInterval(long address, long fromDate, long toDate) {
        DateIntervalFormat_Delegate delegate = sManager.getDelegate((int)address);
        if (delegate == null) {
            Bridge.getLog().error("broken", "Unable for find native DateIntervalFormat", null);
            return null;
        }
        DateInterval interval = new DateInterval(fromDate, toDate);
        StringBuffer sb = new StringBuffer();
        FieldPosition pos = new FieldPosition(0);
        delegate.mFormat.format(interval, sb, pos);
        return sb.toString();
    }

    @LayoutlibDelegate
    static long createDateIntervalFormat(String skeleton, String localeName, String tzName) {
        TimeZone prevDefaultTz = TimeZone.getDefault();
        TimeZone.setDefault((TimeZone)TimeZone.getTimeZone((String)tzName));
        DateIntervalFormat_Delegate newDelegate = new DateIntervalFormat_Delegate();
        newDelegate.mFormat = DateIntervalFormat.getInstance((String)skeleton, (ULocale)new ULocale(localeName));
        TimeZone.setDefault((TimeZone)prevDefaultTz);
        return sManager.addNewDelegate(newDelegate);
    }

    @LayoutlibDelegate
    static void destroyDateIntervalFormat(long address) {
        sManager.removeJavaReferenceFor((int)address);
    }
}

