/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import libcore.icu.DateIntervalFormat_Delegate;
import libcore.util.BasicLruCache;

public class DateIntervalFormat {
    public static final int FORMAT_SHOW_TIME = 1;
    public static final int FORMAT_SHOW_WEEKDAY = 2;
    public static final int FORMAT_SHOW_YEAR = 4;
    public static final int FORMAT_NO_YEAR = 8;
    public static final int FORMAT_SHOW_DATE = 16;
    public static final int FORMAT_NO_MONTH_DAY = 32;
    public static final int FORMAT_12HOUR = 64;
    public static final int FORMAT_24HOUR = 128;
    public static final int FORMAT_UTC = 8192;
    public static final int FORMAT_ABBREV_TIME = 16384;
    public static final int FORMAT_ABBREV_WEEKDAY = 32768;
    public static final int FORMAT_ABBREV_MONTH = 65536;
    public static final int FORMAT_NUMERIC_DATE = 131072;
    public static final int FORMAT_ABBREV_ALL = 524288;
    private static final int DAY_IN_MS = 86400000;
    private static final int EPOCH_JULIAN_DAY = 2440588;
    private static final FormatterCache CACHED_FORMATTERS = new FormatterCache();

    private DateIntervalFormat() {
    }

    public static String formatDateRange(long startMs, long endMs, int flags, String olsonId) {
        if ((flags & 0x2000) != 0) {
            olsonId = "UTC";
        }
        TimeZone tz = olsonId != null ? TimeZone.getTimeZone(olsonId) : TimeZone.getDefault();
        return DateIntervalFormat.formatDateRange(Locale.getDefault(), tz, startMs, endMs, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateRange(Locale locale, TimeZone tz, long startMs, long endMs, int flags) {
        Calendar endCalendar;
        Calendar startCalendar = Calendar.getInstance(tz);
        startCalendar.setTimeInMillis(startMs);
        if (startMs == endMs) {
            endCalendar = startCalendar;
        } else {
            endCalendar = Calendar.getInstance(tz);
            endCalendar.setTimeInMillis(endMs);
        }
        boolean endsAtMidnight = DateIntervalFormat.isMidnight(endCalendar);
        if (startMs != endMs && endsAtMidnight && ((flags & 1) == 0 || DateIntervalFormat.dayDistance(startCalendar, endCalendar) <= 1)) {
            endCalendar.roll(5, false);
            endMs -= 86400000L;
        }
        String skeleton = DateIntervalFormat.toSkeleton(startCalendar, endCalendar, flags);
        FormatterCache formatterCache = CACHED_FORMATTERS;
        synchronized (formatterCache) {
            return DateIntervalFormat.formatDateInterval(DateIntervalFormat.getFormatter(skeleton, locale.toString(), tz.getID()), startMs, endMs);
        }
    }

    private static long getFormatter(String skeleton, String localeName, String tzName) {
        String key = skeleton + "\t" + localeName + "\t" + tzName;
        Long formatter = (Long)CACHED_FORMATTERS.get(key);
        if (formatter != null) {
            return formatter;
        }
        long address = DateIntervalFormat.createDateIntervalFormat(skeleton, localeName, tzName);
        CACHED_FORMATTERS.put(key, address);
        return address;
    }

    private static String toSkeleton(Calendar startCalendar, Calendar endCalendar, int flags) {
        if ((flags & 0x80000) != 0) {
            flags |= 0x1C000;
        }
        String monthPart = "MMMM";
        if ((flags & 0x20000) != 0) {
            monthPart = "M";
        } else if ((flags & 0x10000) != 0) {
            monthPart = "MMM";
        }
        String weekPart = "EEEE";
        if ((flags & 0x8000) != 0) {
            weekPart = "EEE";
        }
        String timePart = "j";
        if ((flags & 0x80) != 0) {
            timePart = "H";
        } else if ((flags & 0x40) != 0) {
            timePart = "h";
        }
        if ((flags & 0x4000) == 0 || (flags & 0x80) != 0) {
            timePart = timePart + "m";
        } else if (!DateIntervalFormat.onTheHour(startCalendar) || !DateIntervalFormat.onTheHour(endCalendar)) {
            timePart = timePart + "m";
        }
        if (DateIntervalFormat.fallOnDifferentDates(startCalendar, endCalendar)) {
            flags |= 0x10;
        }
        if (DateIntervalFormat.fallInSameMonth(startCalendar, endCalendar) && (flags & 0x20) != 0) {
            flags &= 0xFFFFFFFD;
            flags &= 0xFFFFFFFE;
        }
        if ((flags & 0x13) == 0) {
            flags |= 0x10;
        }
        if (!((flags & 0x10) == 0 || (flags & 4) != 0 || (flags & 8) != 0 || DateIntervalFormat.fallInSameYear(startCalendar, endCalendar) && DateIntervalFormat.isThisYear(startCalendar))) {
            flags |= 4;
        }
        StringBuilder builder = new StringBuilder();
        if ((flags & 0x30) != 0) {
            if ((flags & 4) != 0) {
                builder.append("y");
            }
            builder.append(monthPart);
            if ((flags & 0x20) == 0) {
                builder.append("d");
            }
        }
        if ((flags & 2) != 0) {
            builder.append(weekPart);
        }
        if ((flags & 1) != 0) {
            builder.append(timePart);
        }
        return builder.toString();
    }

    private static boolean isMidnight(Calendar c) {
        return c.get(11) == 0 && c.get(12) == 0 && c.get(13) == 0 && c.get(14) == 0;
    }

    private static boolean onTheHour(Calendar c) {
        return c.get(12) == 0 && c.get(13) == 0;
    }

    private static boolean fallOnDifferentDates(Calendar c1, Calendar c2) {
        return c1.get(1) != c2.get(1) || c1.get(2) != c2.get(2) || c1.get(5) != c2.get(5);
    }

    private static boolean fallInSameMonth(Calendar c1, Calendar c2) {
        return c1.get(2) == c2.get(2);
    }

    private static boolean fallInSameYear(Calendar c1, Calendar c2) {
        return c1.get(1) == c2.get(1);
    }

    private static boolean isThisYear(Calendar c) {
        Calendar now = Calendar.getInstance(c.getTimeZone());
        return c.get(1) == now.get(1);
    }

    private static int dayDistance(Calendar c1, Calendar c2) {
        return DateIntervalFormat.julianDay(c2) - DateIntervalFormat.julianDay(c1);
    }

    private static int julianDay(Calendar c) {
        long utcMs = c.getTimeInMillis() + (long)c.get(15) + (long)c.get(16);
        return (int)(utcMs / 86400000L) + 2440588;
    }

    @LayoutlibDelegate
    private static long createDateIntervalFormat(String string2, String string3, String string4) {
        return DateIntervalFormat_Delegate.createDateIntervalFormat(string2, string3, string4);
    }

    @LayoutlibDelegate
    private static void destroyDateIntervalFormat(long l) {
        DateIntervalFormat_Delegate.destroyDateIntervalFormat(l);
    }

    @LayoutlibDelegate
    private static String formatDateInterval(long l, long l2, long l3) {
        return DateIntervalFormat_Delegate.formatDateInterval(l, l2, l3);
    }

    static class FormatterCache
    extends BasicLruCache<String, Long> {
        FormatterCache() {
            super(8);
        }

        @Override
        protected void entryEvicted(String key, Long value) {
            DateIntervalFormat.destroyDateIntervalFormat(value);
        }
    }
}

