/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBuffer;
import java.nio.ByteBufferAsDoubleBuffer;
import java.nio.ByteBufferAsFloatBuffer;
import java.nio.ByteBufferAsIntBuffer;
import java.nio.ByteBufferAsLongBuffer;
import java.nio.ByteBufferAsShortBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import libcore.io.Memory;

class ByteArrayBuffer
extends ByteBuffer {
    final byte[] backingArray;
    final int arrayOffset;
    private final boolean isReadOnly;

    ByteArrayBuffer(byte[] backingArray) {
        this(backingArray.length, backingArray, 0, false);
    }

    private ByteArrayBuffer(int capacity, byte[] backingArray, int arrayOffset, boolean isReadOnly) {
        super(capacity, 0L);
        this.backingArray = backingArray;
        this.arrayOffset = arrayOffset;
        this.isReadOnly = isReadOnly;
        if (arrayOffset + capacity > backingArray.length) {
            throw new IndexOutOfBoundsException("backingArray.length=" + backingArray.length + ", capacity=" + capacity + ", arrayOffset=" + arrayOffset);
        }
    }

    private static ByteArrayBuffer copy(ByteArrayBuffer other, int markOfOther, boolean isReadOnly) {
        ByteArrayBuffer buf = new ByteArrayBuffer(other.capacity(), other.backingArray, other.arrayOffset, isReadOnly);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return ByteArrayBuffer.copy(this, this.mark, true);
    }

    @Override
    public ByteBuffer compact() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        System.arraycopy(this.backingArray, this.position + this.arrayOffset, this.backingArray, this.arrayOffset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public ByteBuffer duplicate() {
        return ByteArrayBuffer.copy(this, this.mark, this.isReadOnly);
    }

    @Override
    public ByteBuffer slice() {
        return new ByteArrayBuffer(this.remaining(), this.backingArray, this.arrayOffset + this.position, this.isReadOnly);
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    byte[] protectedArray() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.backingArray;
    }

    int protectedArrayOffset() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.arrayOffset;
    }

    boolean protectedHasArray() {
        return !this.isReadOnly;
    }

    @Override
    public ByteBuffer get(byte[] dst, int dstOffset, int byteCount) {
        this.checkGetBounds(1, dst.length, dstOffset, byteCount);
        System.arraycopy(this.backingArray, this.arrayOffset + this.position, dst, dstOffset, byteCount);
        this.position += byteCount;
        return this;
    }

    void get(char[] dst, int dstOffset, int charCount) {
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, charCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.arrayOffset + this.position, 2, this.order.needsSwap);
        this.position += byteCount;
    }

    void get(double[] dst, int dstOffset, int doubleCount) {
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, doubleCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.arrayOffset + this.position, 8, this.order.needsSwap);
        this.position += byteCount;
    }

    void get(float[] dst, int dstOffset, int floatCount) {
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, floatCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.arrayOffset + this.position, 4, this.order.needsSwap);
        this.position += byteCount;
    }

    void get(int[] dst, int dstOffset, int intCount) {
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, intCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.arrayOffset + this.position, 4, this.order.needsSwap);
        this.position += byteCount;
    }

    void get(long[] dst, int dstOffset, int longCount) {
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, longCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.arrayOffset + this.position, 8, this.order.needsSwap);
        this.position += byteCount;
    }

    void get(short[] dst, int dstOffset, int shortCount) {
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, shortCount);
        Memory.unsafeBulkGet(dst, dstOffset, byteCount, this.backingArray, this.arrayOffset + this.position, 2, this.order.needsSwap);
        this.position += byteCount;
    }

    @Override
    public byte get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.arrayOffset + this.position++];
    }

    @Override
    public byte get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.arrayOffset + index];
    }

    @Override
    public char getChar() {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        char result = (char)Memory.peekShort(this.backingArray, this.arrayOffset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    @Override
    public char getChar(int index) {
        this.checkIndex(index, 2);
        return (char)Memory.peekShort(this.backingArray, this.arrayOffset + index, this.order);
    }

    @Override
    public double getDouble() {
        return Double.longBitsToDouble(this.getLong());
    }

    @Override
    public double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    @Override
    public float getFloat() {
        return Float.intBitsToFloat(this.getInt());
    }

    @Override
    public float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    @Override
    public int getInt() {
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        int result = Memory.peekInt(this.backingArray, this.arrayOffset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        return Memory.peekInt(this.backingArray, this.arrayOffset + index, this.order);
    }

    @Override
    public long getLong() {
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        long result = Memory.peekLong(this.backingArray, this.arrayOffset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        return Memory.peekLong(this.backingArray, this.arrayOffset + index, this.order);
    }

    @Override
    public short getShort() {
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        short result = Memory.peekShort(this.backingArray, this.arrayOffset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        return Memory.peekShort(this.backingArray, this.arrayOffset + index, this.order);
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public ByteBuffer put(byte b) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.arrayOffset + this.position++] = b;
        return this;
    }

    @Override
    public ByteBuffer put(int index, byte b) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index);
        this.backingArray[this.arrayOffset + index] = b;
        return this;
    }

    @Override
    public ByteBuffer put(byte[] src, int srcOffset, int byteCount) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkPutBounds(1, src.length, srcOffset, byteCount);
        System.arraycopy(src, srcOffset, this.backingArray, this.arrayOffset + this.position, byteCount);
        this.position += byteCount;
        return this;
    }

    void put(char[] src, int srcOffset, int charCount) {
        int byteCount = this.checkPutBounds(2, src.length, srcOffset, charCount);
        Memory.unsafeBulkPut(this.backingArray, this.arrayOffset + this.position, byteCount, src, srcOffset, 2, this.order.needsSwap);
        this.position += byteCount;
    }

    void put(double[] src, int srcOffset, int doubleCount) {
        int byteCount = this.checkPutBounds(8, src.length, srcOffset, doubleCount);
        Memory.unsafeBulkPut(this.backingArray, this.arrayOffset + this.position, byteCount, src, srcOffset, 8, this.order.needsSwap);
        this.position += byteCount;
    }

    void put(float[] src, int srcOffset, int floatCount) {
        int byteCount = this.checkPutBounds(4, src.length, srcOffset, floatCount);
        Memory.unsafeBulkPut(this.backingArray, this.arrayOffset + this.position, byteCount, src, srcOffset, 4, this.order.needsSwap);
        this.position += byteCount;
    }

    void put(int[] src, int srcOffset, int intCount) {
        int byteCount = this.checkPutBounds(4, src.length, srcOffset, intCount);
        Memory.unsafeBulkPut(this.backingArray, this.arrayOffset + this.position, byteCount, src, srcOffset, 4, this.order.needsSwap);
        this.position += byteCount;
    }

    void put(long[] src, int srcOffset, int longCount) {
        int byteCount = this.checkPutBounds(8, src.length, srcOffset, longCount);
        Memory.unsafeBulkPut(this.backingArray, this.arrayOffset + this.position, byteCount, src, srcOffset, 8, this.order.needsSwap);
        this.position += byteCount;
    }

    void put(short[] src, int srcOffset, int shortCount) {
        int byteCount = this.checkPutBounds(2, src.length, srcOffset, shortCount);
        Memory.unsafeBulkPut(this.backingArray, this.arrayOffset + this.position, byteCount, src, srcOffset, 2, this.order.needsSwap);
        this.position += byteCount;
    }

    @Override
    public ByteBuffer putChar(int index, char value) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index, 2);
        Memory.pokeShort(this.backingArray, this.arrayOffset + index, (short)value, this.order);
        return this;
    }

    @Override
    public ByteBuffer putChar(char value) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeShort(this.backingArray, this.arrayOffset + this.position, (short)value, this.order);
        this.position = newPosition;
        return this;
    }

    @Override
    public ByteBuffer putDouble(double value) {
        return this.putLong(Double.doubleToRawLongBits(value));
    }

    @Override
    public ByteBuffer putDouble(int index, double value) {
        return this.putLong(index, Double.doubleToRawLongBits(value));
    }

    @Override
    public ByteBuffer putFloat(float value) {
        return this.putInt(Float.floatToRawIntBits(value));
    }

    @Override
    public ByteBuffer putFloat(int index, float value) {
        return this.putInt(index, Float.floatToRawIntBits(value));
    }

    @Override
    public ByteBuffer putInt(int value) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeInt(this.backingArray, this.arrayOffset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    @Override
    public ByteBuffer putInt(int index, int value) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index, 4);
        Memory.pokeInt(this.backingArray, this.arrayOffset + index, value, this.order);
        return this;
    }

    @Override
    public ByteBuffer putLong(int index, long value) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index, 8);
        Memory.pokeLong(this.backingArray, this.arrayOffset + index, value, this.order);
        return this;
    }

    @Override
    public ByteBuffer putLong(long value) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeLong(this.backingArray, this.arrayOffset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    @Override
    public ByteBuffer putShort(int index, short value) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index, 2);
        Memory.pokeShort(this.backingArray, this.arrayOffset + index, value, this.order);
        return this;
    }

    @Override
    public ByteBuffer putShort(short value) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        Memory.pokeShort(this.backingArray, this.arrayOffset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    @Override
    public CharBuffer asCharBuffer() {
        return ByteBufferAsCharBuffer.asCharBuffer(this);
    }

    @Override
    public DoubleBuffer asDoubleBuffer() {
        return ByteBufferAsDoubleBuffer.asDoubleBuffer(this);
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        return ByteBufferAsFloatBuffer.asFloatBuffer(this);
    }

    @Override
    public IntBuffer asIntBuffer() {
        return ByteBufferAsIntBuffer.asIntBuffer(this);
    }

    @Override
    public LongBuffer asLongBuffer() {
        return ByteBufferAsLongBuffer.asLongBuffer(this);
    }

    @Override
    public ShortBuffer asShortBuffer() {
        return ByteBufferAsShortBuffer.asShortBuffer(this);
    }
}

