/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.layoutlib.java;

import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class Charsets {
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static byte[] toAsciiBytes(char[] chars, int offset, int length) {
        CharBuffer cb = CharBuffer.allocate(length);
        cb.put(chars, offset, length);
        return US_ASCII.encode(cb).array();
    }

    public static byte[] toIsoLatin1Bytes(char[] chars, int offset, int length) {
        CharBuffer cb = CharBuffer.allocate(length);
        cb.put(chars, offset, length);
        return ISO_8859_1.encode(cb).array();
    }

    public static byte[] toUtf8Bytes(char[] chars, int offset, int length) {
        CharBuffer cb = CharBuffer.allocate(length);
        cb.put(chars, offset, length);
        return UTF_8.encode(cb).array();
    }

    public static byte[] toBigEndianUtf16Bytes(char[] chars, int offset, int length) {
        byte[] result = new byte[length * 2];
        int end = offset + length;
        int resultIndex = 0;
        for (int i = offset; i < end; ++i) {
            char ch = chars[i];
            result[resultIndex++] = (byte)(ch >> 8);
            result[resultIndex++] = (byte)ch;
        }
        return result;
    }

    public static void asciiBytesToChars(byte[] bytes, int offset, int length, char[] chars) {
        if (bytes == null || chars == null) {
            return;
        }
        int REPLACEMENT_CHAR = 4093;
        int start = offset;
        for (int i = 0; i < length; ++i) {
            int ch;
            chars[i] = (ch = (int)(bytes[start++] & 0xFF)) <= 127 ? ch : 4093;
        }
    }

    public static void isoLatin1BytesToChars(byte[] bytes, int offset, int length, char[] chars) {
        if (bytes == null || chars == null) {
            return;
        }
        int start = offset;
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(bytes[start++] & 0xFF);
        }
    }

    private Charsets() {
    }
}

