/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.AttachInfo_Accessor;
import android.view.View;
import android.widget.FrameLayout;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class RenderDrawable
extends RenderAction<DrawableParams> {
    public RenderDrawable(DrawableParams params) {
        super(new DrawableParams(params));
    }

    public Result render() {
        this.checkLock();
        DrawableParams params = (DrawableParams)this.getParams();
        HardwareConfig hardwareConfig = params.getHardwareConfig();
        ResourceValue drawableResource = params.getDrawable();
        BridgeContext context = this.getContext();
        drawableResource = context.getRenderResources().resolveResValue(drawableResource);
        if (drawableResource == null || drawableResource.getResourceType() != ResourceType.DRAWABLE) {
            return Result.Status.ERROR_NOT_A_DRAWABLE.createResult();
        }
        FrameLayout content = new FrameLayout(context);
        Drawable d = ResourceHelper.getDrawable(drawableResource, context);
        content.setBackground(d);
        AttachInfo_Accessor.setAttachInfo(content);
        int w = hardwareConfig.getScreenWidth();
        int h = hardwareConfig.getScreenHeight();
        int w_spec = View.MeasureSpec.makeMeasureSpec(w, 0x40000000);
        int h_spec = View.MeasureSpec.makeMeasureSpec(h, 0x40000000);
        content.measure(w_spec, h_spec);
        content.layout(0, 0, w, h);
        AttachInfo_Accessor.dispatchOnPreDraw(content);
        BufferedImage image = this.getImage(w, h);
        Bitmap bitmap = Bitmap_Delegate.createBitmap(image, true, hardwareConfig.getDensity());
        Canvas canvas = new Canvas(bitmap);
        canvas.setDensity(hardwareConfig.getDensity().getDpiValue());
        content.draw(canvas);
        return Result.Status.SUCCESS.createResult((Object)image);
    }

    protected BufferedImage getImage(int w, int h) {
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D gc = image.createGraphics();
        gc.setComposite(AlphaComposite.Src);
        gc.setColor(new Color(0, true));
        gc.fillRect(0, 0, w, h);
        gc.dispose();
        return image;
    }
}

