/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParserFactory {
    private static final String ENCODING = "UTF-8";
    public static final boolean LOG_PARSER = false;

    public static XmlPullParser create(File f) throws XmlPullParserException, FileNotFoundException {
        FileInputStream stream = new FileInputStream(f);
        return ParserFactory.create(stream, f.getName(), f.length());
    }

    public static XmlPullParser create(InputStream stream, String name) throws XmlPullParserException {
        return ParserFactory.create(stream, name, -1L);
    }

    private static XmlPullParser create(InputStream stream, String name, long size) throws XmlPullParserException {
        KXmlParser parser = ParserFactory.instantiateParser(name);
        stream = ParserFactory.readAndClose(stream, name, size);
        parser.setInput(stream, ENCODING);
        return parser;
    }

    private static KXmlParser instantiateParser(String name) throws XmlPullParserException {
        KXmlParser parser = name != null ? new CustomParser(name) : new KXmlParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        return parser;
    }

    private static InputStream readAndClose(InputStream stream, String name, long size) throws XmlPullParserException {
        ByteArrayInputStream byteArrayInputStream;
        if (size > Integer.MAX_VALUE) {
            throw new XmlPullParserException("File " + name + " is too big to be parsed");
        }
        int intSize = (int)size;
        BufferedInputStream bufferedStream = new BufferedInputStream(stream);
        try {
            int avail = intSize != -1 ? intSize : bufferedStream.available();
            byte[] buffer = new byte[avail];
            int read = stream.read(buffer);
            if (read == intSize) {
                ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(buffer);
                return byteArrayInputStream2;
            }
            while ((avail = bufferedStream.available()) > 0) {
                if (read + avail > buffer.length) {
                    byte[] moreBuffer = new byte[read + avail];
                    System.arraycopy(buffer, 0, moreBuffer, 0, read);
                    buffer = moreBuffer;
                }
                read += stream.read(buffer, read, avail);
            }
            byteArrayInputStream = new ByteArrayInputStream(buffer);
        }
        catch (IOException e) {
            throw new XmlPullParserException("Failed to read " + name, null, e);
        }
        finally {
            try {
                bufferedStream.close();
            }
            catch (IOException e) {}
        }
        return byteArrayInputStream;
    }

    private static class CustomParser
    extends KXmlParser {
        private final String mName;

        CustomParser(String name) {
            this.mName = name;
        }

        public String toString() {
            return this.mName;
        }
    }
}

