/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl;

import com.android.layoutlib.bridge.util.SparseWeakArray;
import java.util.ArrayList;
import java.util.List;

public final class DelegateManager<T> {
    private final Class<T> mClass;
    private final SparseWeakArray<T> mDelegates = new SparseWeakArray();
    private final List<T> mJavaReferences = new ArrayList<T>();
    private int mDelegateCounter = 0;

    public DelegateManager(Class<T> theClass) {
        this.mClass = theClass;
    }

    public T getDelegate(long native_object) {
        if (native_object > 0L) {
            T delegate = this.mDelegates.get(native_object);
            assert (delegate != null);
            return delegate;
        }
        return null;
    }

    public long addNewDelegate(T newDelegate) {
        long native_object = ++this.mDelegateCounter;
        this.mDelegates.put(native_object, newDelegate);
        assert (!this.mJavaReferences.contains(newDelegate));
        this.mJavaReferences.add(newDelegate);
        return native_object;
    }

    public void removeJavaReferenceFor(long native_object) {
        T delegate = this.getDelegate(native_object);
        this.mJavaReferences.remove(delegate);
    }
}

