/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.bars.IconLoader;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.Density;
import com.android.resources.LayoutDirection;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

abstract class CustomBar
extends LinearLayout {
    private final int mSimulatedPlatformVersion;

    protected abstract TextView getStyleableTextView();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CustomBar(Context context, int orientation, String layoutPath, String name, int simulatedPlatformVersion) throws XmlPullParserException {
        super(context);
        this.mSimulatedPlatformVersion = simulatedPlatformVersion;
        this.setOrientation(orientation);
        if (orientation == 0) {
            this.setGravity(16);
        } else {
            this.setGravity(1);
        }
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        XmlPullParser parser = ParserFactory.create(this.getClass().getResourceAsStream(layoutPath), name);
        BridgeXmlBlockParser bridgeParser = new BridgeXmlBlockParser(parser, (BridgeContext)context, false);
        try {
            inflater.inflate(bridgeParser, (ViewGroup)this, true);
        }
        finally {
            bridgeParser.ensurePopped();
        }
    }

    protected void loadIcon(int index, String iconName, Density density) {
        this.loadIcon(index, iconName, density, false);
    }

    protected void loadIcon(int index, String iconName, Density density, boolean isRtl) {
        View child = this.getChildAt(index);
        if (child instanceof ImageView) {
            ImageView imageView = (ImageView)child;
            Object dir = isRtl ? LayoutDirection.RTL : null;
            IconLoader iconLoader = new IconLoader(iconName, density, this.mSimulatedPlatformVersion, (LayoutDirection)dir);
            InputStream stream = iconLoader.getIcon();
            if (stream != null) {
                density = iconLoader.getDensity();
                String path = iconLoader.getPath();
                Bitmap bitmap = Bridge.getCachedBitmap(path, true);
                if (bitmap == null) {
                    try {
                        bitmap = Bitmap_Delegate.createBitmap(stream, false, density);
                        Bridge.setCachedBitmap(path, bitmap, true);
                    }
                    catch (IOException e) {
                        return;
                    }
                }
                if (bitmap != null) {
                    BitmapDrawable drawable2 = new BitmapDrawable(this.getContext().getResources(), bitmap);
                    imageView.setImageDrawable(drawable2);
                }
            }
        }
    }

    protected TextView setText(int index, String string2, boolean reference) {
        View child = this.getChildAt(index);
        if (child instanceof TextView) {
            TextView textView = (TextView)child;
            this.setText(textView, string2, reference);
            return textView;
        }
        return null;
    }

    private void setText(TextView textView, String string2, boolean reference) {
        ResourceValue value;
        if (reference && (value = this.getResourceValue(string2)) != null) {
            string2 = value.getValue();
        }
        textView.setText(string2);
    }

    protected void setStyle(String themeEntryName) {
        TextView textView;
        Drawable d;
        BridgeContext bridgeContext = (BridgeContext)this.mContext;
        RenderResources res = bridgeContext.getRenderResources();
        ResourceValue value = res.findItemInTheme(themeEntryName, true);
        if (!((value = res.resolveResValue(value)) instanceof StyleResourceValue)) {
            return;
        }
        StyleResourceValue style2 = (StyleResourceValue)value;
        ResourceValue backgroundValue = res.findItemInStyle(style2, "background", true);
        if ((backgroundValue = res.resolveResValue(backgroundValue)) != null && (d = ResourceHelper.getDrawable(backgroundValue, bridgeContext)) != null) {
            this.setBackground(d);
        }
        if ((textView = this.getStyleableTextView()) != null) {
            ResourceValue textStyleValue = res.findItemInStyle(style2, "titleTextStyle", true);
            if ((textStyleValue = res.resolveResValue(textStyleValue)) instanceof StyleResourceValue) {
                ColorStateList stateList;
                StyleResourceValue textStyle = (StyleResourceValue)textStyleValue;
                ResourceValue textSize = res.findItemInStyle(textStyle, "textSize", true);
                if ((textSize = res.resolveResValue(textSize)) != null) {
                    TypedValue out = new TypedValue();
                    if (ResourceHelper.parseFloatAttribute("textSize", textSize.getValue(), out, true)) {
                        textView.setTextSize(0, out.getDimension(bridgeContext.getResources().getDisplayMetrics()));
                    }
                }
                ResourceValue textColor = res.findItemInStyle(textStyle, "textColor", true);
                if ((textColor = res.resolveResValue(textColor)) != null && (stateList = ResourceHelper.getColorStateList(textColor, bridgeContext)) != null) {
                    textView.setTextColor(stateList);
                }
            }
        }
    }

    private ResourceValue getResourceValue(String reference) {
        BridgeContext bridgeContext = (BridgeContext)this.mContext;
        RenderResources res = bridgeContext.getRenderResources();
        ResourceValue value = res.findResValue(reference, false);
        return res.resolveResValue(value);
    }
}

